/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.blocks;

import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.registry.AvatarItems;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeacon;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CloudBlock
extends BlockBreakable {
    public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumDyeColor.class);

    public CloudBlock() {
        super(Material.field_151592_s, false);
        this.func_149647_a(AvatarItems.tabItems);
        this.func_149663_c("avatarmod:cloudblock");
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(COLOR, (Comparable)EnumDyeColor.WHITE));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(COLOR)).func_176765_a();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumDyeColor enumdyecolor : EnumDyeColor.values()) {
            items.add((Object)new ItemStack((Block)this, 1, enumdyecolor.func_176765_a()).func_151001_c(this.getNameFromDye(enumdyecolor)));
        }
    }

    public String getNameFromDye(EnumDyeColor dyeColor) {
        String name;
        if (dyeColor == EnumDyeColor.LIGHT_BLUE) {
            name = "Light Blue Cloud Block";
        } else {
            StringBuilder dyeName = new StringBuilder(dyeColor.func_176762_d());
            char letter = dyeName.charAt(0);
            String firstLetter = String.valueOf(letter).toUpperCase();
            dyeName.deleteCharAt(0);
            dyeName.replace(0, 0, firstLetter);
            name = dyeName.toString() + " Cloud Block";
        }
        return name;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.func_193558_a((EnumDyeColor)((EnumDyeColor)state.func_177229_b(COLOR)));
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    protected boolean func_149700_E() {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.field_176227_L.func_177621_b().func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            BlockBeacon.func_176450_d((World)worldIn, (BlockPos)pos);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            BlockBeacon.func_176450_d((World)worldIn, (BlockPos)pos);
        }
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(COLOR)).func_176765_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COLOR});
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        super.func_176199_a(worldIn, pos, entityIn);
        if (worldIn.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                float[] colours = ((EnumDyeColor)worldIn.func_180495_p(pos).func_177229_b(COLOR)).func_193349_f();
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).element(new Airbending()).clr(0.5f + 0.5f * colours[0], 0.5f + 0.5f * colours[1], 0.5f + 0.5f * colours[2], 0.075f).pos(entityIn.field_70165_t, pos.func_177956_o() + 1, entityIn.field_70161_v).time(15).vel(worldIn.field_73012_v.nextGaussian() / 20.0, worldIn.field_73012_v.nextDouble() / 100.0, worldIn.field_73012_v.nextGaussian() / 20.0).spin(0.25, 0.125).spawn(worldIn);
            }
        }
    }

    public int func_149738_a(World worldIn) {
        return 3;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.field_176227_L.func_177621_b().func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176764_b((int)placer.func_184614_ca().func_77960_j()));
    }
}

