/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.capabilities;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.capabilities.CapabilityHelper;
import com.crowsofwar.avatar.capabilities.IAdvancedGliderCapabilityHandler;
import com.crowsofwar.avatar.network.packets.glider.PacketCSyncGliderDataToClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class GliderCapabilityImplementation {
    private GliderCapabilityImplementation() {
    }

    public static void init() {
        CapabilityManager.INSTANCE.register(IAdvancedGliderCapabilityHandler.class, (Capability.IStorage)new Capability.IStorage<IAdvancedGliderCapabilityHandler>(){

            public NBTBase writeNBT(Capability<IAdvancedGliderCapabilityHandler> capability, IAdvancedGliderCapabilityHandler instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<IAdvancedGliderCapabilityHandler> capability, IAdvancedGliderCapabilityHandler instance, EnumFacing side, NBTBase nbt) {
                if (nbt instanceof NBTTagCompound) {
                    instance.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
                }
            }
        }, DefaultGliderCapImplementation.class);
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        public static final ResourceLocation NAME = new ResourceLocation("avatarmod", "cap");
        private final IAdvancedGliderCapabilityHandler capabilityImplementation = new DefaultGliderCapImplementation();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityHelper.GLIDER_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityHelper.GLIDER_CAPABILITY) {
                return (T)CapabilityHelper.GLIDER_CAPABILITY.cast((Object)this.capabilityImplementation);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)this.capabilityImplementation.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.capabilityImplementation.deserializeNBT((NBTBase)nbt);
        }
    }

    public static class DefaultGliderCapImplementation
    implements IAdvancedGliderCapabilityHandler {
        private static final String CAP_PLAYER_GLIDING = "avatarmod.isPlayerGliding";
        private static final String CAP_GLIDER_DEPLOYED = "avatarmod.isGliderDeployed";
        private static final String CAP_GLIDER_USED = "avatarmod.gliderUsed";
        private boolean isPlayerGliding = false;
        private boolean isGliderDeployed = false;

        @Override
        public boolean getIsPlayerGliding() {
            return this.isGliderDeployed && this.isPlayerGliding;
        }

        @Override
        public void setIsPlayerGliding(boolean isGliding) {
            if (!this.isGliderDeployed && isGliding) {
                AvatarLog.error("Can't set a player to be gliding if they don't have a deployed glider!");
            } else {
                this.isPlayerGliding = isGliding;
            }
        }

        @Override
        public boolean getIsGliderDeployed() {
            return this.isGliderDeployed;
        }

        @Override
        public void setIsGliderDeployed(boolean isDeployed) {
            if (this.isPlayerGliding && isDeployed) {
                AvatarLog.error("Player is already flying, deploying now is not needed.");
            } else {
                this.isGliderDeployed = isDeployed;
            }
            if (!isDeployed) {
                this.isPlayerGliding = false;
            }
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a(CAP_PLAYER_GLIDING, this.isPlayerGliding);
            compound.func_74757_a(CAP_GLIDER_DEPLOYED, this.isGliderDeployed);
            return compound;
        }

        public void deserializeNBT(NBTTagCompound compound) {
            this.setIsPlayerGliding(compound.func_74767_n(CAP_PLAYER_GLIDING));
            this.setIsGliderDeployed(compound.func_74767_n(CAP_GLIDER_DEPLOYED));
        }

        @Override
        public void sync(EntityPlayerMP player) {
            AvatarMod.network.sendTo((IMessage)new PacketCSyncGliderDataToClient(this.serializeNBT()), player);
        }
    }
}

