/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.blocks.AvatarBlocks;
import com.crowsofwar.avatar.item.scroll.ItemScroll;
import com.crowsofwar.avatar.item.scroll.Scrolls;
import com.crowsofwar.avatar.registry.AvatarItem;
import com.crowsofwar.avatar.registry.AvatarItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AvatarItemRenderRegister {
    private static ModelResourceLocation[] locationsRegular;
    private static ModelResourceLocation[] locationsGlow;

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new AvatarItemRenderRegister());
        locationsRegular = new ModelResourceLocation[7];
        locationsGlow = new ModelResourceLocation[7];
        AvatarItemRenderRegister.forScroll(Scrolls.ALL);
        AvatarItemRenderRegister.forScroll(Scrolls.AIR);
        AvatarItemRenderRegister.forScroll(Scrolls.FIRE);
        AvatarItemRenderRegister.forScroll(Scrolls.EARTH);
        AvatarItemRenderRegister.forScroll(Scrolls.LIGHTNING);
        AvatarItemRenderRegister.forScroll(Scrolls.COMBUSTION);
        AvatarItemRenderRegister.forScroll(Scrolls.SAND);
        ModelLoader.setCustomStateMapper((Block)AvatarBlocks.blockCloud, (IStateMapper)new StateMap.Builder().func_178440_a((IProperty)BlockColored.field_176581_a).func_178439_a("_cloudblock").func_178441_a());
        AvatarItemRenderRegister.register(AvatarItems.itemBisonWhistle, new int[0]);
        AvatarItemRenderRegister.forCloudBlock(Item.func_150898_a((Block)AvatarBlocks.blockCloud));
        AvatarItemRenderRegister.register(AvatarItems.emptyExpBottle, new int[0]);
        AvatarItemRenderRegister.registerWithMetadata(AvatarItems.itemWaterPouch, 6);
        AvatarItemRenderRegister.registerWithMetadata(AvatarItems.itemBisonArmor, 4);
        AvatarItemRenderRegister.registerWithMetadata(AvatarItems.itemBisonSaddle, 4);
        AvatarItemRenderRegister.registerWithMetadata(AvatarItems.itemOstrichEquipment, 4);
        AvatarItemRenderRegister.registerWithMetadata((Item)AvatarItems.gliderBasic, 3);
        AvatarItemRenderRegister.registerWithMetadata((Item)AvatarItems.gliderAdv, 3);
        AvatarItemRenderRegister.registerWithMetadata(AvatarItems.gliderPart, 3);
    }

    private static void forScroll(ItemScroll scroll) {
        for (int i = 0; i < 7; ++i) {
            Scrolls.ScrollType type = scroll.getScrollType();
            AvatarItemRenderRegister.locationsRegular[i] = new ModelResourceLocation("avatarmod:scroll_" + type.displayName(), "inventory");
            AvatarItemRenderRegister.locationsGlow[i] = new ModelResourceLocation("avatarmod:scroll_" + type.displayName() + "_glow_" + (i + 1), "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)scroll.item(), (int)i, (ModelResourceLocation)locationsGlow[i]);
        }
    }

    private static void registerWithMetadata(Item item, int subitemCount) {
        int i = 0;
        while (i < subitemCount) {
            AvatarItemRenderRegister.register(item, i++);
        }
    }

    private static void forCloudBlock(Item block) {
        for (int i = 0; i < 16; ++i) {
            String dyeName = EnumDyeColor.func_176764_b((int)i).func_192396_c();
            ModelLoader.setCustomModelResourceLocation((Item)block, (int)i, (ModelResourceLocation)new ModelResourceLocation("avatarmod:" + dyeName + "_cloudblock", "inventory"));
            block.func_77655_b("avatarmod:" + dyeName + "_cloudblock");
        }
    }

    private static void register(Item item, int ... metadata) {
        if (metadata.length == 0) {
            metadata = new int[1];
        }
        if (item instanceof AvatarItem) {
            for (int meta : metadata) {
                ModelResourceLocation mrl = new ModelResourceLocation("avatarmod:" + ((AvatarItem)item).getModelName(meta), "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)((AvatarItem)item).item(), (int)meta, (ModelResourceLocation)mrl);
            }
        } else {
            AvatarLog.info("Name: " + item.getRegistryName());
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(item.getRegistryName(), "inventory")});
            ModelLoader.setCustomMeshDefinition((Item)item, s -> new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    @SubscribeEvent
    public void modelBake(ModelBakeEvent e) {
    }
}

