/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.client.controls.IControlsHandler;
import com.crowsofwar.avatar.client.gui.AvatarUiRenderer;
import com.crowsofwar.avatar.config.ConfigClient;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import com.crowsofwar.avatar.network.packets.PacketSConfirmTransfer;
import com.crowsofwar.avatar.network.packets.PacketSCycleBending;
import com.crowsofwar.avatar.network.packets.PacketSOpenUnlockGui;
import com.crowsofwar.avatar.network.packets.PacketSSkillsMenu;
import com.crowsofwar.avatar.network.packets.PacketSUseStatusControl;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.avatar.util.event.BendingCycleEvent;
import com.crowsofwar.avatar.util.event.BendingUseEvent;
import com.crowsofwar.gorecore.format.FormattedMessageProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class ClientInput
implements IControlsHandler {
    private final Minecraft mc;
    private final List<BendingStyle> keyboardBending;
    private final boolean[] wasAbilityDown;
    private GameSettings gameSettings;
    private Map<String, KeyBinding> keybindings;
    private boolean mouseLeft;
    private boolean mouseRight;
    private boolean mouseMiddle;
    private boolean wasLeft;
    private boolean wasRight;
    private boolean wasMiddle;
    private boolean press;

    public ClientInput() {
        this.gameSettings = Minecraft.func_71410_x().field_71474_y;
        this.wasMiddle = false;
        this.wasRight = false;
        this.wasLeft = false;
        this.mouseMiddle = false;
        this.mouseRight = false;
        this.mouseLeft = false;
        this.mc = Minecraft.func_71410_x();
        this.keybindings = new HashMap<String, KeyBinding>();
        this.keyboardBending = new ArrayList<BendingStyle>();
        this.addKeybinding("Bend", 56, "main");
        this.addKeybinding("BendingCycleLeft", 44, "main");
        this.addKeybinding("BendingCycleRight", 47, "main");
        this.addKeybinding("Skills", 37, "main");
        this.addKeybinding("Switch", 19, "main");
        this.addKeybinding("TransferBison", 24, "main");
        this.wasAbilityDown = new boolean[Abilities.all().size()];
    }

    private KeyBinding addKeybinding(String name, int key, String cat) {
        KeyBinding kb = new KeyBinding("avatar." + name, key, "avatar.category." + cat);
        this.keybindings.put(name, kb);
        ClientRegistry.registerKeyBinding((KeyBinding)kb);
        return kb;
    }

    @Override
    public boolean isControlPressed(AvatarControl control) {
        if (control == AvatarControl.CONTROL_LEFT_CLICK) {
            return this.mouseLeft;
        }
        if (control == AvatarControl.CONTROL_RIGHT_CLICK) {
            return this.mouseRight;
        }
        if (control == AvatarControl.CONTROL_MIDDLE_CLICK) {
            return this.mouseMiddle;
        }
        if (control == AvatarControl.CONTROL_LEFT_CLICK_DOWN) {
            return this.mouseLeft && !this.wasLeft;
        }
        if (control == AvatarControl.CONTROL_RIGHT_CLICK_DOWN) {
            return this.mouseRight && !this.wasRight;
        }
        if (control == AvatarControl.CONTROL_MIDDLE_CLICK_DOWN) {
            return this.mouseMiddle && !this.wasMiddle;
        }
        if (control == AvatarControl.CONTROL_LEFT_CLICK_UP) {
            return !this.mouseLeft && this.wasLeft;
        }
        if (control == AvatarControl.CONTROL_RIGHT_CLICK_UP) {
            return !this.mouseRight && this.wasRight;
        }
        if (control == AvatarControl.CONTROL_MIDDLE_CLICK_UP) {
            return !this.mouseMiddle && this.wasMiddle;
        }
        if (control == AvatarControl.CONTROL_SHIFT) {
            return Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151468_f();
        }
        if (control == AvatarControl.CONTROL_JUMP) {
            return Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151468_f();
        }
        AvatarLog.warn(AvatarLog.WarningType.INVALID_CODE, "ClientInput- Unknown control: " + control);
        return false;
    }

    @Override
    public boolean isControlDown(AvatarControl control) {
        if (control == AvatarControl.CONTROL_LEFT_CLICK) {
            return this.mouseLeft;
        }
        if (control == AvatarControl.CONTROL_RIGHT_CLICK) {
            return this.mouseRight;
        }
        if (control == AvatarControl.CONTROL_MIDDLE_CLICK) {
            return this.mouseMiddle;
        }
        if (control == AvatarControl.CONTROL_LEFT_CLICK_DOWN) {
            return this.mouseLeft;
        }
        if (control == AvatarControl.CONTROL_RIGHT_CLICK_DOWN) {
            return this.mouseRight;
        }
        if (control == AvatarControl.CONTROL_MIDDLE_CLICK_DOWN) {
            return this.mouseMiddle;
        }
        if (control == AvatarControl.CONTROL_LEFT_CLICK_UP) {
            return !this.mouseLeft;
        }
        if (control == AvatarControl.CONTROL_RIGHT_CLICK_UP) {
            return !this.mouseRight;
        }
        if (control == AvatarControl.CONTROL_MIDDLE_CLICK_UP) {
            return !this.mouseMiddle;
        }
        if (control == AvatarControl.CONTROL_SHIFT) {
            return Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151470_d();
        }
        if (control == AvatarControl.CONTROL_JUMP) {
            return Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
        }
        AvatarLog.warn(AvatarLog.WarningType.INVALID_CODE, "ClientInput- Unknown control: " + control);
        return false;
    }

    @Override
    public int getKeyCode(AvatarControl control) {
        String keyName = control.getName().substring("avatar.".length());
        KeyBinding kb = this.keybindings.get(keyName);
        if (kb == null) {
            AvatarLog.warn("Key control '" + keyName + "' is undefined");
        }
        return kb == null ? -1 : kb.func_151463_i();
    }

    @Override
    public String getDisplayName(AvatarControl control) {
        if (control.isKeybinding()) {
            KeyBinding kb = this.keybindings.get(control.getName().substring("avatar.".length()));
            return kb == null ? null : kb.getDisplayName();
        }
        return null;
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.KeyInputEvent e) {
        this.tryOpenBendingMenu();
        this.tryCycleBending();
        if (AvatarControl.KEY_SKILLS.isPressed()) {
            BendingData data = BendingData.getFromEntity((EntityLivingBase)this.mc.field_71439_g);
            if (data != null) {
                BendingStyle active = data.getActiveBending();
                if (active == null) {
                    AvatarMod.network.sendToServer((IMessage)new PacketSOpenUnlockGui());
                } else {
                    AvatarMod.network.sendToServer((IMessage)new PacketSSkillsMenu(active.getId()));
                }
            }
            if (AvatarControl.KEY_TRANSFER_BISON.isPressed()) {
                AvatarMod.network.sendToServer((IMessage)new PacketSConfirmTransfer());
            }
        }
    }

    private boolean isAbilityPressed(Ability ability) {
        Integer key = ConfigClient.CLIENT_CONFIG.keymappings.get(ability);
        if (key != null) {
            if (key < 0 && Mouse.isButtonDown((int)(key + 100))) {
                return true;
            }
            return key >= 0 && Keyboard.isKeyDown((int)key);
        }
        return false;
    }

    private void tryOpenBendingMenu() {
        BendingData data = BendingData.getFromEntity((EntityLivingBase)this.mc.field_71439_g);
        if (AvatarControl.KEY_USE_BENDING.isPressed() && !AvatarUiRenderer.hasBendingGui()) {
            if (data != null && data.getActiveBending() != null) {
                if (!MinecraftForge.EVENT_BUS.post((Event)new BendingUseEvent((EntityLivingBase)this.mc.field_71439_g, data.getActiveBending()))) {
                    AvatarUiRenderer.openBendingGui(data.getActiveBendingId());
                }
            } else {
                ConfigClient.CLIENT_CONFIG.getClass();
                String message = I18n.func_135052_a((String)AvatarChatMessages.MSG_DONT_HAVE_BENDING.getTranslateKey(), (Object[])new Object[0]);
                message = FormattedMessageProcessor.formatText(AvatarChatMessages.MSG_DONT_HAVE_BENDING, message, this.mc.field_71439_g.func_70005_c_());
                this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(message));
            }
        }
    }

    private void tryCycleBending() {
        if (AvatarControl.KEY_BENDING_CYCLE_LEFT.isPressed() && !AvatarUiRenderer.hasBendingGui() && !MinecraftForge.EVENT_BUS.post((Event)new BendingCycleEvent((EntityLivingBase)this.mc.field_71439_g, false))) {
            AvatarMod.network.sendToServer((IMessage)new PacketSCycleBending(false));
        }
        if (AvatarControl.KEY_BENDING_CYCLE_RIGHT.isPressed() && !AvatarUiRenderer.hasBendingGui() && !MinecraftForge.EVENT_BUS.post((Event)new BendingCycleEvent((EntityLivingBase)this.mc.field_71439_g, true))) {
            AvatarMod.network.sendToServer((IMessage)new PacketSCycleBending(true));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        BendingData data;
        this.wasLeft = this.mouseLeft;
        this.wasRight = this.mouseRight;
        this.wasMiddle = this.mouseMiddle;
        if (this.mc.field_71415_G) {
            this.mouseLeft = Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d();
            this.mouseRight = Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d();
            this.mouseMiddle = Minecraft.func_71410_x().field_71474_y.field_74322_I.func_151470_d();
        } else {
            this.mouseMiddle = false;
            this.mouseRight = false;
            this.mouseLeft = false;
        }
        EntityPlayerSP player = this.mc.field_71439_g;
        if (player != null && player.field_70170_p != null && Objects.requireNonNull(Bender.get((EntityLivingBase)player)).getInfo().getId() != null && (data = BendingData.getFromEntity((EntityLivingBase)player)) != null) {
            if (this.mc.field_71415_G) {
                List<AvatarControl> pressed = this.getAllPressed();
                List<StatusControl> statusControls = data.getAllStatusControls();
                for (StatusControl sc : statusControls) {
                    if (!pressed.contains(sc.getSubscribedControl())) continue;
                    Raytrace.Result raytrace = Raytrace.getTargetBlock((EntityLivingBase)player, sc.getRaytrace());
                    if (sc.execute(new BendingContext(data, (EntityLivingBase)player, raytrace))) {
                        data.removeStatusControl(sc);
                    }
                    AvatarMod.network.sendToServer((IMessage)new PacketSUseStatusControl(sc, raytrace));
                }
            }
            boolean isSwitchPathKeyDown = AvatarControl.KEY_SWITCH.isDown();
            ArrayList<Ability> allAbilities = Abilities.all();
            for (int i = 0; i < allAbilities.size(); ++i) {
                boolean conflict;
                Ability ability = (Ability)allAbilities.get(i);
                boolean down = this.isAbilityPressed(ability);
                if (!ConfigClient.CLIENT_CONFIG.conflicts.containsKey(ability)) {
                    ConfigClient.CLIENT_CONFIG.conflicts.put(ability, false);
                }
                if (!(conflict = ConfigClient.CLIENT_CONFIG.conflicts.get(ability).booleanValue()) && this.mc.field_71415_G && this.mc.field_71462_r == null && down && !this.wasAbilityDown[i]) {
                    Raytrace.Result raytrace = Raytrace.getTargetBlock((EntityLivingBase)this.mc.field_71439_g, ability.getRaytrace());
                    if (data.hasBendingId(ability.getBendingId()) && player.func_184812_l_() || data.canUse(ability)) {
                        Bender.get((EntityLivingBase)player).executeAbility(ability, raytrace, isSwitchPathKeyDown);
                    }
                }
                this.wasAbilityDown[i] = down;
            }
        }
    }

    @Override
    public List<AvatarControl> getAllPressed() {
        ArrayList<AvatarControl> list = new ArrayList<AvatarControl>();
        for (AvatarControl control : AvatarControl.ALL_CONTROLS) {
            if (!control.isPressed()) continue;
            list.add(control);
        }
        return list;
    }
}

