/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.client.gui.AvatarUiRenderer;
import com.crowsofwar.avatar.client.gui.skills.SkillsGui;
import com.crowsofwar.avatar.network.IPacketHandler;
import com.crowsofwar.avatar.network.packets.PacketCErrorMessage;
import com.crowsofwar.avatar.network.packets.PacketCOpenSkillCard;
import com.crowsofwar.avatar.network.packets.PacketCParticles;
import com.crowsofwar.avatar.network.packets.PacketCPowerRating;
import com.crowsofwar.avatar.network.packets.PacketCSyncAbilityProperties;
import com.crowsofwar.avatar.network.packets.glider.PacketCClientGliding;
import com.crowsofwar.avatar.network.packets.glider.PacketCSyncGliderDataToClient;
import com.crowsofwar.avatar.network.packets.glider.PacketCUpdateClientTarget;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.helper.GliderHelper;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PacketHandlerClient
implements IPacketHandler {
    private final Minecraft mc = Minecraft.func_71410_x();

    @Override
    public IMessage onPacketReceived(IMessage packet, MessageContext ctx) {
        if (packet instanceof PacketCParticles) {
            return this.handlePacketParticles((PacketCParticles)packet, ctx, ((PacketCParticles)packet).getVelIsMagnitude());
        }
        if (packet instanceof PacketCErrorMessage) {
            return this.handlePacketNotEnoughChi((PacketCErrorMessage)packet, ctx);
        }
        if (packet instanceof PacketCPowerRating) {
            return this.handlePacketPowerRating((PacketCPowerRating)packet, ctx);
        }
        if (packet instanceof PacketCOpenSkillCard) {
            return this.handlePacketSkillCard((PacketCOpenSkillCard)packet, ctx);
        }
        if (packet instanceof PacketCClientGliding) {
            return this.handlePacketClientGliding((PacketCClientGliding)packet, ctx);
        }
        if (packet instanceof PacketCSyncGliderDataToClient) {
            return this.handlePacketSyncGliderDataToClient((PacketCSyncGliderDataToClient)packet, ctx);
        }
        if (packet instanceof PacketCUpdateClientTarget) {
            return this.handlePacketUpdateClientTarget((PacketCUpdateClientTarget)packet, ctx);
        }
        if (packet instanceof PacketCSyncAbilityProperties) {
            return this.handleSyncProperties((PacketCSyncAbilityProperties)packet, ctx);
        }
        AvatarLog.warn(AvatarLog.WarningType.WEIRD_PACKET, "Client recieved unknown packet from server:" + packet);
        return null;
    }

    @Override
    public Side getSide() {
        return Side.CLIENT;
    }

    private IMessage handlePacketParticles(PacketCParticles packet, MessageContext ctx, boolean velIsMagnitude) {
        EnumParticleTypes particle = packet.getParticle();
        if (particle == null) {
            AvatarLog.warn(AvatarLog.WarningType.WEIRD_PACKET, "Unknown particle recieved from server");
            return null;
        }
        Random random = new Random();
        int particles = random.nextInt(packet.getMaximum() - packet.getMinimum() + 1) + packet.getMinimum();
        for (int i = 0; i < particles; ++i) {
            this.mc.field_71441_e.func_175688_a(particle, packet.getX(), packet.getY(), packet.getZ(), velIsMagnitude ? packet.getMaxVelocityX() * random.nextGaussian() : packet.getMaxVelocityX() * random.nextDouble(), velIsMagnitude ? packet.getMaxVelocityY() * random.nextGaussian() : packet.getMaxVelocityY() * random.nextDouble(), velIsMagnitude ? packet.getMaxVelocityZ() * random.nextGaussian() : packet.getMaxVelocityZ() * random.nextDouble(), new int[0]);
        }
        return null;
    }

    private IMessage handlePacketPowerRating(PacketCPowerRating packet, MessageContext ctx) {
        Map<UUID, Double> powerRatings = packet.getPowerRatings();
        BendingData data = BendingData.getFromEntity((EntityLivingBase)this.mc.field_71439_g);
        Set<Map.Entry<UUID, Double>> entrySet = powerRatings.entrySet();
        for (Map.Entry<UUID, Double> entry : entrySet) {
            if (data == null || data.getPowerRatingManager(entry.getKey()) == null) continue;
            data.getPowerRatingManager(entry.getKey()).setCachedRatingValue(entry.getValue());
        }
        return null;
    }

    private IMessage handlePacketNotEnoughChi(PacketCErrorMessage packet, MessageContext ctx) {
        AvatarUiRenderer.displayErrorMessage(packet.getMessage());
        return null;
    }

    private IMessage handlePacketSkillCard(PacketCOpenSkillCard packet, MessageContext ctx) {
        if (this.mc.field_71462_r instanceof SkillsGui) {
            ((SkillsGui)this.mc.field_71462_r).openWindow(packet.getAbility());
        }
        return null;
    }

    private IMessage handlePacketClientGliding(PacketCClientGliding packet, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            EntityPlayer player = AvatarMod.proxy.getClientPlayer();
            if (player != null) {
                GliderHelper.setIsGliderDeployed(player, packet.isGliding);
            }
        });
        return null;
    }

    private IMessage handlePacketSyncGliderDataToClient(PacketCSyncGliderDataToClient packet, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            AvatarMod.proxy.getClientGliderCapability().deserializeNBT((NBTBase)packet.nbt);
            AvatarLog.debug("** RECEIVED GLIDER SYNC INFO CLIENTSIDE **");
        });
        return null;
    }

    private IMessage handlePacketUpdateClientTarget(PacketCUpdateClientTarget packet, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            World world = AvatarMod.proxy.getClientWorld();
            EntityPlayer targetEntity = (EntityPlayer)world.func_73045_a(packet.targetEntityID);
            if (targetEntity != null) {
                GliderHelper.setIsGliderDeployed(targetEntity, packet.isGliding);
            }
        });
        return null;
    }

    private IMessage handleSyncProperties(PacketCSyncAbilityProperties packet, MessageContext ctx) {
        if (ctx.side.isServer()) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                for (int i = 0; i < packet.properties.length; ++i) {
                    Abilities.all().get(i).setProperties(packet.properties[i]);
                }
            });
        } else {
            for (int i = 0; i < packet.properties.length; ++i) {
                Abilities.all().get(i).setProperties(packet.properties[i]);
            }
        }
        return null;
    }
}

