/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.controls;

import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.client.controls.KeybindingWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;

public class AvatarControl {
    public static List<AvatarControl> ALL_CONTROLS;
    public static AvatarControl KEY_USE_BENDING;
    public static AvatarControl KEY_BENDING_CYCLE_LEFT;
    public static AvatarControl KEY_BENDING_CYCLE_RIGHT;
    public static AvatarControl KEY_SKILLS;
    public static AvatarControl KEY_SWITCH;
    public static AvatarControl KEY_TRANSFER_BISON;
    public static AvatarControl CONTROL_LEFT_CLICK;
    public static AvatarControl CONTROL_RIGHT_CLICK;
    public static AvatarControl CONTROL_MIDDLE_CLICK;
    public static AvatarControl CONTROL_LEFT_CLICK_DOWN;
    public static AvatarControl CONTROL_RIGHT_CLICK_DOWN;
    public static AvatarControl CONTROL_MIDDLE_CLICK_DOWN;
    public static AvatarControl CONTROL_JUMP;
    public static AvatarControl CONTROL_LEFT_CLICK_UP;
    public static AvatarControl CONTROL_RIGHT_CLICK_UP;
    public static AvatarControl CONTROL_MIDDLE_CLICK_UP;
    public static AvatarControl CONTROL_SHIFT;
    private final String name;
    private KeybindingWrapper kb;
    private boolean needsKeybinding;

    private AvatarControl(String name, boolean keybinding) {
        this.name = name;
        this.needsKeybinding = keybinding;
        ALL_CONTROLS.add(this);
    }

    public static void initControls() {
        ALL_CONTROLS = new ArrayList<AvatarControl>();
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        KEY_USE_BENDING = new AvatarControl("avatar.Bend", true);
        KEY_BENDING_CYCLE_LEFT = new AvatarControl("avatar.BendingCycleLeft", true);
        KEY_BENDING_CYCLE_RIGHT = new AvatarControl("avatar.BendingCycleRight", true);
        KEY_SKILLS = new AvatarControl("avatar.Skills", true);
        KEY_SWITCH = new AvatarControl("avatar.Switch", true);
        KEY_TRANSFER_BISON = new AvatarControl("avatar.TransferBison", true);
        CONTROL_LEFT_CLICK = new AvatarControl(settings.field_74312_F.func_151464_g(), false);
        CONTROL_RIGHT_CLICK = new AvatarControl(settings.field_74313_G.func_151464_g(), false);
        CONTROL_MIDDLE_CLICK = new AvatarControl("MiddleClick", false);
        CONTROL_LEFT_CLICK_DOWN = new AvatarControl("LeftClickDown", false);
        CONTROL_RIGHT_CLICK_DOWN = new AvatarControl("RightClickDown", false);
        CONTROL_MIDDLE_CLICK_DOWN = new AvatarControl("MiddleClickDown", false);
        CONTROL_JUMP = new AvatarControl(settings.field_74314_A.func_151464_g(), false);
        CONTROL_LEFT_CLICK_UP = new AvatarControl("LeftClickUp", false);
        CONTROL_RIGHT_CLICK_UP = new AvatarControl("RightClickUp", false);
        CONTROL_MIDDLE_CLICK_UP = new AvatarControl("MiddleClickUp", false);
        CONTROL_SHIFT = new AvatarControl(settings.field_74311_E.func_151464_g(), false);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public KeybindingWrapper getKeybinding() {
        if (this.needsKeybinding && this.kb == null) {
            this.kb = AvatarMod.proxy.createKeybindWrapper(this.name);
        }
        return this.kb;
    }

    public boolean isKeybinding() {
        return this.getKeybinding() != null;
    }

    public boolean isPressed() {
        return this.isKeybinding() ? this.getKeybinding().isPressed() : AvatarMod.proxy.getKeyHandler().isControlPressed(this);
    }

    public boolean isDown() {
        return this.isKeybinding() ? this.getKeybinding().isDown() : AvatarMod.proxy.getKeyHandler().isControlDown(this);
    }
}

