/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.event;

import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.client.model_loaders.obj.ObjLoader;
import com.crowsofwar.avatar.client.model_loaders.obj.ObjModel;
import com.crowsofwar.avatar.config.ConfigGlider;
import com.crowsofwar.avatar.item.IGlider;
import com.crowsofwar.avatar.item.ItemGliderBase;
import com.crowsofwar.avatar.util.helper.GliderHelper;
import com.crowsofwar.avatar.util.helper.GliderPlayerHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GliderRenderHandler {
    private boolean needToPop = false;
    private final ObjModel modelGlider = ObjLoader.load(ItemGliderBase.MODEL_GLIDER_RL);

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRender(RenderPlayerEvent.Pre event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer playerEntity = (EntityPlayer)event.getEntity();
            if (GliderHelper.getIsGliderDeployed((EntityPlayer)event.getEntity())) {
                if (!GliderPlayerHelper.shouldBeGliding(playerEntity)) {
                    return;
                }
                if (Minecraft.func_71410_x().field_71462_r instanceof GuiInventory) {
                    return;
                }
                this.setRotationThirdPersonPerspective(event.getEntityPlayer(), event.getPartialRenderTick());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onRender(RenderPlayerEvent.Post event) {
        ModelPlayer playerModel = event.getRenderer().func_177087_b();
        playerModel.field_178724_i.field_78795_f = 125.0f;
        playerModel.field_178723_h.field_78796_g = 125.0f;
        if (this.needToPop) {
            this.needToPop = false;
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderWorldLastEvent event) {
        EntityPlayerSP playerEntity;
        if (ConfigGlider.GLIDER_CONFIG.enableRenderingFPP && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && GliderHelper.getIsGliderDeployed((EntityPlayer)(playerEntity = Minecraft.func_71410_x().field_71439_g)) && GliderPlayerHelper.shouldBeGliding((EntityPlayer)playerEntity)) {
            this.renderGliderFirstPersonPerspective(event);
        }
    }

    private void renderGliderFirstPersonPerspective(RenderWorldLastEvent event) {
        EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
        ItemStack gliderStack = GliderHelper.getGlider((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (gliderStack == null || gliderStack.func_190926_b()) {
            return;
        }
        ResourceLocation resourceLocation = ((IGlider)gliderStack.func_77973_b()).getModelTexture(gliderStack);
        this.setRotationFirstPersonPerspective((EntityPlayer)entityPlayer, event.getPartialTicks());
        this.setLightingBeforeRendering((EntityPlayer)entityPlayer, event.getPartialTicks());
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)1.5, (double)0.0);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.35f);
        this.modelGlider.renderAll();
        GlStateManager.func_179121_F();
    }

    private void setLightingBeforeRendering(EntityPlayer player, float partialTicks) {
        GlStateManager.func_179145_e();
        int i = player.func_70070_b();
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
    }

    private void setRotationFirstPersonPerspective(EntityPlayer player, float partialTicks) {
        double interpolatedYaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * partialTicks;
        GlStateManager.func_179114_b((float)((float)(-interpolatedYaw)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)ConfigGlider.GLIDER_CONFIG.gliderVisibilityFPPShiftAmount, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.5f);
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-1.0f * ConfigGlider.GLIDER_CONFIG.shiftSpeedVisualShift));
        }
    }

    private void setRotationThirdPersonPerspective(EntityPlayer player, float partialTicks) {
        player.field_70721_aZ = 0.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)(-player.field_70759_as), (float)0.0f, (float)1.0f, (float)0.0f);
        float interpolatedPitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks + 90.0f;
        GlStateManager.func_179114_b((float)interpolatedPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        float interpolatedYaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) - partialTicks;
        GlStateManager.func_179114_b((float)interpolatedYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        this.needToPop = true;
    }

    @SubscribeEvent
    public void onHandRender(RenderSpecificHandEvent event) {
        EntityPlayer player = AvatarMod.proxy.getClientPlayer();
        if ((ConfigGlider.GLIDER_CONFIG.disableOffhandRenderingWhenGliding || ConfigGlider.GLIDER_CONFIG.disableHandleBarRenderingWhenGliding) && GliderHelper.getIsGliderDeployed(player)) {
            if (ConfigGlider.GLIDER_CONFIG.disableHandleBarRenderingWhenGliding) {
                event.setCanceled(true);
            } else if (ConfigGlider.GLIDER_CONFIG.disableOffhandRenderingWhenGliding && !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof IGlider && !((IGlider)player.func_184614_ca().func_77973_b()).isBroken(player.func_184614_ca()) && event.getHand() == EnumHand.OFF_HAND) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onScroll(MouseEvent event) {
        EntityPlayer player;
        int wheelState = event.getDwheel();
        if (wheelState != 0 && GliderHelper.getIsGliderDeployed(player = AvatarMod.proxy.getClientPlayer())) {
            GliderHelper.setIsGliderDeployed(player, false);
        }
    }
}

