/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.gui;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.BendingStyles;
import com.crowsofwar.avatar.client.gui.ContainerBisonChest;
import com.crowsofwar.avatar.client.gui.ContainerGetBending;
import com.crowsofwar.avatar.client.gui.ContainerSkillsGui;
import com.crowsofwar.avatar.entity.mob.EntitySkyBison;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class AvatarGuiHandler
implements IGuiHandler {
    public static final int GUI_ID_BISON_CHEST = 5;
    public static final int GUI_ID_GET_BENDING = 6;

    public static int getGuiId(UUID bendingId) {
        return 100 + BendingStyles.getNetworkId(bendingId);
    }

    public static UUID getBendingId(int guiId) {
        return BendingStyles.get((byte)(guiId - 100)).getId();
    }

    public static boolean isBendingGui(int guiId) {
        return guiId > 100 && BendingStyles.has(AvatarGuiHandler.getBendingId(guiId));
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (AvatarGuiHandler.isBendingGui(id)) {
            return new ContainerSkillsGui(player, AvatarGuiHandler.getBendingId(id));
        }
        if (id == 5) {
            int bisonId = x;
            EntitySkyBison bison = EntitySkyBison.findBison(world, bisonId);
            if (bison != null) {
                return new ContainerBisonChest((IInventory)player.field_71071_by, (IInventory)bison.getInventory(), bison, player);
            }
            AvatarLog.warn(AvatarLog.WarningType.WEIRD_PACKET, player.func_70005_c_() + " tried to open skybison inventory, was not found. BisonId: " + bisonId);
        }
        if (id == 6) {
            return new ContainerGetBending(player);
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return AvatarMod.proxy.createClientGui(id, player, world, x, y, z);
    }
}

