/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.gui;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.BendingStyles;
import com.crowsofwar.avatar.client.AvatarShaderUtils;
import com.crowsofwar.avatar.client.gui.AvatarUiTextures;
import com.crowsofwar.avatar.client.gui.BendingMenuInfo;
import com.crowsofwar.avatar.client.gui.RadialMenu;
import com.crowsofwar.avatar.client.gui.RadialSegment;
import com.crowsofwar.avatar.client.gui.skills.SkillsGui;
import com.crowsofwar.avatar.client.uitools.ScreenInfo;
import com.crowsofwar.avatar.config.ConfigClient;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityAirBubble;
import com.crowsofwar.avatar.entity.EntityIcePrison;
import com.crowsofwar.avatar.entity.EntityIceShield;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.Chi;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.Vision;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class AvatarUiRenderer
extends Gui {
    public static AvatarUiRenderer instance;
    private final Minecraft mc = Minecraft.func_71410_x();
    private RadialMenu currentBendingMenu;
    private RadialSegment fadingSegment;
    private long timeFadeStart;
    private long errorMsgFade;
    private String errorMsg;

    public AvatarUiRenderer() {
        instance = this;
        this.errorMsgFade = -1L;
        this.errorMsg = "";
    }

    public static void openBendingGui(UUID bending) {
        BendingStyle controller = BendingStyles.get(bending);
        assert (controller != null);
        BendingMenuInfo menu = controller.getRadialMenu();
        AvatarUiRenderer.instance.currentBendingMenu = new RadialMenu(controller, menu.getTheme(), menu.getButtons());
        AvatarUiRenderer.instance.mc.func_71364_i();
    }

    public static boolean hasBendingGui() {
        return AvatarUiRenderer.instance.currentBendingMenu != null;
    }

    public static void fade(RadialSegment segment) {
        AvatarUiRenderer.instance.fadingSegment = segment;
        AvatarUiRenderer.instance.timeFadeStart = System.currentTimeMillis();
    }

    public static void displayErrorMessage(String message) {
        AvatarUiRenderer.instance.errorMsgFade = System.currentTimeMillis();
        AvatarUiRenderer.instance.errorMsg = message;
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onGuiRender(RenderGameOverlayEvent.Post e) {
        ScaledResolution resolution = e.getResolution();
        if (e.isCancelable()) {
            e.setCanceled(false);
        }
        if (e.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            this.renderBattleStatus(resolution);
            this.renderRadialMenu(resolution);
            this.renderChiBar(resolution);
            this.renderChiMsg(resolution);
            this.renderActiveBending(resolution);
            this.renderAirBubbleHealth(resolution);
            this.renderIceShieldHealth(resolution);
            this.renderStatusControls(resolution);
            this.applyVisionShader();
            this.renderPrisonCracks(resolution);
        }
    }

    private void renderCooldown(ScaledResolution res) {
        ScreenInfo.refreshDimensions();
        BendingData data = BendingData.getFromEntity((EntityLivingBase)this.mc.field_71439_g);
        if (data != null && data.getActiveBending() != null) {
            List abilities = Abilities.all().stream().filter(ability -> ability.getElement().equals(data.getActiveBending())).collect(Collectors.toList());
            for (Ability ability2 : abilities) {
                this.mc.func_110434_K().func_110577_a(AvatarUiTextures.STATUS_CONTROL_ICONS);
                int centerX = res.func_78326_a() / 2;
                int centerY = res.func_78328_b() / 2;
                double scale = 0.5;
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179140_f();
                GlStateManager.func_179084_k();
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
                GlStateManager.func_179121_F();
            }
        }
    }

    private void renderRadialMenu(ScaledResolution resolution) {
        int mouseX = Mouse.getX() * resolution.func_78326_a() / this.mc.field_71443_c;
        int mouseY = resolution.func_78328_b() - Mouse.getY() * resolution.func_78328_b() / this.mc.field_71440_d;
        GlStateManager.func_179094_E();
        GL11.glEnable((int)3008);
        if (this.currentBendingMenu != null) {
            if (this.currentBendingMenu.updateScreen(mouseX, mouseY, resolution)) {
                this.currentBendingMenu = null;
                if (!(this.mc.field_71462_r instanceof SkillsGui)) {
                    this.mc.func_71381_h();
                }
            } else {
                this.currentBendingMenu.drawScreen(mouseX, mouseY, resolution);
                this.mc.func_71364_i();
            }
        }
        if (this.fadingSegment != null) {
            float timeToFade = 500.0f;
            long timeSinceStart = System.currentTimeMillis() - this.timeFadeStart;
            if ((float)timeSinceStart > timeToFade) {
                this.fadingSegment = null;
            } else {
                float scale = (float)(1.0 + Math.sqrt((float)timeSinceStart / 10000.0f));
                float f = 1.0f - (float)timeSinceStart / timeToFade;
                ConfigClient.CLIENT_CONFIG.getClass();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(f * 0.75f));
                float f2 = 1.0f - (float)timeSinceStart / timeToFade;
                ConfigClient.CLIENT_CONFIG.getClass();
                this.fadingSegment.draw(true, resolution, f2 * 0.75f, scale);
            }
        }
        GlStateManager.func_179121_F();
    }

    private void renderStatusControls(ScaledResolution resolution) {
        ScreenInfo.refreshDimensions();
        BendingData data = BendingData.getFromEntity((EntityLivingBase)this.mc.field_71439_g);
        if (data != null) {
            List<StatusControl> statusControls = data.getAllStatusControls();
            for (StatusControl statusControl : statusControls) {
                this.mc.func_110434_K().func_110577_a(AvatarUiTextures.STATUS_CONTROL_ICONS);
                int centerX = resolution.func_78326_a() / 2;
                int centerY = resolution.func_78328_b() / 2;
                int xOffset = statusControl.getPosition().xOffset();
                int yOffset = statusControl.getPosition().yOffset();
                double scale = 0.5;
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179140_f();
                GlStateManager.func_179084_k();
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
                this.func_73729_b((int)((double)(centerX - xOffset) / scale), (int)((double)(centerY - yOffset) / scale), statusControl.getTextureU(), statusControl.getTextureV(), 16, 16);
                GlStateManager.func_179121_F();
            }
        }
    }

    private void renderChiBar(ScaledResolution resolution) {
        ScreenInfo.refreshDimensions();
        ConfigClient.CLIENT_CONFIG.chiBarSettings.getClass();
        BendingData data = BendingData.getFromEntity((EntityLivingBase)this.mc.field_71439_g);
        if (data != null) {
            ConfigClient.CLIENT_CONFIG.chiBarSettings.getClass();
            boolean shouldRender = true;
            if (shouldRender) {
                float alpha;
                float f;
                if (data.hasTickHandler(TickHandlerController.RENDER_ELEMENT_HANDLER)) {
                    ConfigClient.CLIENT_CONFIG.chiBarSettings.getClass();
                    float f2 = 200.0f - (float)data.getTickHandlerDuration(TickHandlerController.RENDER_ELEMENT_HANDLER);
                    ConfigClient.CLIENT_CONFIG.chiBarSettings.getClass();
                    f = f2 / 200.0f * ConfigClient.CLIENT_CONFIG.chiBarAlpha;
                } else {
                    f = alpha = ConfigClient.CLIENT_CONFIG.chiBarAlpha;
                }
                if (data.getAllBending().isEmpty()) {
                    return;
                }
                Chi chi = data.chi();
                float total = chi.getTotalChi();
                float max = chi.getMaxChi();
                float available = chi.getAvailableChi();
                float unavailable = total - available;
                float scale = 1.1f;
                float width = 100.0f * scale;
                ConfigClient.CLIENT_CONFIG.chiBarSettings.getClass();
                float height = 9.0f * 1.1f;
                this.mc.func_110434_K().func_110577_a(AvatarUiTextures.getChiTexture(data.getActiveBendingId()));
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                float f3 = resolution.func_78326_a() - ConfigClient.CLIENT_CONFIG.chiBarSettings.xPos;
                float f4 = (float)resolution.func_78328_b() - height;
                ConfigClient.CLIENT_CONFIG.chiBarSettings.getClass();
                GlStateManager.func_179109_b((float)f3, (float)(f4 - 3.0f), (float)0.0f);
                ConfigClient.CLIENT_CONFIG.chiBarSettings.getClass();
                ConfigClient.CLIENT_CONFIG.chiBarSettings.getClass();
                GlStateManager.func_179139_a((double)1.1f, (double)1.1f, (double)1.0);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                this.func_73729_b(0, 0, 0, 36, 100, 9);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 1.5f));
                this.func_73729_b(0, 0, 0, 27, (int)(99.0f * (available + unavailable) / max), 9);
                this.func_73729_b(0, 0, 0, 45, (int)(98.0f * unavailable / max), 9);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                ConfigClient.CLIENT_CONFIG.chiBarSettings.getClass();
                this.func_73731_b(this.mc.field_71466_p, (int)total + "/" + (int)max + ", " + (int)available, 25, -10, data.getActiveBending().getTextColour() | (int)(alpha * 255.0f) << 24);
                GlStateManager.func_179121_F();
            }
        }
    }

    private void renderChiMsg(ScaledResolution res) {
        ScreenInfo.refreshDimensions();
        GlStateManager.func_179094_E();
        if (this.errorMsgFade != -1L) {
            float seconds = (float)(System.currentTimeMillis() - this.errorMsgFade) / 1000.0f;
            float alpha = seconds < 1.0f ? 1.0f : 1.0f - (seconds - 1.0f);
            int alphaI = (int)(alpha * 255.0f);
            if (alphaI < 4) {
                alphaI = 4;
            }
            String text = TextFormatting.BOLD + I18n.func_135052_a((String)this.errorMsg, (Object[])new Object[0]);
            this.func_73731_b(this.mc.field_71466_p, text, (res.func_78326_a() - this.mc.field_71466_p.func_78256_a(text)) / 2, res.func_78328_b() - this.mc.field_71466_p.field_78288_b - 40, 0xFFFFFF | alphaI << 24);
            if (seconds >= 2.0f) {
                this.errorMsgFade = -1L;
            }
        }
        GlStateManager.func_179121_F();
    }

    private void renderActiveBending(ScaledResolution res) {
        ScreenInfo.refreshDimensions();
        ConfigClient.CLIENT_CONFIG.activeBendingSettings.getClass();
        BendingData data = BendingData.getFromEntity((EntityLivingBase)this.mc.field_71439_g);
        if (data != null) {
            ConfigClient.CLIENT_CONFIG.activeBendingSettings.getClass();
            boolean shouldRender = true;
            if (shouldRender && data.getActiveBending() != null) {
                int indexPrevious;
                float f;
                GlStateManager.func_179094_E();
                if (data.hasTickHandler(TickHandlerController.RENDER_ELEMENT_HANDLER)) {
                    ConfigClient.CLIENT_CONFIG.activeBendingSettings.getClass();
                    float f2 = 200.0f - (float)data.getTickHandlerDuration(TickHandlerController.RENDER_ELEMENT_HANDLER);
                    ConfigClient.CLIENT_CONFIG.activeBendingSettings.getClass();
                    float f3 = f2 / 200.0f;
                    ConfigClient.CLIENT_CONFIG.getClass();
                    f = f3 * 0.75f;
                } else {
                    ConfigClient.CLIENT_CONFIG.getClass();
                    f = 0.75f;
                }
                float alpha = f;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                ConfigClient.CLIENT_CONFIG.activeBendingSettings.getClass();
                this.drawBendingIcon(0, ConfigClient.CLIENT_CONFIG.activeBendingSettings.middleYPosition, data.getActiveBending(), ConfigClient.CLIENT_CONFIG.activeBendingSettings.rightXPosition, ConfigClient.CLIENT_CONFIG.activeBendingSettings.rightXPosition);
                GlStateManager.func_179121_F();
                List<BendingStyle> allBending = data.getAllBending();
                allBending.sort(Comparator.comparing(BendingStyle::getName));
                int indexNext = allBending.indexOf(data.getActiveBending()) + 1;
                if (indexNext == allBending.size()) {
                    indexNext = 0;
                }
                if (allBending.size() > 1) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                    int n = ConfigClient.CLIENT_CONFIG.activeBendingSettings.rightXPosition;
                    ConfigClient.CLIENT_CONFIG.activeBendingSettings.getClass();
                    ConfigClient.CLIENT_CONFIG.activeBendingSettings.getClass();
                    ConfigClient.CLIENT_CONFIG.activeBendingSettings.getClass();
                    this.drawBendingIcon(n, 5, allBending.get(indexNext), 35.0, 35.0);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.5f));
                    GlStateManager.func_179121_F();
                }
                if ((indexPrevious = allBending.indexOf(data.getActiveBending()) - 1) <= -1) {
                    indexPrevious = allBending.size() - 1;
                }
                if (allBending.size() > 2) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                    int n = ConfigClient.CLIENT_CONFIG.activeBendingSettings.leftXPosition;
                    ConfigClient.CLIENT_CONFIG.activeBendingSettings.getClass();
                    ConfigClient.CLIENT_CONFIG.activeBendingSettings.getClass();
                    ConfigClient.CLIENT_CONFIG.activeBendingSettings.getClass();
                    this.drawBendingIcon(n, 5, allBending.get(indexPrevious), 35.0, 35.0);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.5f));
                    GlStateManager.func_179121_F();
                }
            }
        }
    }

    private void drawBendingIcon(int xOff, int yOff, BendingStyle controller, double width, double height) {
        ScreenInfo.refreshDimensions();
        int x = ScreenInfo.screenWidth() / ScreenInfo.scaleFactor() - 85 + xOff;
        int y = ScreenInfo.screenHeight() / ScreenInfo.scaleFactor() - 60 + yOff;
        int level = 0;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (BendingData.getFromEntity((EntityLivingBase)player) != null) {
            List<Ability> abilities = controller.getAllAbilities();
            abilities = abilities.stream().filter(arg_0 -> AvatarUiRenderer.lambda$drawBendingIcon$1((EntityPlayer)player, arg_0)).collect(Collectors.toList());
            for (Ability ability : abilities) {
                AbilityData aD = AbilityData.get((EntityLivingBase)player, ability.getName());
                if (aD.getLevel() <= -1) continue;
                level += aD.getLevel() + 1;
            }
        }
        this.mc.field_71446_o.func_110577_a(AvatarUiTextures.getBendingIconTexture(controller.getId(), level));
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179139_a((double)(width / 256.0), (double)(height / 256.0), (double)1.0);
        this.func_73729_b(0, 0, 0, 0, 256, 256);
        GlStateManager.func_179121_F();
    }

    private void renderAirBubbleHealth(ScaledResolution res) {
        EntityAirBubble bubble;
        ScreenInfo.refreshDimensions();
        WorldClient world = this.mc.field_71441_e;
        EntityPlayerSP player = this.mc.field_71439_g;
        BendingData data = BendingData.getFromEntity((EntityLivingBase)player);
        if (data != null && data.hasStatusControl(StatusControlController.BUBBLE_CONTRACT) && (bubble = AvatarEntity.lookupControlledEntity((World)world, EntityAirBubble.class, (EntityLivingBase)player)) != null && bubble.getOwner() == player) {
            this.renderShieldHealth(res, bubble.getHealth(), bubble.getMaxHealth(), 0);
        }
    }

    private void renderIceShieldHealth(ScaledResolution res) {
        EntityIceShield shield;
        ScreenInfo.refreshDimensions();
        WorldClient world = this.mc.field_71441_e;
        EntityPlayerSP player = this.mc.field_71439_g;
        BendingData data = BendingData.getFromEntity((EntityLivingBase)player);
        if (data != null && data.hasStatusControl(StatusControlController.SHIELD_SHATTER) && (shield = AvatarEntity.lookupControlledEntity((World)world, EntityIceShield.class, (EntityLivingBase)player)) != null && shield.getOwner() == player) {
            this.renderShieldHealth(res, shield.getHealth(), shield.getMaxHealth(), 9);
        }
    }

    private void renderShieldHealth(ScaledResolution res, float health, float maxHealth, int textureV) {
        ScreenInfo.refreshDimensions();
        GlStateManager.func_179094_E();
        this.mc.field_71446_o.func_110577_a(AvatarUiTextures.shieldHealth);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = res.func_78326_a() / 2 - 91;
        int y = res.func_78328_b() - GuiIngameForge.left_height;
        if (this.mc.field_71439_g.func_184812_l_()) {
            --y;
        } else if (this.mc.field_71439_g.func_70658_aO() == 0) {
            y += 10;
        }
        int hearts = (int)(maxHealth / 2.0f);
        for (int i = 0; i < hearts; ++i) {
            this.func_73729_b(x + i * 9, y, 0, textureV, 9, 9);
            int diff = (int)(health - (float)(i * 2));
            if (diff >= 2) {
                this.func_73729_b(x + i * 9, y, 18, textureV, 9, 9);
                continue;
            }
            if (diff != 1) continue;
            this.func_73729_b(x + i * 9, y, 27, textureV, 9, 9);
        }
        GlStateManager.func_179121_F();
    }

    private void renderPrisonCracks(ScaledResolution res) {
        ScreenInfo.refreshDimensions();
        EntityPlayerSP player = this.mc.field_71439_g;
        EntityIcePrison prison = EntityIcePrison.getPrison((EntityLivingBase)player);
        if (prison != null) {
            GlStateManager.func_179094_E();
            float scaledWidth = res.func_78326_a();
            float scaledHeight = res.func_78328_b();
            float scaleX = scaledWidth / 256.0f;
            float scaleY = scaledHeight / 256.0f;
            float scale = Math.max(scaleX, scaleY);
            GlStateManager.func_179109_b((float)((scaledWidth - scale * 256.0f) / 2.0f), (float)((scaledHeight - scale * 256.0f) / 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            this.mc.field_71446_o.func_110577_a(AvatarUiTextures.ICE);
            this.func_73729_b(0, 0, 0, 0, 256, 256);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            float percent = 1.0f - (float)prison.getImprisonedTime() / (float)prison.getMaxImprisonedTime();
            int crackIndex = (int)(percent * percent * percent * (float)(AvatarUiTextures.BLOCK_BREAK.length + 1)) - 1;
            if (crackIndex > -1) {
                this.mc.field_71446_o.func_110577_a(AvatarUiTextures.BLOCK_BREAK[crackIndex]);
                this.func_73729_b(0, 0, 0, 0, 256, 256);
            }
            GlStateManager.func_179121_F();
        }
    }

    private void applyVisionShader() {
        BendingData data = BendingData.getFromEntity((EntityLivingBase)this.mc.field_71439_g);
        if (data != null) {
            Vision vision = data.getVision();
            if (vision != null) {
                AvatarShaderUtils.useShader(vision.getShaderLocation());
            } else {
                AvatarShaderUtils.stopUsingShader();
            }
        }
    }

    private void renderBattleStatus(ScaledResolution res) {
        ScreenInfo.refreshDimensions();
        BendingData data = BendingData.getFromEntity((EntityLivingBase)this.mc.field_71439_g);
        if (data != null) {
            if (data.getAllBending().isEmpty()) {
                return;
            }
            String text = "Performance: " + (int)data.getPerformance().getScore();
            FontRenderer fr = this.mc.field_71466_p;
            this.func_73731_b(fr, text, res.func_78326_a() - fr.func_78256_a(text) - 10, 10, 0xFFFFFF);
            text = "PowerRating: " + (int)data.getPowerRatingManager(data.getActiveBendingId()).getRating(null);
            fr = this.mc.field_71466_p;
            this.func_73731_b(fr, text, res.func_78326_a() - fr.func_78256_a(text) - 10, 20, 0xFFFFFF);
        }
    }

    private static /* synthetic */ boolean lambda$drawBendingIcon$1(EntityPlayer player, Ability ability) {
        return AbilityData.get((EntityLivingBase)player, ability.getName()).getLevel() > -1;
    }
}

