/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.gui;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.BendingStyles;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.util.ResourceLocation;

public class AvatarUiTextures {
    public static final ResourceLocation skillsGui = new ResourceLocation("avatarmod", "textures/gui/skillmenu.png");
    public static final ResourceLocation getBending = new ResourceLocation("avatarmod", "textures/gui/getbending.png");
    public static final ResourceLocation shieldHealth = new ResourceLocation("avatarmod", "textures/gui/shield_health.png");
    public static final ResourceLocation STATUS_CONTROL_ICONS = new ResourceLocation("avatarmod", "textures/gui/status_controls.png");
    public static final ResourceLocation ICE = new ResourceLocation("minecraft", "textures/blocks/ice.png");
    public static final ResourceLocation[] BLOCK_BREAK = AvatarUiTextures.getBlockBreakTextures();
    public static final ResourceLocation WHITE = new ResourceLocation("avatarmod", "textures/gui/white.png");
    private static final Map<Ability, ResourceLocation> abilityTextures = new HashMap<Ability, ResourceLocation>();
    private static final Map<BendingStyle, ResourceLocation> radialTextures = new HashMap<BendingStyle, ResourceLocation>();
    private static final Map<Ability, ResourceLocation> abilityCards = new HashMap<Ability, ResourceLocation>();
    private static final Map<Ability, ResourceLocation> abilityCardsPlain = new HashMap<Ability, ResourceLocation>();
    private static final Map<UUID, ResourceLocation> bendingBackgrounds = new HashMap<UUID, ResourceLocation>();
    private static final Map<UUID, ResourceLocation> bendingIcons = new HashMap<UUID, ResourceLocation>();
    private static final Map<UUID, Integer> bendingBackgroundWidth = new HashMap<UUID, Integer>();

    private static <T> ResourceLocation getCachedImage(Map<T, ResourceLocation> map, T obj, String loc) {
        if (!map.containsKey(obj)) {
            ResourceLocation location = new ResourceLocation("avatarmod", loc);
            map.put(obj, location);
            return location;
        }
        return map.get(obj);
    }

    public static ResourceLocation getAbilityTexture(Ability ability) {
        return AvatarUiTextures.getCachedImage(abilityTextures, ability, "textures/radial/icon_" + ability.getName() + ".png");
    }

    public static ResourceLocation getBendingRadialTexture(BendingStyle element) {
        return AvatarUiTextures.getCachedImage(radialTextures, element, "textures/radial/" + element.getName() + "_segment.png");
    }

    public static ResourceLocation getCardTexture(Ability ability) {
        return AvatarUiTextures.getCachedImage(abilityCards, ability, "textures/gui/skillmenu/" + ability.getName() + ".png");
    }

    public static ResourceLocation getPlainCardTexture(Ability ability) {
        return AvatarUiTextures.getCachedImage(abilityCardsPlain, ability, "textures/gui/skillmenu/" + ability.getName() + "_plain.png");
    }

    public static ResourceLocation getBendingIconTexture(UUID bendingId, int totalLevel) {
        List<Ability> abilities = BendingStyles.get(bendingId).getAllAbilities();
        int maxLevel = abilities.size() * 4;
        int level = Math.min(3, (int)((float)totalLevel / (float)maxLevel * 4.0f));
        String bendingName = BendingStyles.getName(bendingId);
        String suffix = level > 0 ? "_" + level : "";
        String location = "textures/gui/icon/" + bendingName + suffix + ".png";
        return new ResourceLocation("avatarmod", location);
    }

    public static ResourceLocation getBendingBackgroundTexture(UUID bendingId) {
        String bendingName = BendingStyles.getName(bendingId);
        String location = "textures/gui/background/" + bendingName + ".png";
        return AvatarUiTextures.getCachedImage(bendingBackgrounds, bendingId, location);
    }

    public static ResourceLocation getChiTexture(UUID bendingID) {
        BendingStyle style = BendingStyles.get(bendingID);
        String suffix = "_" + style.getName();
        String prefix = "chi";
        return new ResourceLocation("avatarmod", "textures/gui/chi/" + prefix + suffix + ".png");
    }

    public static float getBendingBackgroundWidth(UUID bendingId) {
        if (bendingBackgroundWidth.containsKey(bendingId)) {
            return bendingBackgroundWidth.get(bendingId).intValue();
        }
        String bendingName = BendingStyles.getName(bendingId);
        InputStream instr = null;
        try {
            String path = "assets/avatarmod/textures/gui/background/";
            String file = path + bendingName + ".png";
            BufferedImage image = ImageIO.read(AvatarUiTextures.class.getClassLoader().getResourceAsStream(file));
            int width = image.getWidth();
            bendingBackgroundWidth.put(bendingId, width);
            float f = width;
            return f;
        }
        catch (Exception ex) {
            throw new RuntimeException("Problem getting width of " + bendingName + " background image", ex);
        }
        finally {
            if (instr != null) {
                try {
                    instr.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static float getBendingBackgroundHeight(UUID bendingId) {
        return AvatarUiTextures.getBendingBackgroundWidth(bendingId) * 9.0f / 16.0f;
    }

    private static ResourceLocation[] getBlockBreakTextures() {
        ResourceLocation[] array = new ResourceLocation[10];
        for (int i = 0; i < array.length; ++i) {
            array[i] = new ResourceLocation("minecraft", "textures/blocks/destroy_stage_" + i + ".png");
        }
        return array;
    }
}

