/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.gui;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.client.gui.MenuTheme;
import java.util.List;
import java.util.stream.Collectors;

public class BendingMenuInfo {
    private final Ability[] buttons;
    private MenuTheme theme;

    public BendingMenuInfo(MenuTheme theme, BendingStyle bending) {
        List<Ability> buttons = bending.getAllAbilities();
        buttons = buttons.stream().filter(Ability::isVisibleInRadial).collect(Collectors.toList());
        if (buttons.size() > 8) {
            throw new IllegalArgumentException("Cannot get BendingMenuInfo with buttons being larger than 8");
        }
        this.theme = theme;
        this.buttons = new Ability[8];
        for (int i = 0; i < 8; ++i) {
            this.buttons[i] = i < buttons.size() ? buttons.get(i) : null;
        }
    }

    public MenuTheme getTheme() {
        return this.theme;
    }

    public Ability[] getButtons() {
        return this.buttons;
    }
}

