/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.gui;

import java.awt.Color;

public class MenuTheme {
    private final ThemeColor background;
    private final ThemeColor edge;
    private final ThemeColor icon;
    private final int text;

    public MenuTheme(ThemeColor background, ThemeColor edge, ThemeColor icon, int text) {
        this.background = background;
        this.edge = edge;
        this.icon = icon;
        this.text = text;
    }

    public ThemeColor getBackground() {
        return this.background;
    }

    public ThemeColor getEdge() {
        return this.edge;
    }

    public ThemeColor getIcon() {
        return this.icon;
    }

    public int getText() {
        return this.text;
    }

    public static class ThemeColor {
        private final int r;
        private final int g;
        private final int b;
        private final int hoverR;
        private final int hoverG;
        private final int hoverB;

        public ThemeColor(Color def, Color hover) {
            this(def.getRed(), def.getGreen(), def.getBlue(), hover.getRed(), hover.getGreen(), hover.getBlue());
        }

        public ThemeColor(int r, int g, int b, int hoverR, int hoverG, int hoverB) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.hoverR = hoverR;
            this.hoverG = hoverG;
            this.hoverB = hoverB;
        }

        public ThemeColor(int rgb, int rgbHover) {
            this(new Color(rgb), new Color(rgbHover));
        }

        public int getRed(boolean hover) {
            return hover ? this.hoverR : this.r;
        }

        public int getGreen(boolean hover) {
            return hover ? this.hoverG : this.g;
        }

        public int getBlue(boolean hover) {
            return hover ? this.hoverB : this.b;
        }
    }
}

