/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.gui;

import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.client.gui.AvatarUiRenderer;
import com.crowsofwar.avatar.client.gui.MenuTheme;
import com.crowsofwar.avatar.client.gui.RadialSegment;
import com.crowsofwar.avatar.config.ConfigClient;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.network.packets.PacketSSkillsMenu;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.gorecore.format.FormattedMessage;
import com.crowsofwar.gorecore.format.FormattedMessageProcessor;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.ArrayUtils;

public class RadialMenu
extends Gui {
    public static final int segmentX = 207;
    public static final int segmentY = 296;
    public static final float menuScale = 0.36f;
    private static final FormattedMessage MSG_RADIAL_XP = FormattedMessage.newChatMessage("avatar.radial.xp", "level", "xp");
    private final BendingStyle controller;
    private final Minecraft mc = Minecraft.func_71410_x();
    private final Bender bender;
    private final RadialSegment[] segments;
    private final Ability[] controls;
    private final MenuTheme theme;
    private RadialSegment prevMouseover;
    private int ticksExisted;

    public RadialMenu(BendingStyle controller, MenuTheme theme, Ability ... controls) {
        int i;
        this.controller = controller;
        this.theme = theme;
        this.segments = new RadialSegment[8];
        this.ticksExisted = 0;
        if (controls == null) {
            throw new IllegalArgumentException("Controls is null");
        }
        if (controls.length > 8) {
            throw new IllegalArgumentException("The length of controls can't be more than 8");
        }
        Ability[] ctrl = new Ability[8];
        for (i = 0; i < ctrl.length; ++i) {
            ctrl[i] = i < controls.length ? controls[i] : null;
        }
        this.controls = ctrl;
        for (i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new RadialSegment(this, theme, i, controls[i], controller);
        }
        this.bender = Bender.get((EntityLivingBase)this.mc.field_71439_g);
    }

    public void drawScreen(int mouseX, int mouseY, ScaledResolution resolution) {
        float scale = this.ticksExisted <= 10 ? 0.5f + (float)Math.sqrt((float)this.ticksExisted / 40.0f) : 1.0f;
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i] == null) continue;
            boolean hover = this.segments[i].isMouseHover(mouseX, mouseY, resolution);
            RadialSegment radialSegment = this.segments[i];
            ConfigClient.CLIENT_CONFIG.getClass();
            radialSegment.draw(hover, resolution, scale * 0.75f, scale * 0.9f);
            if (!hover) continue;
            this.displaySegmentDetails(this.controls[i], resolution);
        }
    }

    private void displaySegmentDetails(Ability ability, ScaledResolution resolution) {
        String nameKey = ability == null ? "avatar.ability.undefined" : "avatar.ability." + ability.getName();
        int x = resolution.func_78326_a() / 2;
        int y = (int)((double)(resolution.func_78328_b() / 2) - (double)this.mc.field_71466_p.field_78288_b * 1.5);
        BendingData data = BendingData.getFromEntity((EntityLivingBase)this.mc.field_71439_g);
        if (data != null) {
            String second;
            int level = 0;
            String secondKey = "avatar.radial.undefined";
            Object[] secondArgs = new String[]{"", ""};
            if (ability != null) {
                AbilityData abilityData = data.getAbilityData(ability);
                level = abilityData.getLevel();
                secondKey = "avatar.radial.xp";
                secondArgs[0] = abilityData.getLevel() + "";
                secondArgs[1] = (int)abilityData.getXp() + "";
                if (abilityData.getLevel() == 3) {
                    String path = abilityData.getPath() == AbilityData.AbilityTreePath.FIRST ? "1" : "2";
                    secondKey = nameKey + ".lvl4_" + path;
                }
                boolean creative = this.mc.field_71439_g.field_71075_bZ.field_75098_d;
                if (abilityData.isLocked() && !creative) {
                    secondKey = "avatar.radial.locked2";
                    secondArgs[0] = AvatarMod.proxy.getKeyHandler().getDisplayName(AvatarControl.KEY_SKILLS) + "";
                    nameKey = "avatar.radial.locked1";
                }
                if (abilityData.isLocked() && creative) {
                    secondKey = "avatar.radial.lockedCreative2";
                }
            }
            if ((second = I18n.func_135052_a((String)secondKey, (Object[])new Object[0])).contains(" ;; ")) {
                second = second.substring(0, second.indexOf(" ;; "));
            }
            second = FormattedMessageProcessor.formatText(MSG_RADIAL_XP, second, ArrayUtils.addAll((Object[])secondArgs, (Object[])new String[]{level + ""}));
            this.func_73732_a(this.mc.field_71466_p, second, x, (int)((double)(resolution.func_78328_b() / 2) + (double)this.mc.field_71466_p.field_78288_b * 0.5), 0xFFFFFF);
        }
        this.func_73732_a(this.mc.field_71466_p, I18n.func_135052_a((String)nameKey, (Object[])new Object[0]), x, y, 0xFFFFFF);
    }

    private void playClickSound(float pitch) {
        this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)this.controller.getRadialMenuSound(), (float)pitch));
    }

    public boolean updateScreen(int mouseX, int mouseY, ScaledResolution resolution) {
        ++this.ticksExisted;
        boolean closeGui = !AvatarControl.KEY_USE_BENDING.isDown() || this.mc.field_71474_y.field_74312_F.func_151470_d();
        BendingData data = BendingData.getFromEntity((EntityLivingBase)this.mc.field_71439_g);
        if (data != null) {
            RadialSegment currentMouseover = null;
            for (RadialSegment segment : this.segments) {
                if (!segment.isMouseHover(mouseX, mouseY, resolution)) continue;
                currentMouseover = segment;
                break;
            }
            if (currentMouseover != null && currentMouseover != this.prevMouseover) {
                this.playClickSound(1.3f);
            }
            this.prevMouseover = currentMouseover;
            if (currentMouseover == null) {
                int centerX = resolution.func_78326_a() / 2;
                int centerY = resolution.func_78328_b() / 2;
                MenuTheme theme = this.controller.getRadialMenu().getTheme();
                this.func_73732_a(this.mc.field_71466_p, "" + TextFormatting.BOLD + I18n.func_135052_a((String)("avatar." + this.controller.getName()), (Object[])new Object[0]), centerX, centerY - this.mc.field_71466_p.field_78288_b, theme.getText());
            }
            if (closeGui && ConfigSkills.SKILLS_CONFIG.abilitySettings.useRadialMouse) {
                for (int i = 0; i < this.segments.length; ++i) {
                    if (this.controls[i] == null || !this.segments[i].isMouseHover(mouseX, mouseY, resolution)) continue;
                    boolean isSwitchPathKeyDown = AvatarControl.KEY_SWITCH.isDown();
                    this.bender.executeAbility(this.controls[i], isSwitchPathKeyDown);
                    AvatarUiRenderer.fade(this.segments[i]);
                    this.playClickSound(0.8f);
                    break;
                }
            }
            if (ConfigSkills.SKILLS_CONFIG.abilitySettings.useRadialNumbers) {
                for (int i = 0; i < 8; ++i) {
                    KeyBinding binding = Minecraft.func_71410_x().field_71474_y.field_151456_ac[i];
                    if (!binding.func_151470_d() || this.controls[i] == null) continue;
                    boolean isSwitchPathKeyDown = AvatarControl.KEY_SWITCH.isDown();
                    this.bender.executeAbility(this.controls[i], isSwitchPathKeyDown);
                    AvatarUiRenderer.fade(this.segments[i]);
                    this.playClickSound(0.8f);
                    closeGui = true;
                    break;
                }
            }
            if (this.mc.field_71474_y.field_74313_G.func_151470_d() && currentMouseover != null) {
                UUID activeBendingId = data.getActiveBendingId();
                AvatarMod.network.sendToServer((IMessage)new PacketSSkillsMenu(activeBendingId, currentMouseover.getAbility()));
                closeGui = true;
            }
        } else {
            closeGui = true;
        }
        return closeGui;
    }
}

