/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.gui.skills;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.client.gui.AvatarUiTextures;
import com.crowsofwar.avatar.client.uitools.ComponentImage;
import com.crowsofwar.avatar.client.uitools.Frame;
import com.crowsofwar.avatar.client.uitools.Measurement;
import com.crowsofwar.avatar.client.uitools.ScreenInfo;
import com.crowsofwar.avatar.client.uitools.StartingPosition;
import com.crowsofwar.avatar.client.uitools.UiComponent;
import net.minecraft.client.renderer.GlStateManager;

public class AbilityCard {
    private final Ability ability;
    private final int index;
    private Frame frame;
    private UiComponent icon;
    private UiComponent iconBg;

    public AbilityCard(Ability ability, int index) {
        this.ability = ability;
        this.index = index;
        this.icon = new ComponentImage(AvatarUiTextures.getAbilityTexture(ability), 0, 0, 256, 256);
        this.icon.setZLevel(2.0f);
        this.frame = new Frame();
        this.frame.setDimensions(Measurement.fromPixels(256.0f, 256.0f).times(ScreenInfo.scaleFactor()));
        this.icon.setFrame(this.frame);
        this.iconBg = new ComponentImage(AvatarUiTextures.skillsGui, 200, 137, 51, 50);
        this.iconBg.setFrame(this.frame);
        this.iconBg.setPosition(StartingPosition.TOP_LEFT);
        this.iconBg.setScale(2.5f);
        this.iconBg.setOffset(Measurement.fromPixels(64.0f, 64.0f).times(ScreenInfo.scaleFactor()));
        this.updateFramePos(0.0f);
    }

    public void draw(float partialTicks, float scroll, float mouseX, float mouseY) {
        this.updateFramePos(scroll);
        GlStateManager.func_179147_l();
        this.iconBg.draw(partialTicks, mouseX, mouseY);
        this.icon.draw(partialTicks, mouseX, mouseY);
    }

    public float width() {
        return this.frame.getDimensions().xInPixels();
    }

    public Ability getAbility() {
        return this.ability;
    }

    public boolean isMouseHover(float mouseX, float mouseY, float scroll) {
        this.updateFramePos(scroll);
        Measurement min = this.iconBg.coordinates();
        Measurement max = min.plus(Measurement.fromPixels(this.iconBg.width(), this.iconBg.height()));
        return mouseX > min.xInPixels() && mouseY > min.yInPixels() && mouseX < max.xInPixels() && mouseY < max.yInPixels();
    }

    private void updateFramePos(float scroll) {
        Measurement base = Measurement.fromPixels(50.0f, ((float)ScreenInfo.screenHeight() - this.icon.height()) / 2.0f);
        Measurement offset = Measurement.fromPixels(scroll + (float)this.index * this.iconBg.width() * 1.4f, 0.0f);
        this.frame.setPosition(base.plus(offset));
    }
}

