/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.gui.skills;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.client.uitools.UiComponent;
import com.crowsofwar.avatar.config.ConfigClient;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;

public class ComponentAbilityKeybind
extends UiComponent {
    private final Ability ability;
    private String text1;
    private String text2;
    private int color;
    private boolean editing;
    private Conflictable conflict;

    public ComponentAbilityKeybind(Ability ability) {
        this.ability = ability;
        this.text2 = "";
        this.text1 = "";
        this.color = 0xFFFFFF;
        this.editing = false;
        this.conflict = null;
        this.updateText();
    }

    private static Conflictable conflictableKeybinding(KeyBinding keybind) {
        return () -> GameSettings.func_74298_c((int)keybind.func_151463_i());
    }

    private static Conflictable conflictableAbility(Ability ability) {
        return () -> GameSettings.func_74298_c((int)ConfigClient.CLIENT_CONFIG.keymappings.get(ability));
    }

    @Override
    protected float componentWidth() {
        int w1 = this.mc.field_71466_p.func_78256_a(this.text1);
        int w2 = this.mc.field_71466_p.func_78256_a(this.text2);
        return Math.max(w1, w2);
    }

    @Override
    protected float componentHeight() {
        return this.mc.field_71466_p.field_78288_b * 2;
    }

    @Override
    protected void componentDraw(float partialTicks, boolean mouseHover) {
        FontRenderer fr = this.mc.field_71466_p;
        fr.func_78276_b(this.text1, 0, 0, this.color);
        fr.func_78276_b(this.text2, 0, fr.field_78288_b, this.color);
    }

    private void updateText() {
        String key;
        Integer keymapping = this.currentKey();
        if (this.hasConflict()) {
            this.color = 0xFF0000;
            key = "conflict";
        } else if (this.editing) {
            this.color = 16734562;
            key = "editing";
        } else {
            this.color = 0xFFFFFF;
            key = keymapping != null ? "set" : "none";
        }
        String keymappingStr = keymapping == null ? "" : GameSettings.func_74298_c((int)keymapping);
        String conflictStr = this.conflict == null ? "no conflict" : this.conflict.getName();
        this.text1 = I18n.func_135052_a((String)("avatar.key." + key + "1"), (Object[])new Object[]{keymappingStr});
        this.text2 = I18n.func_135052_a((String)("avatar.key." + key + "2"), (Object[])new Object[]{conflictStr});
    }

    private boolean hasConflict() {
        return this.conflict != null;
    }

    @Override
    protected void click(int button) {
        if (this.editing) {
            if (button == 0 || button == 1) {
                this.editing = false;
            } else {
                this.editing = false;
                this.storeKey(button - 100);
            }
        } else {
            this.editing = true;
        }
        this.updateText();
    }

    @Override
    public void keyPressed(int keyCode) {
        if (this.editing) {
            if (keyCode == 1) {
                this.editing = false;
                this.storeKey(null);
                this.updateText();
            } else {
                this.editing = false;
                this.storeKey(keyCode);
                this.updateText();
            }
        }
    }

    private Integer currentKey() {
        return ConfigClient.CLIENT_CONFIG.keymappings.get(this.ability);
    }

    private boolean hasKeybinding() {
        return this.currentKey() != null;
    }

    private void storeKey(Integer key) {
        ConfigClient.CLIENT_CONFIG.keymappings.put(this.ability, key);
        ConfigClient.save();
    }

    public boolean isEditing() {
        return this.editing;
    }

    static interface Conflictable {
        public String getName();
    }
}

