/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.gui.skills;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.client.gui.AvatarUiTextures;
import com.crowsofwar.avatar.client.gui.skills.ComponentInventorySlots;
import com.crowsofwar.avatar.client.uitools.Measurement;
import com.crowsofwar.avatar.client.uitools.ScreenInfo;
import com.crowsofwar.avatar.client.uitools.UiComponent;
import com.crowsofwar.avatar.util.data.AbilityData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;

public class ComponentAbilityTree
extends UiComponent {
    private final Ability ability;
    private final ComponentInventorySlots slot1;
    private final ComponentInventorySlots slot2;

    public ComponentAbilityTree(Ability ability, ComponentInventorySlots slot1, ComponentInventorySlots slot2) {
        this.ability = ability;
        this.slot1 = slot1;
        this.slot2 = slot2;
    }

    @Override
    protected float componentWidth() {
        return 117.0f;
    }

    @Override
    protected float componentHeight() {
        return 42.0f;
    }

    @Override
    protected void componentDraw(float partialTicks, boolean mouseHover) {
        boolean secondGray;
        AbilityData data = AbilityData.get((EntityLivingBase)this.mc.field_71439_g, this.ability.getName());
        this.mc.field_71446_o.func_110577_a(AvatarUiTextures.skillsGui);
        boolean[] reachedLevel = new boolean[]{data.getLevel() >= 0, data.getLevel() >= 1, data.getLevel() >= 2};
        int level123Y = 12;
        int horizontalBarY = 17;
        int diagonalBar1Y = 4;
        int diagonalBar2Y = 20;
        this.slot1.setVisible(data.getLevel() != 3 && data.getXp() == 100.0f);
        this.slot2.setVisible(data.getLevel() == 2 && data.getXp() == 100.0f);
        for (int i = 0; i < reachedLevel.length; ++i) {
            this.func_73729_b(i * 33, level123Y, i * 18 + 166, reachedLevel[i] ? 220 : 202, 18, 18);
            if (i != reachedLevel.length - 1) {
                this.func_73729_b(i * 33 + 18, horizontalBarY, 80, 240, 15, 8);
                if (reachedLevel[i]) {
                    float xp = data.getLevel() == i ? data.getXp() : 100.0f;
                    this.func_73729_b(i * 33 + 18, horizontalBarY, 80, 248, (int)(xp / 100.0f * 15.0f), 8);
                }
            }
            if (i <= 0 || reachedLevel[i] || !reachedLevel[i - 1]) continue;
            this.slot1.setOffset(Measurement.fromPixels(i * 33 * ScreenInfo.scaleFactor(), level123Y * 2).plus(this.coordinates()));
            this.slot1.useTexture(AvatarUiTextures.skillsGui, 166 + i * 18, 238, 18, 18);
        }
        this.func_73729_b(reachedLevel.length * 33 - 16, diagonalBar1Y, 80, 224, 16, 16);
        this.func_73729_b(reachedLevel.length * 33 - 16, diagonalBar2Y, 80, 208, 16, 16);
        if (data.getLevel() >= 2) {
            float xp = data.getLevel() == 3 ? 100.0f : data.getXp();
            this.func_73729_b(reachedLevel.length * 33 - 16, diagonalBar1Y, 96, 224, (int)(xp / 100.0f * 16.0f), 16);
            this.func_73729_b(reachedLevel.length * 33 - 16, diagonalBar2Y, 96, 208, (int)(xp / 100.0f * 16.0f), 16);
        }
        int level4FirstX = 99;
        int level4FirstY = 0;
        int level4SecondX = 99;
        int level4SecondY = 24;
        boolean firstGray = data.getLevel() < 3 || data.getPath() != AbilityData.AbilityTreePath.FIRST;
        boolean bl = secondGray = data.getLevel() < 3 || data.getPath() != AbilityData.AbilityTreePath.SECOND;
        if (!firstGray) {
            this.func_73729_b(level4FirstX, level4FirstY, 220, 220, 18, 18);
        } else {
            this.func_73729_b(level4FirstX, level4FirstY, 220, 202, 18, 18);
        }
        if (!secondGray) {
            this.func_73729_b(level4SecondX, level4SecondY, 238, 220, 18, 18);
        } else {
            this.func_73729_b(level4SecondX, level4SecondY, 238, 202, 18, 18);
        }
        if (data.getLevel() == 2) {
            float s1x = this.coordinates().xInPixels() + (float)(level4FirstX * ScreenInfo.scaleFactor());
            float s1y = this.coordinates().yInPixels() + (float)(level4FirstY * ScreenInfo.scaleFactor());
            float s2x = this.coordinates().xInPixels() + (float)(level4SecondX * ScreenInfo.scaleFactor());
            float s2y = this.coordinates().yInPixels() + (float)(level4SecondY * ScreenInfo.scaleFactor());
            this.slot1.setOffset(Measurement.fromPixels(s1x, s1y));
            this.slot1.useTexture(AvatarUiTextures.skillsGui, 220, 238, 18, 18);
            this.slot1.setVisible(true);
            this.slot2.useTexture(AvatarUiTextures.skillsGui, 238, 238, 18, 18);
            this.slot2.setOffset(Measurement.fromPixels(s2x, s2y));
            this.slot2.setVisible(true);
        }
    }

    @Override
    public List<String> getTooltip(float mouseX, float mouseY) {
        float l123MinY = this.coordinates().yInPixels() + (float)(12 * ScreenInfo.scaleFactor());
        float l123MaxY = l123MinY + (float)(18 * ScreenInfo.scaleFactor());
        float l1MinX = this.coordinates().xInPixels();
        float l1MaxX = l1MinX + (float)(18 * ScreenInfo.scaleFactor());
        float l2MinX = this.coordinates().xInPixels() + (float)(33 * ScreenInfo.scaleFactor());
        float l2MaxX = l2MinX + (float)(18 * ScreenInfo.scaleFactor());
        float l3MinX = this.coordinates().xInPixels() + (float)(66 * ScreenInfo.scaleFactor());
        float l3MaxX = l3MinX + (float)(18 * ScreenInfo.scaleFactor());
        float l4MaxX = this.coordinates().xInPixels() + this.width();
        float l4MinX = l4MaxX - (float)(18 * ScreenInfo.scaleFactor());
        float l41MinY = this.coordinates().yInPixels();
        float l41MaxY = l41MinY + (float)(18 * ScreenInfo.scaleFactor());
        float l42MinY = this.coordinates().yInPixels() + this.height() - (float)(18 * ScreenInfo.scaleFactor());
        float l42MaxY = l42MinY + (float)(18 * ScreenInfo.scaleFactor());
        String level = null;
        if (mouseX >= l1MinX && mouseX <= l1MaxX && mouseY >= l123MinY && mouseY <= l123MaxY) {
            level = "lvl1";
        }
        if (mouseX >= l2MinX && mouseX <= l2MaxX && mouseY >= l123MinY && mouseY <= l123MaxY) {
            level = "lvl2";
        }
        if (mouseX >= l3MinX && mouseX <= l3MaxX && mouseY >= l123MinY && mouseY <= l123MaxY) {
            level = "lvl3";
        }
        if (mouseX >= l4MinX && mouseX <= l4MaxX && mouseY >= l41MinY && mouseY <= l41MaxY) {
            level = "lvl4_1";
        }
        if (mouseX >= l4MinX && mouseX <= l4MaxX && mouseY >= l42MinY && mouseY <= l42MaxY) {
            level = "lvl4_2";
        }
        if (level != null) {
            return Arrays.asList(I18n.func_135052_a((String)("avatar.ability." + this.ability.getName() + "." + level), (Object[])new Object[0]).split(" ;; "));
        }
        return null;
    }
}

