/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.gui.skills;

import com.crowsofwar.avatar.client.uitools.Measurement;
import com.crowsofwar.avatar.client.uitools.ScreenInfo;
import com.crowsofwar.avatar.client.uitools.UiComponent;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;

public class ComponentInventorySlots
extends UiComponent {
    private final Container container;
    private final int cols;
    private final int rows;
    private final int minIndex;
    private final int maxIndex;
    private int width;
    private int height;
    private ResourceLocation texture;
    private int u;
    private int v;
    private Measurement padding;

    public ComponentInventorySlots(Container container, int index) {
        this(container, 1, 1, index, index);
    }

    public ComponentInventorySlots(Container container, int cols, int rows, int minIndex, int maxIndex) {
        this.container = container;
        this.cols = cols;
        this.rows = rows;
        this.width = cols * 18;
        this.height = rows * 18;
        this.minIndex = minIndex;
        this.maxIndex = maxIndex;
        this.texture = null;
        this.u = -1;
        this.v = -1;
        this.padding = Measurement.fromPixels(0.0f, 0.0f);
    }

    public void useTexture(ResourceLocation texture, int u, int v, int width, int height) {
        this.width = width;
        this.height = height;
        this.texture = texture;
        this.u = u;
        this.v = v;
    }

    @Override
    protected float componentWidth() {
        return this.width;
    }

    @Override
    protected float componentHeight() {
        return this.height;
    }

    @Override
    protected void componentDraw(float partialTicks, boolean mouseHover) {
        for (int i = this.minIndex; i <= this.maxIndex; ++i) {
            Slot slot = this.container.func_75139_a(i);
            int x = (int)this.coordinates().xInPixels() + (int)this.padding.xInPixels() * ScreenInfo.scaleFactor();
            int y = (int)this.coordinates().yInPixels() + (int)this.padding.yInPixels() * ScreenInfo.scaleFactor();
            int j = i - this.minIndex;
            slot.field_75223_e = 18 * ScreenInfo.scaleFactor() * (j % this.cols) + x;
            slot.field_75221_f = 18 * ScreenInfo.scaleFactor() * (j / this.cols) + y;
            slot.field_75223_e /= ScreenInfo.scaleFactor();
            slot.field_75221_f /= ScreenInfo.scaleFactor();
            ++slot.field_75223_e;
            ++slot.field_75221_f;
        }
        if (this.texture != null) {
            this.mc.field_71446_o.func_110577_a(this.texture);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(0, 0, this.u, this.v, this.width, this.height);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!this.isVisible()) {
            for (int i = this.minIndex; i <= this.maxIndex; ++i) {
                Slot slot = this.container.func_75139_a(i);
                slot.field_75223_e = -18;
                slot.field_75221_f = -18;
            }
        }
    }

    public Measurement getPadding() {
        return this.padding;
    }

    public void setPadding(Measurement padding) {
        this.padding = padding;
    }
}

