/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.gui.skills;

import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.BendingStyles;
import com.crowsofwar.avatar.client.gui.AvatarGui;
import com.crowsofwar.avatar.client.gui.AvatarUiTextures;
import com.crowsofwar.avatar.client.gui.ContainerGetBending;
import com.crowsofwar.avatar.client.gui.skills.ComponentInventorySlots;
import com.crowsofwar.avatar.client.uitools.ComponentCustomButton;
import com.crowsofwar.avatar.client.uitools.ComponentLongText;
import com.crowsofwar.avatar.client.uitools.ComponentText;
import com.crowsofwar.avatar.client.uitools.Frame;
import com.crowsofwar.avatar.client.uitools.Measurement;
import com.crowsofwar.avatar.client.uitools.ScreenInfo;
import com.crowsofwar.avatar.client.uitools.StartingPosition;
import com.crowsofwar.avatar.client.uitools.UiComponent;
import com.crowsofwar.avatar.client.uitools.UiComponentHandler;
import com.crowsofwar.avatar.network.packets.PacketSUnlockBending;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GetBendingGui
extends GuiContainer
implements AvatarGui {
    private final ContainerGetBending container;
    private final UiComponentHandler handler;
    private final Frame slotsFrame;
    private final Frame buttonsFrame;
    private final UiComponent title;
    private final UiComponent incompatibleMsg;
    private final UiComponent instructions;
    private final ComponentInventorySlots scrollSlots;
    private final ComponentInventorySlots inventoryComp;
    private final ComponentInventorySlots hotbarComp;
    private final UiComponent[] bendingButtons;

    public GetBendingGui(EntityPlayer player) {
        super((Container)new ContainerGetBending(player));
        this.container = (ContainerGetBending)this.field_147002_h;
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        this.field_146999_f = res.func_78326_a();
        this.field_147000_g = res.func_78328_b();
        this.handler = new UiComponentHandler();
        this.slotsFrame = new Frame();
        this.slotsFrame.setPosition(Measurement.fromPercent(35.0f, 10.0f));
        this.slotsFrame.setDimensions(Measurement.fromPercent(30.0f, 35.0f));
        this.buttonsFrame = new Frame();
        this.buttonsFrame.setDimensions(Measurement.fromPercent(40.0f, 35.0f));
        this.title = new ComponentText(TextFormatting.BOLD + I18n.func_135052_a((String)"avatar.getBending.title", (Object[])new Object[0]));
        this.title.setFrame(this.slotsFrame);
        this.title.setPosition(StartingPosition.TOP_CENTER);
        this.title.setScale(1.5f);
        this.handler.add(this.title);
        this.scrollSlots = new ComponentInventorySlots(this.container, 3, 1, 0, 2);
        this.scrollSlots.setFrame(this.slotsFrame);
        this.scrollSlots.setPosition(StartingPosition.MIDDLE_BOTTOM);
        this.scrollSlots.useTexture(AvatarUiTextures.getBending, 0, 0, 70, 34);
        this.scrollSlots.setPadding(Measurement.fromPixels(7.0f, 9.0f));
        this.handler.add(this.scrollSlots);
        this.hotbarComp = new ComponentInventorySlots(this.container, 9, 1, this.container.getHotbarIndex(), this.container.getHotbarIndex() + 8);
        this.hotbarComp.setPosition(StartingPosition.MIDDLE_BOTTOM);
        this.hotbarComp.setOffset(Measurement.fromPixels(0.0f, -7 * ScreenInfo.scaleFactor()));
        this.handler.add(this.hotbarComp);
        this.inventoryComp = new ComponentInventorySlots(this.container, 9, 3, this.container.getInvIndex(), this.container.getInvIndex() + 26);
        this.inventoryComp.setPosition(StartingPosition.MIDDLE_BOTTOM);
        this.inventoryComp.useTexture(AvatarUiTextures.getBending, 0, 34, 176, 90);
        this.inventoryComp.setPadding(Measurement.fromPixels(7.0f, 7.0f));
        this.handler.add(this.inventoryComp);
        this.incompatibleMsg = new ComponentText(TextFormatting.RED + I18n.func_135052_a((String)"avatar.getBending.incompatible", (Object[])new Object[0])){

            @Override
            protected void componentDraw(float partialTicks, boolean mouseHover) {
                float ticks = GetBendingGui.this.container.getIncompatibleMsgTicks();
                if (ticks > -1.0f) {
                    GlStateManager.func_179147_l();
                    float alphaFloat = ticks > 40.0f ? 1.0f : ticks / 40.0f;
                    int alpha = (int)(alphaFloat * 255.0f);
                    if (alpha > 4) {
                        this.func_73731_b(this.mc.field_71466_p, this.getText(), 0, 0, 0xFFFFFF | alpha << 24);
                    }
                    GetBendingGui.this.container.decrementIncompatibleMsgTicks(partialTicks);
                    GlStateManager.func_179084_k();
                }
            }
        };
        this.incompatibleMsg.setFrame(this.slotsFrame);
        this.incompatibleMsg.setZLevel(999.0f);
        this.incompatibleMsg.setPosition(StartingPosition.MIDDLE_BOTTOM);
        this.incompatibleMsg.setOffset(Measurement.fromPixels(this.slotsFrame, 0.0f, 20.0f));
        this.handler.add(this.incompatibleMsg);
        this.instructions = new ComponentLongText(I18n.func_135052_a((String)"avatar.getBending.guide", (Object[])new Object[0]), Measurement.fromPercent(50.0f, 0.0f));
        this.instructions.setFrame(this.slotsFrame);
        this.instructions.setPosition(StartingPosition.TOP_CENTER);
        this.instructions.setOffset(Measurement.fromPixels(this.slotsFrame, 0.0f, this.title.height() + 20.0f));
        this.handler.add(this.instructions);
        List<UUID> bendingIds = BendingStyles.allMainIds();
        this.bendingButtons = new UiComponent[bendingIds.size()];
        for (int i = 0; i < this.bendingButtons.length; ++i) {
            UUID bendingId = bendingIds.get(i);
            int u = i % 2 * 120;
            int v = 124 + 60 * (i / 2);
            ComponentCustomButton comp = new ComponentCustomButton(AvatarUiTextures.getBending, u, v, 60, 60, () -> AvatarMod.network.sendToServer((IMessage)new PacketSUnlockBending(bendingId)));
            comp.setFrame(this.buttonsFrame);
            comp.setScale(0.5f);
            comp.setOffset(Measurement.fromPixels(this.buttonsFrame, comp.width() * (float)i, 0.0f));
            this.bendingButtons[i] = comp;
            this.handler.add(comp);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ScreenInfo.refreshDimensions();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        List<UUID> allowedTypes = this.container.getEligibleBending();
        int visibleBtns = 0;
        for (int i = 0; i < this.bendingButtons.length; ++i) {
            UiComponent btn = this.bendingButtons[i];
            UUID btnBendingId = BendingStyles.allMainIds().get(i);
            if (allowedTypes.contains(btnBendingId)) {
                btn.setVisible(true);
                btn.setOffset(Measurement.fromPixels(this.buttonsFrame, btn.width() * (float)visibleBtns, 0.0f));
                ++visibleBtns;
                continue;
            }
            btn.setVisible(false);
        }
        this.adjustButtonsPosition();
        this.handler.draw(partialTicks, mouseX, mouseY);
    }

    private void adjustButtonsPosition() {
        float totalWidth = 0.0f;
        for (UiComponent btn : this.bendingButtons) {
            if (!btn.isVisible()) continue;
            totalWidth += btn.width();
        }
        float yPx = this.buttonsFrame.getDimensions().yInPixels();
        this.buttonsFrame.setDimensions(Measurement.fromPixels(totalWidth, yPx));
        this.buttonsFrame.setPosition(Measurement.fromPercent((100.0f - this.buttonsFrame.getDimensions().xInPercent()) / 2.0f, this.slotsFrame.getCoordsMax().yInPercent()));
    }
}

