/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.gui.skills;

import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.BendingStyles;
import com.crowsofwar.avatar.client.gui.AvatarGui;
import com.crowsofwar.avatar.client.gui.AvatarUiTextures;
import com.crowsofwar.avatar.client.gui.ContainerSkillsGui;
import com.crowsofwar.avatar.client.gui.skills.AbilityCard;
import com.crowsofwar.avatar.client.gui.skills.ComponentBendingTab;
import com.crowsofwar.avatar.client.gui.skills.ComponentInventorySlots;
import com.crowsofwar.avatar.client.gui.skills.WindowAbility;
import com.crowsofwar.avatar.client.uitools.ComponentImageNonSquare;
import com.crowsofwar.avatar.client.uitools.ComponentText;
import com.crowsofwar.avatar.client.uitools.Frame;
import com.crowsofwar.avatar.client.uitools.Measurement;
import com.crowsofwar.avatar.client.uitools.ScreenInfo;
import com.crowsofwar.avatar.client.uitools.StartingPosition;
import com.crowsofwar.avatar.client.uitools.UiComponentHandler;
import com.crowsofwar.avatar.network.packets.PacketSUseScroll;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.gorecore.format.FormattedMessage;
import com.crowsofwar.gorecore.format.FormattedMessageProcessor;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class SkillsGui
extends GuiContainer
implements AvatarGui {
    private static final FormattedMessage MSG_TITLE = FormattedMessage.newChatMessage("avatar.ui.skillsMenu", "bending");
    private final UUID bendingId;
    private AbilityCard[] cards;
    private ComponentBendingTab[] tabs;
    private int scroll;
    private WindowAbility window;
    private Frame frame;
    private ComponentInventorySlots inventory;
    private ComponentInventorySlots hotbar;
    private ComponentText title;
    private ComponentImageNonSquare background;
    private UiComponentHandler handler;

    public SkillsGui(UUID guiBending) {
        super((Container)new ContainerSkillsGui((EntityPlayer)Minecraft.func_71410_x().field_71439_g, guiBending));
        this.bendingId = guiBending;
        ContainerSkillsGui skillsContainer = (ContainerSkillsGui)this.field_147002_h;
        BendingData data = BendingData.getFromEntity((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        this.field_146999_f = res.func_78326_a();
        this.field_147000_g = res.func_78328_b();
        ScreenInfo.refreshDimensions();
        BendingStyle controller = BendingStyles.get(guiBending);
        List<Ability> abilities = controller.getAllAbilities();
        this.cards = new AbilityCard[abilities.size()];
        for (int i = 0; i < abilities.size(); ++i) {
            this.cards[i] = new AbilityCard(abilities.get(i), i);
        }
        this.handler = new UiComponentHandler();
        if (data != null) {
            UUID[] types = (UUID[])data.getAllBending().stream().map(BendingStyle::getId).sorted((id1, id2) -> {
                BendingStyle c1 = BendingStyles.get(id1);
                BendingStyle c2 = BendingStyles.get(id2);
                return c1.getName().compareTo(c2.getName());
            }).toArray(UUID[]::new);
            this.tabs = new ComponentBendingTab[types.length];
            for (int i = 0; i < types.length; ++i) {
                float scale = 1.4f;
                BendingStyle style = BendingStyles.get(types[i]);
                this.tabs[i] = new ComponentBendingTab(style, types[i] == guiBending);
                this.tabs[i].setPosition(StartingPosition.MIDDLE_BOTTOM);
                this.tabs[i].setOffset(Measurement.fromPixels((float)(24 * ScreenInfo.scaleFactor()) * ((float)i - (float)types.length / 2.0f) * scale, 0.0f));
                this.tabs[i].setScale(scale);
                this.handler.add(this.tabs[i]);
            }
            this.inventory = new ComponentInventorySlots(this.field_147002_h, 9, 3, skillsContainer.getInvIndex(), skillsContainer.getInvIndex() + 26);
            this.inventory.useTexture(AvatarUiTextures.skillsGui, 0, 54, 169, 83);
            this.inventory.setPosition(StartingPosition.BOTTOM_RIGHT);
            this.inventory.setPadding(Measurement.fromPixels(7.0f, 7.0f));
            this.inventory.setVisible(false);
            this.hotbar = new ComponentInventorySlots(this.field_147002_h, 9, 1, skillsContainer.getHotbarIndex(), skillsContainer.getHotbarIndex() + 8);
            this.hotbar.setPosition(StartingPosition.BOTTOM_RIGHT);
            this.hotbar.setVisible(false);
            this.title = new ComponentText(TextFormatting.BOLD + FormattedMessageProcessor.formatText(MSG_TITLE, I18n.func_135052_a((String)"avatar.ui.skillsMenu", (Object[])new Object[0]), BendingStyles.get(guiBending).getName().toLowerCase()));
            this.title.setPosition(StartingPosition.TOP_CENTER);
            this.title.setOffset(Measurement.fromPixels(0.0f, 10.0f));
            this.handler.add(this.title);
            ResourceLocation bgTexture = AvatarUiTextures.getBendingBackgroundTexture(guiBending);
            int bgWidth = (int)AvatarUiTextures.getBendingBackgroundWidth(guiBending);
            int bgHeight = (int)AvatarUiTextures.getBendingBackgroundHeight(guiBending);
            this.background = new ComponentImageNonSquare(bgTexture, bgWidth, bgHeight);
            this.background.setZLevel(-1.0f);
            this.handler.add(this.background);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        ScreenInfo.refreshDimensions();
    }

    public void func_73876_c() {
        super.func_73876_c();
        ContainerSkillsGui container = (ContainerSkillsGui)this.field_147002_h;
        ItemStack scroll = container.func_75139_a(0).func_75211_c();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.scroll += Mouse.getDWheel() / 3;
        if (Mouse.isButtonDown((int)0) && !this.isWindowOpen()) {
            int mouseX = Mouse.getX();
            int mouseY = ScreenInfo.screenHeight() - Mouse.getY();
            for (int i = 0; i < this.cards.length; ++i) {
                if (!this.cards[i].isMouseHover(mouseX, mouseY, this.scroll)) continue;
                this.openWindow(this.cards[i]);
                break;
            }
        }
    }

    protected void func_146284_a(GuiButton button) {
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        float imageWidth = AvatarUiTextures.getBendingBackgroundWidth(this.bendingId);
        float imageHeight = AvatarUiTextures.getBendingBackgroundHeight(this.bendingId);
        float scaleX = (float)this.field_146294_l / imageWidth;
        float scaleY = (float)this.field_146295_m / imageHeight;
        this.background.setScale(Math.max(scaleX, scaleY));
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        float offsetX = ((float)(this.field_146294_l * res.func_78325_e()) - this.background.width()) / 2.0f;
        float offsetY = ((float)(this.field_146295_m * res.func_78325_e()) - this.background.height()) / 2.0f;
        this.background.setOffset(Measurement.fromPixels(offsetX, offsetY));
        this.handler.draw(partialTicks, mouseX, mouseY);
        if (this.isWindowOpen()) {
            this.window.draw(partialTicks);
        } else {
            for (int i = 0; i < this.cards.length; ++i) {
                this.cards[i].draw(partialTicks, this.scroll, mouseX, mouseY);
            }
        }
        this.inventory.setVisible(this.isWindowOpen());
        this.inventory.draw(partialTicks, mouseX, mouseY);
        this.hotbar.draw(partialTicks, mouseX, mouseY);
    }

    public void func_146282_l() throws IOException {
        boolean keyboardRight;
        super.func_146282_l();
        boolean minecraftLeft = Keyboard.getEventKey() == this.field_146297_k.field_71474_y.field_74370_x.func_151463_i() && this.field_146297_k.field_71474_y.field_74370_x.func_151470_d();
        boolean keyboardLeft = Keyboard.getEventKey() == 203 && Keyboard.getEventKeyState();
        boolean minecraftRight = Keyboard.getEventKey() == this.field_146297_k.field_71474_y.field_74366_z.func_151463_i() && this.field_146297_k.field_71474_y.field_74366_z.func_151470_d();
        boolean bl = keyboardRight = Keyboard.getEventKey() == 205 && Keyboard.getEventKeyState();
        if (minecraftLeft || keyboardLeft) {
            this.scroll += 20;
        }
        if (minecraftRight || keyboardRight) {
            this.scroll -= 20;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.isWindowOpen()) {
            KeyBinding invKb = this.field_146297_k.field_71474_y.field_151445_Q;
            if (this.window.isEditing() && keyCode == 1) {
                this.window.keyTyped(keyCode);
            } else if (keyCode == 1 || invKb.isActiveAndMatches(keyCode)) {
                this.closeWindow();
            } else {
                this.window.keyTyped(keyCode);
            }
        } else {
            this.handler.type(keyCode);
            if (keyCode == 30 || keyCode == 203) {
                this.scroll += 50;
            } else if (keyCode == 32 || keyCode == 205) {
                this.scroll -= 50;
            } else {
                super.func_73869_a(typedChar, keyCode);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.window != null) {
            this.window.mouseClicked(mouseX, mouseY, mouseButton);
        } else {
            this.handler.click(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        if (!this.isWindowOpen() || this.window.canRenderTooltip(stack)) {
            super.func_146285_a(stack, x, y);
        }
    }

    private boolean isWindowOpen() {
        return this.window != null;
    }

    private void openWindow(AbilityCard card) {
        this.window = new WindowAbility(card.getAbility(), this);
        this.inventory.setVisible(true);
        this.hotbar.setVisible(true);
    }

    public void openWindow(Ability ability) {
        for (AbilityCard card : this.cards) {
            if (card.getAbility() != ability) continue;
            this.openWindow(card);
            break;
        }
    }

    public void closeWindow() {
        this.window.onClose();
        this.window = null;
        this.inventory.setVisible(false);
        this.hotbar.setVisible(false);
    }

    public void useScroll(Ability ability) {
        ContainerSkillsGui container = (ContainerSkillsGui)this.field_147002_h;
        if (container.func_75139_a(0).func_75216_d() || container.func_75139_a(1).func_75216_d()) {
            AvatarMod.network.sendToServer((IMessage)new PacketSUseScroll(ability));
        }
    }
}

