/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.gui.skills;

import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyles;
import com.crowsofwar.avatar.client.gui.AvatarUiTextures;
import com.crowsofwar.avatar.client.gui.skills.ComponentAbilityKeybind;
import com.crowsofwar.avatar.client.gui.skills.ComponentAbilityTree;
import com.crowsofwar.avatar.client.gui.skills.ComponentInventorySlots;
import com.crowsofwar.avatar.client.gui.skills.SkillsGui;
import com.crowsofwar.avatar.client.uitools.ComponentCustomButton;
import com.crowsofwar.avatar.client.uitools.ComponentImage;
import com.crowsofwar.avatar.client.uitools.ComponentLongText;
import com.crowsofwar.avatar.client.uitools.ComponentOverlay;
import com.crowsofwar.avatar.client.uitools.ComponentText;
import com.crowsofwar.avatar.client.uitools.Frame;
import com.crowsofwar.avatar.client.uitools.Measurement;
import com.crowsofwar.avatar.client.uitools.ScreenInfo;
import com.crowsofwar.avatar.client.uitools.StartingPosition;
import com.crowsofwar.avatar.client.uitools.UiComponent;
import com.crowsofwar.avatar.client.uitools.UiComponentHandler;
import com.crowsofwar.avatar.network.packets.PacketSUseScroll;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.gorecore.format.FormattedMessage;
import com.crowsofwar.gorecore.format.FormattedMessageProcessor;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class WindowAbility {
    private static final FormattedMessage MSG_UNLOCK_TEXT = FormattedMessage.newChatMessage("avatar.ui.unlockDesc", "bending");
    private static final FormattedMessage MSG_UNLOCK_SPECIAL_TEXT = FormattedMessage.newChatMessage("avatar.ui.unlockDesc", "bendingMain", "bendingSpecialty");
    private final Minecraft mc = Minecraft.func_71410_x();
    private final Ability ability;
    private final SkillsGui gui;
    private final UiComponentHandler handler;
    private Frame frame;
    private UiComponent icon;
    private UiComponent title;
    private UiComponent tier;
    private UiComponent parentTier;
    private UiComponent coolDown;
    private UiComponent burnout;
    private UiComponent chiCost;
    private UiComponent exhaustion;
    private UiComponent overlay;
    private UiComponent level;
    private UiComponent invBg;
    private UiComponent treeView;
    private UiComponent description;
    private UiComponent backButton;
    private ComponentInventorySlots slot1;
    private ComponentInventorySlots slot2;
    private ComponentAbilityKeybind keybind;
    private ComponentCustomButton button;
    private UiComponent unlockTitle;
    private UiComponent unlockText;
    private ComponentCustomButton unlockButton;

    public WindowAbility(Ability ability, SkillsGui gui) {
        String text;
        String tierName;
        EntityPlayerSP player = this.mc.field_71439_g;
        this.ability = ability;
        this.gui = gui;
        this.handler = new UiComponentHandler();
        this.frame = new Frame();
        this.frame.setDimensions(Measurement.fromPercent(80.0f, 80.0f));
        this.frame.setPosition(Measurement.fromPercent(10.0f, 10.0f));
        Frame frameLeft = new Frame(this.frame);
        frameLeft.setDimensions(Measurement.fromPercent(this.frame, 30.0f, 100.0f));
        Frame frameRight = new Frame(this.frame);
        frameRight.setDimensions(Measurement.fromPercent(this.frame, 60.0f, 100.0f));
        frameRight.setPosition(Measurement.fromPercent(this.frame, 40.0f, 0.0f));
        this.overlay = new ComponentOverlay();
        this.handler.add(this.overlay);
        this.title = new ComponentText(TextFormatting.BOLD + I18n.func_135052_a((String)("avatar.ability." + ability.getName()), (Object[])new Object[0]));
        this.title.setFrame(frameLeft);
        this.title.setPosition(StartingPosition.MIDDLE_TOP);
        this.title.setScale(1.4f);
        this.title.setZLevel(4.0f);
        this.handler.add(this.title);
        this.icon = new ComponentImage(AvatarUiTextures.getPlainCardTexture(ability), 0, 0, 256, 256);
        this.icon.setFrame(frameLeft);
        this.icon.setPosition(StartingPosition.MIDDLE_TOP);
        this.icon.setOffset(Measurement.fromPixels(0.0f, this.title.height()).plus(Measurement.fromPercent(0.0f, -35.0f)));
        this.icon.setZLevel(3.0f);
        this.handler.add(this.icon);
        this.description = new ComponentLongText(I18n.func_135052_a((String)("avatar.ability." + ability.getName() + ".desc"), (Object[])new Object[0]), Measurement.fromPercent(frameLeft, 100.0f, 0.0f));
        this.description.setFrame(frameLeft);
        this.description.setPosition(StartingPosition.custom(0.0f, 0.3f, 0.0f, 0.0f));
        this.description.setZLevel(4.0f);
        this.handler.add(this.description);
        String parentTierName = "";
        switch (ability.getCurrentTier(AbilityData.get((EntityLivingBase)player, ability.getName()))) {
            default: {
                tierName = "I";
                break;
            }
            case 2: {
                tierName = "II";
                break;
            }
            case 3: {
                tierName = "III";
                break;
            }
            case 4: {
                tierName = "IV";
                break;
            }
            case 5: {
                tierName = "V";
                break;
            }
            case 6: {
                tierName = "VI";
                break;
            }
            case 7: {
                tierName = "VII";
            }
        }
        if (ability.getBaseParentTier() > 0) {
            switch (ability.getCurrentParentTier(AbilityData.get((EntityLivingBase)player, ability.getName()))) {
                default: {
                    parentTierName = "I";
                    break;
                }
                case 2: {
                    parentTierName = "II";
                    break;
                }
                case 3: {
                    parentTierName = "III";
                    break;
                }
                case 4: {
                    parentTierName = "IV";
                    break;
                }
                case 5: {
                    parentTierName = "V";
                    break;
                }
                case 6: {
                    parentTierName = "VI";
                    break;
                }
                case 7: {
                    parentTierName = "VII";
                }
            }
        }
        this.tier = new ComponentText(ability.getElement().getTextFormattingColour() + I18n.func_135052_a((String)("Tier: " + tierName), (Object[])new Object[]{TextFormatting.BOLD}));
        this.tier.setFrame(frameLeft);
        this.tier.setPosition(StartingPosition.custom(0.0f, 0.0875f, 0.0f, 0.0f));
        this.tier.setZLevel(4.0f);
        this.handler.add(this.tier);
        if (ability.getBaseParentTier() > 0) {
            this.parentTier = new ComponentText(BendingStyles.get(ability.getElement().getParentBendingId()).getTextFormattingColour() + I18n.func_135052_a((String)("Parent Tier: " + parentTierName), (Object[])new Object[]{TextFormatting.BOLD}));
            this.parentTier.setFrame(frameLeft);
            this.parentTier.setPosition(StartingPosition.custom(0.0f, 0.15f, 0.0f, 0.0f));
            this.parentTier.setZLevel(4.0f);
            this.handler.add(this.parentTier);
        }
        this.invBg = new ComponentImage(AvatarUiTextures.skillsGui, 0, 54, 169, 83);
        this.invBg.setPosition(StartingPosition.BOTTOM_RIGHT);
        this.slot1 = new ComponentInventorySlots(gui.field_147002_h, 0);
        this.slot1.useTexture(AvatarUiTextures.skillsGui, 40, 0, 18, 18);
        this.slot1.setZLevel(5.0f);
        this.handler.add(this.slot1);
        this.slot2 = new ComponentInventorySlots(gui.field_147002_h, 1);
        this.slot2.useTexture(AvatarUiTextures.skillsGui, 40, 0, 18, 18);
        this.slot2.setOffset(Measurement.fromPixels(frameRight, this.slot1.width() + 10.0f, 0.0f));
        this.slot2.setZLevel(5.0f);
        this.handler.add(this.slot2);
        this.treeView = new ComponentAbilityTree(ability, this.slot1, this.slot2);
        this.treeView.setFrame(frameRight);
        this.treeView.setPosition(StartingPosition.TOP_LEFT);
        this.treeView.setOffset(Measurement.fromPercent(frameRight, 0.0f, 20.0f));
        this.treeView.setZLevel(4.0f);
        this.handler.add(this.treeView);
        this.button = new ComponentCustomButton(AvatarUiTextures.skillsGui, 112, 0, 18, 18, () -> gui.useScroll(ability));
        this.button.setFrame(frameRight);
        this.button.setPosition(StartingPosition.TOP_LEFT);
        this.button.setOffset(this.treeView.offset().plus(Measurement.fromPixels(frameRight, this.treeView.width() + 100.0f, 0.0f)));
        this.button.setZLevel(4.0f);
        this.handler.add(this.button);
        this.keybind = new ComponentAbilityKeybind(ability);
        this.keybind.setFrame(frameRight);
        this.keybind.setPosition(StartingPosition.custom(0.5f, 0.5f, 1.0f, 0.5f));
        this.keybind.setOffset(Measurement.fromPercent(frameRight, -4.0f, 0.0f));
        this.keybind.setZLevel(4.0f);
        this.handler.add(this.keybind);
        this.unlockTitle = new ComponentText(TextFormatting.BOLD + I18n.func_135052_a((String)"avatar.ui.unlock", (Object[])new Object[0]));
        this.unlockTitle.setFrame(frameRight);
        this.unlockTitle.setScale(1.5f);
        this.unlockTitle.setZLevel(4.0f);
        this.handler.add(this.unlockTitle);
        String bendingName = BendingStyles.get(ability.getBendingId()).getName().toLowerCase();
        UUID parentBending = BendingStyles.get(ability.getBendingId()).getParentBendingId();
        if (parentBending != null) {
            String specialtyName = BendingStyles.get(parentBending).getName();
            text = FormattedMessageProcessor.formatText(MSG_UNLOCK_SPECIAL_TEXT, I18n.func_135052_a((String)"avatar.ui.unlockDescSpecialty", (Object[])new Object[0]), bendingName, specialtyName);
        } else {
            text = FormattedMessageProcessor.formatText(MSG_UNLOCK_TEXT, I18n.func_135052_a((String)"avatar.ui.unlockDesc", (Object[])new Object[0]), bendingName);
        }
        this.unlockText = new ComponentLongText(text, frameRight.getDimensions());
        this.unlockText.setFrame(frameRight);
        this.unlockText.setZLevel(4.0f);
        this.unlockText.setOffset(Measurement.fromPixels(frameRight, 0.0f, this.unlockTitle.height() + 10.0f));
        this.handler.add(this.unlockText);
        this.unlockButton = new ComponentCustomButton(AvatarUiTextures.skillsGui, 196, 100, 20, 20, () -> AvatarMod.network.sendToServer((IMessage)new PacketSUseScroll(ability)));
        this.unlockButton.setFrame(frameRight);
        this.unlockButton.setOffset(Measurement.fromPixels(this.unlockTitle.getFrame(), this.slot1.width() + 20.0f, this.unlockTitle.height() + this.unlockText.height() + 20.0f));
        this.unlockButton.setZLevel(4.0f);
        this.handler.add(this.unlockButton);
        this.backButton = new ComponentCustomButton(AvatarUiTextures.skillsGui, 0, 240, 16, 16, () -> gui.closeWindow());
        this.backButton.setZLevel(999.0f);
        this.handler.add(this.backButton);
    }

    public void draw(float partialTicks) {
        this.button.setEnabled(this.gui.field_147002_h.func_75139_a(0).func_75216_d() || this.gui.field_147002_h.func_75139_a(1).func_75216_d());
        int width = ScreenInfo.screenWidth() / ScreenInfo.scaleFactor();
        int height = ScreenInfo.screenHeight() / ScreenInfo.scaleFactor();
        int mouseX = Mouse.getX() * width / this.mc.field_71443_c;
        int mouseY = height - Mouse.getY() * height / this.mc.field_71440_d - 1;
        AbilityData data = AbilityData.get((EntityLivingBase)this.mc.field_71439_g, this.ability.getName());
        this.unlockTitle.setVisible(data.isLocked());
        this.unlockText.setVisible(data.isLocked());
        this.unlockButton.setVisible(data.isLocked());
        this.treeView.setVisible(!data.isLocked());
        this.button.setVisible(!data.isLocked());
        if (data.isLocked()) {
            this.unlockButton.setEnabled(this.gui.field_147002_h.func_75139_a(0).func_75216_d());
            this.slot1.setVisible(true);
            this.slot1.setFrame(this.unlockTitle.getFrame());
            this.slot1.setOffset(Measurement.fromPixels(this.unlockTitle.getFrame(), 0.0f, this.unlockTitle.height() + this.unlockText.height() + 20.0f));
            this.slot2.setVisible(false);
        } else {
            this.slot1.setFrame(Frame.SCREEN);
        }
        this.handler.draw(partialTicks, mouseX, mouseY);
    }

    public boolean isMouseHover(float mouseX, float mouseY) {
        Measurement min = this.frame.getCoordsMin();
        Measurement max = this.frame.getCoordsMax();
        return mouseX > min.xInPixels() && mouseY > min.yInPixels() && mouseX < max.xInPixels() && mouseY < max.yInPixels();
    }

    public boolean isInventoryMouseHover(float mouseX, float mouseY) {
        Measurement min = this.invBg.coordinates();
        Measurement max = min.plus(Measurement.fromPixels(this.invBg.width(), this.invBg.height()));
        return mouseX > min.xInPixels() && mouseY > min.yInPixels() && mouseX < max.xInPixels() && mouseY < max.yInPixels();
    }

    public void mouseClicked(float x, float y, int button) {
        this.handler.click(x, y, button);
    }

    public void keyTyped(int key) {
        this.handler.type(key);
    }

    public Frame getFrame() {
        return this.frame;
    }

    public boolean isEditing() {
        return this.keybind.isEditing();
    }

    public void onClose() {
        this.slot1.setVisible(false);
        this.slot2.setVisible(false);
        this.slot1.draw(0.0f, 0.0f, 0.0f);
        this.slot2.draw(0.0f, 0.0f, 0.0f);
    }

    public boolean canRenderTooltip(ItemStack stack) {
        AbilityData data = AbilityData.get((EntityLivingBase)this.mc.field_71439_g, this.ability.getName());
        if (data.isLocked()) {
            return true;
        }
        Slot invSlot1 = this.gui.field_147002_h.func_75139_a(0);
        Slot invSlot2 = this.gui.field_147002_h.func_75139_a(1);
        return invSlot1.func_75211_c() != stack && invSlot2.func_75211_c() != stack;
    }
}

