/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.model_loaders.obj;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.client.model_loaders.obj.ObjModel;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class ObjLoader {
    private static ArrayList<Vec3d> vertices = new ArrayList();
    private static ArrayList<Vec2f> texCoords = new ArrayList();
    private static ArrayList<Vec3d> normals = new ArrayList();
    private static String currentName = "";

    public static ObjModel load(ResourceLocation model) {
        try {
            BufferedReader read = new BufferedReader(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(model).func_110527_b()));
            currentName = model.toString();
            return ObjLoader.parseObj(read);
        }
        catch (Exception e) {
            AvatarLog.error("Failed to load model: " + model, e);
            return null;
        }
    }

    private static ObjModel parseObj(BufferedReader read) throws Exception {
        vertices.clear();
        texCoords.clear();
        normals.clear();
        String currentLine = null;
        String name = "";
        int lineNumber = 0;
        int currentList = 0;
        boolean isDrawing = false;
        ObjModel model = new ObjModel();
        while ((currentLine = read.readLine()) != null) {
            String[] values;
            ++lineNumber;
            if ((currentLine = currentLine.trim()).startsWith("#") || currentLine.isEmpty()) continue;
            if (currentLine.startsWith("o") || currentLine.startsWith("g")) {
                name = currentLine.split(" ")[1].trim();
                if (isDrawing) {
                    Tessellator.func_178181_a().func_78381_a();
                    GL11.glEndList();
                }
                isDrawing = true;
                Tessellator.func_178181_a().func_178180_c().func_181668_a(4, DefaultVertexFormats.field_181710_j);
                currentList = GL11.glGenLists((int)1);
                GL11.glNewList((int)currentList, (int)4864);
                model.nameToCallList.add((Pair<String, Integer>)Pair.of((Object)name, (Object)currentList));
                continue;
            }
            if (currentLine.startsWith("v ")) {
                values = currentLine.split(" ");
                if (values.length == 4) {
                    try {
                        vertices.add(new Vec3d((double)Float.parseFloat(values[1]), (double)Float.parseFloat(values[2]), (double)Float.parseFloat(values[3])));
                        continue;
                    }
                    catch (Exception e) {
                        throw new Exception("Model " + currentName + " has bad number format on line " + lineNumber, e);
                    }
                }
                throw new Exception("Model " + currentName + " has a bad number of values on line " + lineNumber);
            }
            if (currentLine.startsWith("vt ")) {
                values = currentLine.split(" ");
                if (values.length == 3) {
                    try {
                        texCoords.add(new Vec2f(Float.parseFloat(values[1]), Float.parseFloat(values[2])));
                        continue;
                    }
                    catch (Exception e) {
                        throw new Exception("Model " + currentName + " has bad number format on line " + lineNumber, e);
                    }
                }
                throw new Exception("Model " + currentName + " has a bad number of values on line " + lineNumber);
            }
            if (currentLine.startsWith("vn ")) {
                values = currentLine.split(" ");
                if (values.length == 4) {
                    try {
                        normals.add(new Vec3d((double)Float.parseFloat(values[1]), (double)Float.parseFloat(values[2]), (double)Float.parseFloat(values[3])));
                        continue;
                    }
                    catch (Exception e) {
                        throw new Exception("Model " + currentName + " has bad number format on line " + lineNumber, e);
                    }
                }
                throw new Exception("Model " + currentName + " has a bad number of values on line " + lineNumber);
            }
            if (!currentLine.startsWith("f ")) continue;
            String[] parts = currentLine.split(" ");
            if (parts.length == 4) {
                ObjLoader.addVertex(parts[1], lineNumber);
                ObjLoader.addVertex(parts[2], lineNumber);
                ObjLoader.addVertex(parts[3], lineNumber);
                continue;
            }
            throw new Exception("Model " + currentName + " has bad face format on line " + lineNumber);
        }
        if (isDrawing) {
            Tessellator.func_178181_a().func_78381_a();
            GL11.glEndList();
        }
        return model;
    }

    private static void addVertex(String part, int lineNumber) throws Exception {
        try {
            String[] indices = part.split("/");
            Vec3d pos = vertices.get(Integer.parseInt(indices[0]) - 1);
            Vec2f tex = texCoords.get(Integer.parseInt(indices[1]) - 1);
            Vec3d normal = normals.get(Integer.parseInt(indices[2]) - 1);
            Tessellator.func_178181_a().func_178180_c().func_181662_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c).func_187315_a((double)tex.field_189982_i, (double)tex.field_189983_j).func_181663_c((float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c).func_181675_d();
        }
        catch (Exception e) {
            throw new Exception("Model " + currentName + " has bad face on line " + lineNumber, e);
        }
    }
}

