/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.particle;

import com.crowsofwar.avatar.config.ConfigClient;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.common.util.EnumHelper;

public class AvatarParticles {
    private static EnumParticleTypes particleFlames;
    private static EnumParticleTypes particleAir;
    private static EnumParticleTypes particleRestore;
    private static EnumParticleTypes particleElectricity;
    private static EnumParticleTypes particleBigFlames;
    private static EnumParticleTypes particleFire;
    private static Map<Integer, EnumParticleTypes> lookup;
    private static Map<String, EnumParticleTypes> name;

    public static void register() {
        lookup = new HashMap<Integer, EnumParticleTypes>();
        name = new HashMap<String, EnumParticleTypes>();
        particleFlames = AvatarParticles.addParticle("flames");
        particleFire = AvatarParticles.addParticle("fire");
        particleBigFlames = AvatarParticles.addParticle("big_flame");
        particleAir = AvatarParticles.addParticle("air");
        particleRestore = AvatarParticles.addParticle("restore");
        particleElectricity = AvatarParticles.addParticle("electricity");
    }

    private static EnumParticleTypes addParticle(String particleName) {
        EnumParticleTypes particle = (EnumParticleTypes)EnumHelper.addEnum(EnumParticleTypes.class, (String)("AVATAR_" + particleName.toUpperCase()), (Class[])new Class[]{String.class, Integer.TYPE, Boolean.TYPE}, (Object[])new Object[]{"avatar" + particleName.substring(0, 1).toUpperCase() + particleName.substring(1).toLowerCase(), AvatarParticles.nextParticleId(), true});
        lookup.put(particle.func_179348_c(), particle);
        name.put(particle.func_179346_b(), particle);
        return particle;
    }

    private static int nextParticleId() {
        EnumParticleTypes[] allParticles = EnumParticleTypes.values();
        int maxId = -1;
        for (EnumParticleTypes particle : allParticles) {
            if (particle.func_179348_c() <= maxId) continue;
            maxId = particle.func_179348_c();
        }
        return maxId + 1;
    }

    public static EnumParticleTypes getParticleFromName(String particleName) {
        return name.get(particleName);
    }

    public static EnumParticleTypes getParticleFlames() {
        ConfigClient.CLIENT_CONFIG.getClass();
        return particleFlames;
    }

    public static EnumParticleTypes getParticleFire() {
        ConfigClient.CLIENT_CONFIG.getClass();
        return particleFire;
    }

    public static EnumParticleTypes getParticleBigFlame() {
        ConfigClient.CLIENT_CONFIG.getClass();
        return particleBigFlames;
    }

    public static EnumParticleTypes getParticleAir() {
        ConfigClient.CLIENT_CONFIG.getClass();
        return particleAir;
    }

    public static EnumParticleTypes getParticleRestore() {
        ConfigClient.CLIENT_CONFIG.getClass();
        return particleRestore;
    }

    public static EnumParticleTypes getParticleElectricity() {
        ConfigClient.CLIENT_CONFIG.getClass();
        return particleElectricity;
    }

    public static EnumParticleTypes lookup(int id) {
        return lookup.get(id);
    }
}

