/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.particle;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.client.particles.newparticles.ParticleAvatar;
import com.crowsofwar.avatar.client.particles.newparticles.behaviour.ParticleAvatarBehaviour;
import com.crowsofwar.avatar.client.particles.newparticles.renderlayers.ParticleBatchRenderer;
import com.crowsofwar.avatar.config.ConfigClient;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class ParticleBuilder {
    public static final ParticleBuilder instance = new ParticleBuilder();
    private boolean building = false;
    private ResourceLocation type;
    private double x;
    private double y;
    private double z;
    private double vx;
    private double vy;
    private double vz;
    private float r;
    private float g;
    private float b;
    private float a;
    private float rSR;
    private float gSR;
    private float bSR;
    private float aSR;
    private float rSI;
    private float gSI;
    private float bSI;
    private float aSI;
    private float fr;
    private float fg;
    private float fb;
    private boolean glow;
    private boolean sparkle;
    private BendingStyle element;
    private Ability ability;
    private double radius;
    private double rpt;
    private int lifetime;
    private boolean gravity;
    private boolean shaded;
    private boolean collide;
    private boolean collideParticles;
    private float scale;
    private Entity entity;
    private Entity spawnEntity;
    private float yaw;
    private float pitch;
    private double tx;
    private double ty;
    private double tz;
    private double tvx;
    private double tvy;
    private double tvz;
    private Entity target;
    private long seed;
    private double length;
    private ParticleAvatarBehaviour behaviour;

    private ParticleBuilder() {
        this.reset();
    }

    public static ParticleBuilder create(ResourceLocation type) {
        return instance.particle(type);
    }

    public static ParticleBuilder create(ResourceLocation type, Entity entity) {
        double x = entity.field_70165_t + (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N;
        double y = entity.field_70163_u + entity.field_70170_p.field_73012_v.nextDouble() * (double)entity.field_70131_O;
        double z = entity.field_70161_v + (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N;
        return instance.particle(type).pos(x, y, z);
    }

    public static ParticleBuilder create(ResourceLocation type, Random random, double x, double y, double z, double radius, boolean move) {
        double px = x + (random.nextDouble() * 2.0 - 1.0) * radius;
        double py = y + (random.nextDouble() * 2.0 - 1.0) * radius;
        double pz = z + (random.nextDouble() * 2.0 - 1.0) * radius;
        if (move) {
            return instance.particle(type).pos(px, py, pz).vel(px - x, py - y, pz - z);
        }
        return instance.particle(type).pos(px, py, pz);
    }

    public static void spawnShockParticles(World world, double x, double y, double z) {
        for (int i = 0; i < 8; ++i) {
            double px = x + world.field_73012_v.nextDouble() - 0.5;
            double py = y + world.field_73012_v.nextDouble() - 0.5;
            double pz = z + world.field_73012_v.nextDouble() - 0.5;
            ParticleBuilder.create(Type.SPARK).pos(px, py, pz).spawn(world);
            px = x + world.field_73012_v.nextDouble() - 0.5;
            py = y + world.field_73012_v.nextDouble() - 0.5;
            pz = z + world.field_73012_v.nextDouble() - 0.5;
            world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, px, py, pz, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public static void spawnHealParticles(World world, EntityLivingBase entity) {
        for (int i = 0; i < 10; ++i) {
            double x = entity.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            double y = entity.func_174813_aQ().field_72338_b + (double)entity.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
            double z = entity.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            ParticleBuilder.create(Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(1.0f, 1.0f, 0.3f).spawn(world);
        }
        ParticleBuilder.create(Type.BUFF).entity((Entity)entity).clr(1.0f, 1.0f, 0.3f).spawn(world);
    }

    public ParticleBuilder glow(boolean glow) {
        this.glow = glow;
        return this;
    }

    public void sparkle(boolean sparkle) {
        this.sparkle = sparkle;
    }

    public ParticleBuilder particle(ResourceLocation type) {
        if (this.building) {
            AvatarLog.warn("Already building! Particle being built: " + this.getCurrentParticleString());
            this.reset();
        }
        this.type = type;
        this.building = true;
        return this;
    }

    private String getCurrentParticleString() {
        return String.format("[ Type: %s, Position: (%s, %s, %s), Velocity: (%s, %s, %s), Colour: (%s, %s, %s), Fade Colour: (%s, %s, %s), Radius: %s, Revs/tick: %s, Lifetime: %s, Gravity: %s, Shaded: %s, Scale: %s, Entity: %s ]", this.type, this.x, this.y, this.z, this.vx, this.vy, this.vz, Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.fr), Float.valueOf(this.fg), Float.valueOf(this.fb), this.radius, this.rpt, this.lifetime, this.gravity, this.shaded, Float.valueOf(this.scale), this.entity, this.spawnEntity);
    }

    public ParticleBuilder pos(double x, double y, double z) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public ParticleBuilder behaviour(ParticleAvatarBehaviour behaviour) {
        this.behaviour = behaviour;
        return this;
    }

    public ParticleBuilder pos(Vec3d pos) {
        return this.pos(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public ParticleBuilder vel(double vx, double vy, double vz) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
        return this;
    }

    public ParticleBuilder vel(Vec3d vel) {
        return this.vel(vel.field_72450_a, vel.field_72448_b, vel.field_72449_c);
    }

    public ParticleBuilder clr(float r, float g, float b) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.r = MathHelper.func_76131_a((float)r, (float)0.0f, (float)1.0f);
        this.g = MathHelper.func_76131_a((float)g, (float)0.0f, (float)1.0f);
        this.b = MathHelper.func_76131_a((float)b, (float)0.0f, (float)1.0f);
        return this;
    }

    public ParticleBuilder clr(float r, float g, float b, float a) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.r = MathHelper.func_76131_a((float)r, (float)0.0f, (float)1.0f);
        this.g = MathHelper.func_76131_a((float)g, (float)0.0f, (float)1.0f);
        this.b = MathHelper.func_76131_a((float)b, (float)0.0f, (float)1.0f);
        this.a = MathHelper.func_76131_a((float)a, (float)0.0f, (float)1.0f);
        return this;
    }

    public ParticleBuilder clrShift(float r, float g, float b, float a, float rS, float gS, float bS, float aS, float rI, float gI, float bI, float aI) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.r = MathHelper.func_76131_a((float)r, (float)0.0f, (float)1.0f);
        this.g = MathHelper.func_76131_a((float)g, (float)0.0f, (float)1.0f);
        this.b = MathHelper.func_76131_a((float)b, (float)0.0f, (float)1.0f);
        this.a = MathHelper.func_76131_a((float)a, (float)0.0f, (float)1.0f);
        this.rSI = MathHelper.func_76131_a((float)rI, (float)0.0f, (float)1.0f);
        this.gSI = MathHelper.func_76131_a((float)gI, (float)0.0f, (float)1.0f);
        this.bSI = MathHelper.func_76131_a((float)bI, (float)0.0f, (float)1.0f);
        this.aSI = MathHelper.func_76131_a((float)aI, (float)0.0f, (float)1.0f);
        this.rSR = MathHelper.func_76131_a((float)rS, (float)0.0f, (float)1.0f);
        this.gSR = MathHelper.func_76131_a((float)bS, (float)0.0f, (float)1.0f);
        this.bSR = MathHelper.func_76131_a((float)gS, (float)0.0f, (float)1.0f);
        this.aSI = MathHelper.func_76131_a((float)aS, (float)0.0f, (float)1.0f);
        return this;
    }

    public ParticleBuilder element(BendingStyle element) {
        this.element = element;
        return this;
    }

    public ParticleBuilder ability(Ability ability) {
        this.ability = ability;
        return this;
    }

    public ParticleBuilder clr(int r, int g, int b) {
        return this.clr((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public ParticleBuilder clr(int r, int g, int b, int a) {
        return this.clr((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public ParticleBuilder clr(int hex) {
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        return this.clr(r, g, b);
    }

    public ParticleBuilder fade(float r, float g, float b) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.fr = MathHelper.func_76131_a((float)r, (float)0.0f, (float)1.0f);
        this.fg = MathHelper.func_76131_a((float)g, (float)0.0f, (float)1.0f);
        this.fb = MathHelper.func_76131_a((float)b, (float)0.0f, (float)1.0f);
        return this;
    }

    public ParticleBuilder fade(int r, int g, int b) {
        return this.clr((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public ParticleBuilder fade(int r, int g, int b, int a) {
        return this.clr((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public ParticleBuilder fade(int hex) {
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        return this.clr(r, g, b);
    }

    public ParticleBuilder scale(float scale) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.scale = scale;
        return this;
    }

    public ParticleBuilder time(int lifetime) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.lifetime = lifetime;
        return this;
    }

    public ParticleBuilder seed(long seed) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.seed = seed;
        return this;
    }

    public ParticleBuilder spin(double radius, double speed) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.radius = radius;
        this.rpt = speed;
        return this;
    }

    public ParticleBuilder gravity(boolean gravity) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.gravity = gravity;
        return this;
    }

    public ParticleBuilder shaded(boolean shaded) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.shaded = shaded;
        return this;
    }

    public ParticleBuilder collide(boolean collide) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        ConfigClient.CLIENT_CONFIG.particleSettings.getClass();
        this.collide = collide;
        return this;
    }

    public ParticleBuilder collideParticles(boolean collide) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        ConfigClient.CLIENT_CONFIG.particleSettings.getClass();
        this.collideParticles = collide;
        return this;
    }

    public ParticleBuilder entity(Entity entity) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.entity = entity;
        this.spawnEntity = entity;
        return this;
    }

    public ParticleBuilder spawnEntity(Entity entity) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.spawnEntity = entity;
        return this;
    }

    public ParticleBuilder face(float yaw, float pitch) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.yaw = yaw;
        this.pitch = pitch;
        return this;
    }

    public ParticleBuilder face(EnumFacing direction) {
        return this.face(direction.func_185119_l(), direction.func_176740_k().func_176720_b() ? (float)(direction.func_176743_c().func_179524_a() * 90) : 0.0f);
    }

    public ParticleBuilder target(double x, double y, double z) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.tx = x;
        this.ty = y;
        this.tz = z;
        return this;
    }

    public ParticleBuilder target(Vec3d pos) {
        return this.target(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public ParticleBuilder tvel(double vx, double vy, double vz) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.tvx = vx;
        this.tvy = vy;
        this.tvz = vz;
        return this;
    }

    public ParticleBuilder tvel(Vec3d vel) {
        return this.tvel(vel.field_72450_a, vel.field_72448_b, vel.field_72449_c);
    }

    public ParticleBuilder length(double length) {
        this.length = length;
        return this;
    }

    public ParticleBuilder target(Entity target) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.target = target;
        return this;
    }

    public void spawn(World world) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        if (this.y < 0.0 && this.entity == null) {
            AvatarLog.warn(AvatarLog.WarningType.INVALID_CODE, "Spawning particle below y = 0 - are you sure the position/entity has been set correctly?");
        }
        if (!world.field_72995_K) {
            AvatarLog.warn(AvatarLog.WarningType.BAD_CLIENT_PACKET, "ParticleBuilder.spawn(...) called on the server side! ParticleBuilder has prevented a server crash, but calling it on the server will do nothing. Consider adding a world.isRemote check.");
            this.reset();
            return;
        }
        ParticleAvatar particle = AvatarMod.proxy.createParticle(this.type, world, this.x, this.y, this.z);
        if (particle == null) {
            this.reset();
            return;
        }
        boolean colourShift = true;
        float[] colourShiftInterval = new float[]{this.rSI, this.gSI, this.bSI, this.aSI};
        float[] colourShiftRange = new float[4];
        colourShiftInterval[0] = this.rSR;
        colourShiftInterval[1] = this.gSR;
        colourShiftInterval[2] = this.bSR;
        colourShiftInterval[3] = this.aSR;
        if (!(Double.isNaN(this.vx) || Double.isNaN(this.vy) || Double.isNaN(this.vz))) {
            particle.setVelocity(this.vx, this.vy, this.vz);
        }
        if (this.r >= 0.0f && this.g >= 0.0f && this.b >= 0.0f) {
            particle.func_70538_b(this.r, this.g, this.b);
        }
        if (this.a >= 0.0f) {
            particle.func_82338_g(this.a);
        }
        if (this.fr >= 0.0f && this.fg >= 0.0f && this.fb >= 0.0f) {
            particle.setFadeColour(this.fr, this.fg, this.fb);
        }
        for (int i = 0; i < 4; ++i) {
            if (!(colourShiftInterval[i] < 0.0f) && !(colourShiftRange[i] < 0.0f)) continue;
            colourShift = false;
        }
        if (colourShift) {
            particle.setColourShift(colourShiftInterval, colourShiftRange);
        }
        if (this.lifetime >= 0) {
            particle.func_187114_a(this.lifetime);
        }
        if (this.radius > 0.0) {
            particle.setSpin(this.radius, this.rpt);
        }
        if (!Float.isNaN(this.yaw) && !Float.isNaN(this.pitch)) {
            particle.setFacing(this.yaw, this.pitch);
        }
        if (this.seed != 0L) {
            particle.setSeed(this.seed);
        }
        if (!(Double.isNaN(this.tvx) || Double.isNaN(this.tvy) || Double.isNaN(this.tvz))) {
            particle.setTargetVelocity(this.tvx, this.tvy, this.tvz);
        }
        if (this.length > 0.0) {
            particle.setLength(this.length);
        }
        if (this.element != null) {
            particle.setElement(this.element);
        }
        if (this.ability != null) {
            particle.setAbility(this.ability);
        }
        if (this.behaviour != null) {
            particle.setBehaviour(this.behaviour);
        }
        UUID id = UUID.randomUUID();
        particle.setUUID(id);
        particle.func_70541_f(this.scale);
        particle.setGravity(this.gravity);
        particle.setShaded(this.shaded);
        particle.setGlowing(this.glow);
        particle.setSparkle(this.sparkle);
        particle.setCollisions(this.collide);
        particle.canCollideParticles = this.collideParticles;
        particle.setEntity(this.entity);
        particle.setSpawnEntity(this.spawnEntity);
        particle.setTargetPosition(this.tx, this.ty, this.tz);
        particle.setTargetEntity(this.target);
        float width = this.scale / 8.0f;
        particle.func_187108_a(new AxisAlignedBB(this.x - (double)width, this.y, this.z - (double)width, this.x + (double)width, this.y + (double)(this.scale / 4.0f), this.z + (double)width));
        if (particle.getCustomRenderLayer() != null) {
            ParticleBatchRenderer.addParticle(particle);
        } else {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
        }
        this.reset();
    }

    private void reset() {
        this.building = false;
        this.type = null;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.vx = Double.NaN;
        this.vy = Double.NaN;
        this.vz = Double.NaN;
        this.r = -1.0f;
        this.g = -1.0f;
        this.b = -1.0f;
        this.a = -1.0f;
        this.fr = -1.0f;
        this.fg = -1.0f;
        this.fb = -1.0f;
        this.radius = 0.0;
        this.rpt = 0.0;
        this.lifetime = -1;
        this.gravity = false;
        this.shaded = false;
        this.collide = false;
        this.collideParticles = false;
        this.sparkle = false;
        this.glow = false;
        this.scale = 1.0f;
        this.entity = null;
        this.spawnEntity = null;
        this.yaw = Float.NaN;
        this.pitch = Float.NaN;
        this.tx = Double.NaN;
        this.ty = Double.NaN;
        this.tz = Double.NaN;
        this.tvx = Double.NaN;
        this.tvy = Double.NaN;
        this.tvz = Double.NaN;
        this.target = null;
        this.element = null;
        this.ability = null;
        this.behaviour = null;
        this.seed = 0L;
        this.length = -1.0;
    }

    public static class Type {
        public static final ResourceLocation BEAM = new ResourceLocation("avatarmod", "beam");
        public static final ResourceLocation BUFF = new ResourceLocation("avatarmod", "buff");
        public static final ResourceLocation DARK_MAGIC = new ResourceLocation("avatarmod", "dark_magic");
        public static final ResourceLocation DUST = new ResourceLocation("avatarmod", "dust");
        public static final ResourceLocation FIRE = new ResourceLocation("avatarmod", " fire");
        public static final ResourceLocation FLASH = new ResourceLocation("avatarmod", "flash");
        public static final ResourceLocation ICE = new ResourceLocation("avatarmod", "ice");
        public static final ResourceLocation LEAF = new ResourceLocation("avatarmod", "leaf");
        public static final ResourceLocation LIGHTNING = new ResourceLocation("avatarmod", "lightning");
        public static final ResourceLocation LIGHTNING_PULSE = new ResourceLocation("avatarmod", "lightning_pulse");
        public static final ResourceLocation MAGIC_BUBBLE = new ResourceLocation("avatarmod", "magic_bubble");
        public static final ResourceLocation MAGIC_FIRE = new ResourceLocation("avatarmod", "magic_fire");
        public static final ResourceLocation PATH = new ResourceLocation("avatarmod", "path");
        public static final ResourceLocation SCORCH = new ResourceLocation("avatarmod", "scorch");
        public static final ResourceLocation SNOW = new ResourceLocation("avatarmod", "snow");
        public static final ResourceLocation SPARK = new ResourceLocation("avatarmod", "spark");
        public static final ResourceLocation SPARKLE = new ResourceLocation("avatarmod", "sparkle");
        public static final ResourceLocation SPHERE = new ResourceLocation("avatarmod", "sphere");
        public static final ResourceLocation SUMMON = new ResourceLocation("avatarmod", "summon");
        public static final ResourceLocation VINE = new ResourceLocation("avatarmod", "vine");
        public static final ResourceLocation CUBE = new ResourceLocation("avatarmod", "cube");
    }
}

