/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.particles.newparticles;

import com.crowsofwar.avatar.client.particles.newparticles.ParticleFlash;
import com.crowsofwar.avatar.config.ConfigClient;
import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="avatarmod")
public class FlashParticleBatchRenderer {
    private static final ResourceLocation PARTICLE_TEXTURES = new ResourceLocation("minecraft", "textures/particle/particles.png");
    private static final Queue<ParticleFlash> queue = Queues.newArrayDeque();
    public static ArrayDeque<ParticleFlash>[] particles = new ArrayDeque[2];

    public static void addParticle(ParticleFlash p) {
        if (p != null) {
            queue.add(p);
        }
    }

    public static void updateParticles() {
        if (Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        for (ArrayDeque<ParticleFlash> a : particles) {
            Iterator<ParticleFlash> itr = a.iterator();
            while (itr.hasNext()) {
                ParticleFlash p = itr.next();
                p.func_189213_a();
                if (p.func_187113_k()) continue;
                itr.remove();
            }
        }
        if (!queue.isEmpty()) {
            ParticleFlash particle = queue.poll();
            while (particle != null) {
                int glow;
                int n = glow = particle.glow ? 1 : 0;
                if (particles[glow].size() > 16384) {
                    particles[glow].removeFirst();
                }
                particles[glow].add(particle);
                particle = queue.poll();
            }
        }
    }

    public static void renderParticles(Entity entityIn, float partialTicks) {
        float f = ActiveRenderInfo.func_178808_b();
        float f1 = ActiveRenderInfo.func_178803_d();
        float f2 = ActiveRenderInfo.func_178805_e();
        float f3 = ActiveRenderInfo.func_178807_f();
        float f4 = ActiveRenderInfo.func_178809_c();
        Particle.field_70556_an = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        Particle.field_70554_ao = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        Particle.field_70555_ap = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        Particle.field_190016_K = entityIn.func_70676_i(partialTicks);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        GlStateManager.func_179132_a((boolean)false);
        ConfigClient.CLIENT_CONFIG.particleSettings.getClass();
        if (GL11.glGetInteger((int)35725) != 0) {
            GL20.glUseProgram((int)0);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(PARTICLE_TEXTURES);
        for (int i = 0; i < particles.length; ++i) {
            if (i == 0) {
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            } else if (i == 1) {
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            particles[i].forEach(particle -> particle.func_180434_a(bufferbuilder, entityIn, partialTicks, f, f4, f1, f2, f3));
            tessellator.func_78381_a();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    @SubscribeEvent
    public static void renderLast(RenderWorldLastEvent event) {
        FlashParticleBatchRenderer.renderParticles(Minecraft.func_71410_x().func_175606_aa(), event.getPartialTicks());
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            FlashParticleBatchRenderer.updateParticles();
        }
    }

    static {
        for (int i = 0; i < particles.length; ++i) {
            FlashParticleBatchRenderer.particles[i] = Queues.newArrayDeque();
        }
    }
}

