/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.particles.newparticles;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.bending.bending.water.Waterbending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.client.particles.newparticles.behaviour.ParticleAvatarBehaviour;
import com.crowsofwar.avatar.client.particles.newparticles.renderlayers.ParticleBatchRenderer;
import com.crowsofwar.avatar.client.particles.newparticles.renderlayers.RenderLayer;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.EntityShield;
import com.crowsofwar.avatar.entity.EntityWall;
import com.crowsofwar.avatar.entity.EntityWallSegment;
import com.crowsofwar.avatar.entity.ICustomHitbox;
import com.crowsofwar.avatar.entity.IOffensiveEntity;
import com.crowsofwar.avatar.network.AvatarClientProxy;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ParticleAvatar
extends Particle {
    public static final float MAX_PARTICLE_SIZE = 0.25f;
    private static final double SPREAD_FACTOR = 0.2;
    private static final double IMPACT_FRICTION = 0.2;
    protected final TextureAtlasSprite[] sprites;
    public float angle;
    public double ticksExisted;
    public boolean canCollideParticles = false;
    protected long seed;
    protected Random random = new Random();
    protected boolean shaded = false;
    protected float initialRed;
    protected float initialGreen;
    protected float initialBlue;
    protected float fadeRed = 0.0f;
    protected float fadeGreen = 0.0f;
    protected float fadeBlue = 0.0f;
    protected double radius = 0.0;
    protected double speed = 0.0;
    protected UUID uuid = UUID.fromString("ccc7dd56-8fcc-4477-9782-7f0423e5616d");
    protected BendingStyle element;
    protected Ability ability;
    protected boolean glow;
    protected boolean sparkle;
    protected float expansionRate;
    protected float[] colourShiftRange = new float[4];
    protected boolean shiftRandomly = false;
    protected float[] colourShiftInterval = new float[4];
    protected boolean scaleOnUpdate;
    protected double scaleChange;
    protected boolean speedChangeOnUpdate;
    protected double speedChange;
    @Nullable
    protected Entity entity = null;
    @Nullable
    protected Entity spawnEntity;
    protected double relativeX;
    protected double relativeY;
    protected double relativeZ;
    protected double relativeMotionX;
    protected double relativeMotionY;
    protected double relativeMotionZ;
    protected float yaw = Float.NaN;
    protected float pitch = Float.NaN;
    private ParticleAvatarBehaviour behaviour;
    private boolean collidedWithSolid;
    private boolean collidedWithParticle = false;
    private boolean dynamicCollidedWithEntity;
    private double prevVelX;
    private double prevVelY;
    private double prevVelZ;

    public ParticleAvatar(World world, double x, double y, double z, ResourceLocation ... textures) {
        super(world, x, y, z);
        this.relativeX = x;
        this.relativeY = y;
        this.relativeZ = z;
        if (textures.length > 0) {
            this.sprites = Arrays.stream(textures).map(t -> Minecraft.func_71410_x().func_147117_R().func_110572_b(t.toString())).collect(Collectors.toList()).toArray(new TextureAtlasSprite[0]);
            this.func_187117_a(this.sprites[0]);
        } else {
            this.sprites = new TextureAtlasSprite[0];
        }
    }

    public static ResourceLocation[] generateTextures(String stem, int n) {
        ResourceLocation[] textures = new ResourceLocation[n];
        for (int i = 0; i < n; ++i) {
            textures[i] = new ResourceLocation("avatarmod", "particles/newparticles/" + stem + "_" + i);
        }
        return textures;
    }

    public static ResourceLocation[][] generateTextures(String stem, int m, int n) {
        ResourceLocation[][] textures = new ResourceLocation[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                textures[i][j] = new ResourceLocation("avatarmod", "particles/newparticles/" + stem + "_" + i + "_" + j);
            }
        }
        return textures;
    }

    public static void registerParticle(ResourceLocation name, IAvatarParticleFactory factory) {
        AvatarClientProxy.addParticleFactory(name, factory);
    }

    public void setGlowing(boolean glow) {
        this.glow = glow;
    }

    public boolean glows() {
        return this.glow;
    }

    public void setSparkle(boolean sparkle) {
        this.sparkle = sparkle;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.random = new Random(seed);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public Vec3d getVelocity() {
        return new Vec3d(this.field_187129_i, this.field_187130_j, this.field_187131_k);
    }

    public Entity getEntity() {
        return this.spawnEntity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
        if (entity != null) {
            this.func_187109_b(this.entity.field_70165_t + this.relativeX, this.entity.func_174813_aQ().field_72338_b + this.relativeY, this.entity.field_70161_v + this.relativeZ);
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            this.relativeMotionX = this.field_187129_i;
            this.relativeMotionY = this.field_187130_j;
            this.relativeMotionZ = this.field_187131_k;
        }
    }

    public void setShaded(boolean shaded) {
        this.shaded = shaded;
    }

    public void setGravity(boolean gravity) {
        this.field_70545_g = gravity ? 1.0f : 0.0f;
    }

    public void setCollisions(boolean canCollide) {
        this.field_190017_n = canCollide;
    }

    public void setElement(BendingStyle element) {
        this.element = element;
    }

    public Ability getAbility() {
        return this.ability;
    }

    public void setAbility(Ability ability) {
        this.ability = ability;
    }

    public void setVelocity(double vx, double vy, double vz) {
        this.field_187129_i = vx;
        this.field_187130_j = vy;
        this.field_187131_k = vz;
    }

    public void setParticleAngle(float angle) {
        this.field_190014_F = angle;
    }

    public void setSpin(double radius, double speed) {
        this.radius = radius;
        this.speed = speed * 2.0 * Math.PI;
        this.angle = this.field_187136_p.nextFloat() * (float)Math.PI * 2.0f;
        this.field_187126_f = this.relativeX - radius * (double)MathHelper.func_76134_b((float)this.angle);
        this.field_187128_h = this.relativeZ + radius * (double)MathHelper.func_76126_a((float)this.angle);
        this.relativeMotionX = this.field_187129_i;
        this.relativeMotionY = this.field_187130_j;
        this.relativeMotionZ = this.field_187131_k;
    }

    public Entity getSpawnEntity() {
        return this.spawnEntity;
    }

    public void setSpawnEntity(Entity entity) {
        this.spawnEntity = entity;
    }

    public void func_70538_b(float r, float g, float b) {
        super.func_70538_b(r, g, b);
        this.initialRed = r;
        this.initialGreen = g;
        this.initialBlue = b;
        this.setFadeColour(r, g, b);
    }

    public void setFadeColour(float r, float g, float b) {
        this.fadeRed = r;
        this.fadeGreen = g;
        this.fadeBlue = b;
    }

    public void setColourShift(float[] colourShiftInterval, float[] colourShiftRange) {
        this.colourShiftInterval = colourShiftInterval;
        this.colourShiftRange = colourShiftRange;
    }

    public void setFacing(float yaw, float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public void setTargetPosition(double x, double y, double z) {
    }

    public void setTargetVelocity(double vx, double vy, double vz) {
    }

    public void setTargetEntity(Entity target) {
    }

    public void setLength(double length) {
    }

    public int func_70537_b() {
        return this.sprites.length == 0 ? super.func_70537_b() : 1;
    }

    public int func_189214_a(float partialTick) {
        return this.shaded ? super.func_189214_a(partialTick) : 0xF000F0;
    }

    public void func_180434_a(BufferBuilder buffer, Entity viewer, float partialTicks, float lookZ, float lookY, float lookX, float lookXY, float lookYZ) {
        this.updateEntityLinking(partialTicks);
        if (Float.isNaN(this.yaw) || Float.isNaN(this.pitch)) {
            this.drawParticle(buffer, viewer, partialTicks, lookZ, lookY, lookX, lookXY, lookYZ);
        } else {
            float degToRadFactor = (float)Math.PI / 180;
            float rotationX = MathHelper.func_76134_b((float)(this.yaw * degToRadFactor));
            float rotationZ = MathHelper.func_76126_a((float)(this.yaw * degToRadFactor));
            float rotationY = MathHelper.func_76134_b((float)(this.pitch * degToRadFactor));
            float rotationYZ = -rotationZ * MathHelper.func_76126_a((float)(this.pitch * degToRadFactor));
            float rotationXY = rotationX * MathHelper.func_76126_a((float)(this.pitch * degToRadFactor));
            this.drawParticle(buffer, viewer, partialTicks, rotationX, rotationY, rotationZ, rotationYZ, rotationXY);
        }
    }

    protected void drawParticle(BufferBuilder buffer, Entity viewer, float partialTicks, float rotationX, float rotationY, float rotationZ, float rotationYZ, float rotationXY) {
        super.func_180434_a(buffer, viewer, partialTicks, rotationX, rotationY, rotationZ, rotationYZ, rotationXY);
    }

    protected void updateEntityLinking(float partialTicks) {
        if (this.entity != null) {
            this.field_187123_c = this.field_187126_f + this.entity.field_70169_q - this.entity.field_70165_t - this.relativeMotionX * (double)(1.0f - partialTicks);
            this.field_187124_d = this.field_187127_g + this.entity.field_70167_r - this.entity.field_70163_u - this.relativeMotionY * (double)(1.0f - partialTicks);
            this.field_187125_e = this.field_187128_h + this.entity.field_70166_s - this.entity.field_70161_v - this.relativeMotionZ * (double)(1.0f - partialTicks);
        }
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (this.behaviour != null) {
            this.behaviour.onUpdate(this);
        }
        if (this.field_190017_n && this.field_187132_l) {
            this.field_187129_i /= (double)0.7f;
            this.field_187131_k /= (double)0.7f;
        } else if (this.entity != null || this.radius > 0.0) {
            double x = this.relativeX;
            double y = this.relativeY;
            double z = this.relativeZ;
            if (this.entity != null) {
                if (this.entity.field_70128_L) {
                    this.func_187112_i();
                } else if (!(!this.field_190017_n || this.field_187129_i == 0.0 && this.prevVelX != 0.0 || this.field_187130_j == 0.0 && this.prevVelY == 0.0 || this.field_187131_k == 0.0 && this.prevVelZ == 0.0)) {
                    x += this.entity.field_70165_t;
                    y += this.entity.field_70163_u;
                    z += this.entity.field_70161_v;
                }
            }
            if (this.radius > 0.0) {
                this.angle = (float)((double)this.angle + this.speed);
                x += this.radius * (double)(-MathHelper.func_76134_b((float)this.angle));
                z += this.radius * (double)MathHelper.func_76126_a((float)this.angle);
            }
            this.func_187109_b(x, y, z);
            this.relativeX += this.relativeMotionX;
            this.relativeY += this.relativeMotionY;
            this.relativeZ += this.relativeMotionZ;
        }
        this.ticksExisted = this.field_70546_d;
        if (this.colourShiftRange[0] != 0.0f && this.colourShiftInterval[0] != 0.0f) {
            float rRange = this.colourShiftRange[0] / 2.0f;
            float gRange = this.colourShiftRange[1] / 2.0f;
            float bRange = this.colourShiftRange[2] / 2.0f;
            float aRange = this.colourShiftRange[3] / 2.0f;
            float r = this.initialRed;
            float g = this.initialGreen;
            float b = this.initialBlue;
            float a = 1.0f;
            block6: for (int i = 0; i < 4; ++i) {
                float rMin = r < rRange ? 0.0f : r - rRange;
                float gMin = g < gRange ? 0.0f : r - gRange;
                float bMin = b < bRange ? 0.0f : r - bRange;
                float aMin = a < aRange ? 0.0f : a - aRange;
                float rMax = r + rRange;
                float gMax = b + gRange;
                float bMax = g + bRange;
                float aMax = a + aRange;
                switch (i) {
                    case 0: {
                        float amountR = (float)AvatarUtils.getRandomNumberInRange(0, (int)(100.0f / rMax)) / 100.0f * this.colourShiftInterval[0];
                        float red = this.entity.field_70170_p.field_73012_v.nextBoolean() ? r + amountR : r - amountR;
                        this.field_70552_h = red = MathHelper.func_76131_a((float)red, (float)rMin, (float)rMax);
                        continue block6;
                    }
                    case 1: {
                        float amountG = (float)AvatarUtils.getRandomNumberInRange(0, (int)(100.0f / gMax)) / 100.0f * this.colourShiftInterval[1];
                        float green = this.entity.field_70170_p.field_73012_v.nextBoolean() ? g + amountG : g - amountG;
                        this.field_70553_i = green = MathHelper.func_76131_a((float)green, (float)gMin, (float)gMax);
                        continue block6;
                    }
                    case 2: {
                        float amountB = (float)AvatarUtils.getRandomNumberInRange(0, (int)(100.0f / bMax)) / 100.0f * this.colourShiftInterval[2];
                        float blue = this.entity.field_70170_p.field_73012_v.nextBoolean() ? b + amountB : b - amountB;
                        this.field_70551_j = blue = MathHelper.func_76131_a((float)blue, (float)bMin, (float)bMax);
                        continue block6;
                    }
                    case 3: {
                        float amountA = (float)AvatarUtils.getRandomNumberInRange(0, (int)(100.0f / aMax)) / 100.0f * this.colourShiftInterval[3];
                        float alpha = this.entity.field_70170_p.field_73012_v.nextBoolean() ? a + amountA : a - amountA;
                        this.field_82339_as = alpha = MathHelper.func_76131_a((float)alpha, (float)aMin, (float)aMax);
                    }
                }
            }
        }
        float ageFraction = (float)this.field_70546_d / (float)this.field_70547_e;
        this.field_70552_h = this.initialRed + (this.fadeRed - this.initialRed) * ageFraction;
        this.field_70553_i = this.initialGreen + (this.fadeGreen - this.initialGreen) * ageFraction;
        this.field_70551_j = this.initialBlue + (this.fadeBlue - this.initialBlue) * ageFraction;
        if (this.sprites.length > 1) {
            this.func_187117_a(this.sprites[Math.min((int)(ageFraction * (float)this.sprites.length), this.sprites.length - 1)]);
        }
        if (this.scaleOnUpdate) {
            this.field_70544_f = (float)((double)this.field_70544_f + this.scaleChange);
        }
        if (this.speedChangeOnUpdate) {
            this.field_187129_i += this.speedChange;
            this.field_187130_j += this.speedChange;
            this.field_187131_k += this.speedChange;
        }
        if (this.field_190017_n) {
            if (this.field_187129_i == 0.0 && this.prevVelX != 0.0) {
                this.field_187130_j *= 0.2;
                this.field_187131_k *= 0.2;
                this.field_187130_j += (this.field_187136_p.nextDouble() * 2.0 - 1.0) * this.prevVelX * 0.2;
                this.field_187131_k += (this.field_187136_p.nextDouble() * 2.0 - 1.0) * this.prevVelX * 0.2;
            }
            if (this.field_187130_j == 0.0 && this.prevVelY != 0.0) {
                this.field_187129_i *= 0.2;
                this.field_187131_k *= 0.2;
                this.field_187129_i += (this.field_187136_p.nextDouble() * 2.0 - 1.0) * this.prevVelY * 0.2;
                this.field_187131_k += (this.field_187136_p.nextDouble() * 2.0 - 1.0) * this.prevVelY * 0.2;
            }
            if (this.field_187131_k == 0.0 && this.prevVelZ != 0.0) {
                this.field_187129_i *= 0.2;
                this.field_187130_j *= 0.2;
                this.field_187129_i += (this.field_187136_p.nextDouble() * 2.0 - 1.0) * this.prevVelZ * 0.2;
                this.field_187130_j += (this.field_187136_p.nextDouble() * 2.0 - 1.0) * this.prevVelZ * 0.2;
            }
            double searchRadius = 20.0;
            if (this.spawnEntity != null) {
                List<Entity> nearbyEntities = AvatarEntityUtils.getEntitiesWithinRadius(searchRadius, this.field_187126_f, this.field_187127_g, this.field_187128_h, this.field_187122_b);
                Predicate<Object> customHitboxFilter = entity1 -> !(entity1 instanceof ICustomHitbox) || !((ICustomHitbox)entity1).contains(new Vec3d(this.field_187126_f, this.field_187127_g, this.field_187128_h));
                customHitboxFilter = customHitboxFilter.or(entity1 -> entity1 instanceof AvatarEntity && ((AvatarEntity)((Object)((Object)entity1))).getOwner() == this.spawnEntity);
                nearbyEntities.removeIf(customHitboxFilter);
                if (nearbyEntities.size() > 0) {
                    this.func_187112_i();
                }
            }
        }
        this.prevVelX = this.field_187129_i;
        this.prevVelY = this.field_187130_j;
        this.prevVelZ = this.field_187131_k;
    }

    public void func_187110_a(double x, double y, double z) {
        double origY = y;
        double origX = x;
        double origZ = z;
        if (this.field_190017_n) {
            if (this.ticksExisted % 2.0 == 0.0) {
                BlockPos pos = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
                IBlockState state = this.field_187122_b.func_180495_p(pos);
                if (state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i) {
                    this.onMajorWaterContact();
                }
                if (state.func_177230_c() == Blocks.field_150480_ab || state.func_177230_c() == Blocks.field_150353_l || state.func_177230_c() == Blocks.field_150356_k) {
                    this.onMajorFireContact();
                }
                if (this.field_187122_b.func_175727_C(pos)) {
                    this.onMinorWaterContact();
                }
            }
            List list = this.field_187122_b.func_184144_a(null, this.func_187116_l().func_72321_a(x, y, z).func_186662_g(0.1));
            List entityList = this.field_187122_b.func_72872_a(Entity.class, this.func_187116_l().func_72321_a(x, y, z).func_186662_g(0.15));
            this.collidedWithSolid = false;
            this.collidedWithParticle = false;
            this.dynamicCollidedWithEntity = false;
            for (Entity hit : entityList) {
                this.onCollideWithEntity(hit);
            }
            for (AxisAlignedBB axisalignedbb : list) {
                y = axisalignedbb.func_72323_b(this.func_187116_l(), y);
            }
            this.func_187108_a(this.func_187116_l().func_72317_d(0.0, y, 0.0));
            for (AxisAlignedBB axisalignedbb1 : list) {
                x = axisalignedbb1.func_72316_a(this.func_187116_l(), x);
            }
            this.func_187108_a(this.func_187116_l().func_72317_d(x, 0.0, 0.0));
            for (AxisAlignedBB axisalignedbb2 : list) {
                z = axisalignedbb2.func_72322_c(this.func_187116_l(), z);
            }
            this.func_187108_a(this.func_187116_l().func_72317_d(0.0, 0.0, z));
        } else {
            this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        }
        if (this.canCollideParticles && !AvatarUtils.getAliveParticles().isEmpty()) {
            ArrayDeque particles = Queues.newArrayDeque();
            List<List<ParticleAvatar>> particlesInArea = ParticleBatchRenderer.getCollidingParticlesWithinBBExcluding(this.getEntity(), this.func_187116_l());
            for (List<ParticleAvatar> list : particlesInArea) {
                for (ParticleAvatar p : list) {
                    if (p.getEntity() == this.getEntity() || !p.func_187116_l().func_72326_a(this.func_187116_l())) continue;
                    particles.add(p);
                }
            }
            if (!particles.isEmpty()) {
                this.collidedWithParticle = true;
                Vec3d hitVel = ((ParticleAvatar)((Object)particles.peek())).getVelocity();
                Vec3d pVel = this.getVelocity();
                if (AvatarUtils.getMagnitude(hitVel) >= AvatarUtils.getMagnitude(pVel)) {
                    this.field_187131_k = 0.0;
                    this.field_187130_j = 0.0;
                    this.field_187129_i = 0.0;
                } else {
                    this.field_187129_i += hitVel.field_72450_a;
                    this.field_187130_j += hitVel.field_72448_b;
                    this.field_187131_k += hitVel.field_72449_c;
                }
            }
        }
        this.func_187118_j();
        boolean bl = this.field_187132_l = origY != y && origY < 0.0;
        if (this.collidedWithSolid || this.collidedWithParticle) {
            this.field_187131_k = 0.0;
            this.field_187130_j = 0.0;
            this.field_187129_i = 0.0;
        }
        if (origX != x) {
            this.field_187129_i = 0.0;
        }
        if (origY != y) {
            this.field_187130_j = 0.0;
        }
        if (origZ != z) {
            this.field_187131_k = 0.0;
        }
    }

    public void onCollideWithEntity(Entity entity) {
        if (entity != this.getEntity() && (this.getAbility() != null || this.element != null)) {
            if (entity instanceof EntityShield && ((EntityShield)entity).getOwner() != this.getEntity() || entity instanceof EntityWall || entity instanceof EntityWallSegment) {
                this.collidedWithSolid = true;
            } else if (entity instanceof EntityThrowable || entity instanceof EntityArrow || entity instanceof EntityOffensive && ((EntityOffensive)entity).getOwner() != this.spawnEntity || entity instanceof IOffensiveEntity && ((AvatarEntity)entity).getOwner() != this.spawnEntity) {
                this.dynamicCollidedWithEntity = true;
                Vec3d hitVel = new Vec3d(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
                Vec3d pVel = new Vec3d(this.field_187129_i, this.field_187130_j, this.field_187131_k);
                if (AvatarUtils.getMagnitude(hitVel) >= AvatarUtils.getMagnitude(pVel)) {
                    this.field_187131_k = 0.0;
                    this.field_187130_j = 0.0;
                    this.field_187129_i = 0.0;
                } else {
                    this.field_187129_i += entity.field_70159_w;
                    this.field_187130_j += entity.field_70181_x;
                    this.field_187131_k += entity.field_70179_y;
                }
                if (entity instanceof AvatarEntity) {
                    this.applyElementalContact((AvatarEntity)entity);
                }
            } else if (this.spawnEntity != null && this.getAbility() != null && entity != this.spawnEntity && !(entity instanceof AvatarEntity) || !(entity instanceof AvatarEntity) || ((AvatarEntity)entity).getOwner() == this.spawnEntity || !this.collidedWithSolid) {
                // empty if block
            }
        }
    }

    public void onMinorWaterContact() {
        if (this.getAbility() != null && this.getAbility().getElement() instanceof Firebending || this.element instanceof Firebending) {
            if (this.getSpawnEntity() instanceof EntityLivingBase && this.getAbility() != null) {
                AbilityData data = AbilityData.get((EntityLivingBase)this.getSpawnEntity(), this.getAbility().getName());
                Ability ability = Abilities.get(this.getAbility().getName());
                if (data != null && ability.getCurrentTier(data) < 3) {
                    this.spawnSteamParticles();
                    this.func_187112_i();
                } else if (this.field_70546_d % 2 == 0 && this.field_187122_b.field_73012_v.nextBoolean()) {
                    this.spawnSteamParticles();
                }
            } else {
                this.spawnSteamParticles();
                this.func_187112_i();
            }
        }
    }

    public void onMajorWaterContact() {
        if (this.getAbility() != null && this.getAbility().getElement() instanceof Firebending || this.element instanceof Firebending) {
            if (this.getSpawnEntity() instanceof EntityLivingBase && this.getAbility() != null) {
                AbilityData data = AbilityData.get((EntityLivingBase)this.getSpawnEntity(), this.getAbility().getName());
                Ability ability = Abilities.get(this.getAbility().getName());
                if (data != null && ability.getCurrentTier(data) < 6) {
                    this.spawnSteamParticles();
                    this.func_187112_i();
                } else if (this.field_70546_d % 2 == 0 && this.field_187122_b.field_73012_v.nextBoolean()) {
                    this.spawnSteamParticles();
                }
            } else {
                this.spawnSteamParticles();
                this.func_187112_i();
            }
        }
    }

    public void onMinorFireContact() {
        if (this.getAbility() != null && this.getAbility().getElement() instanceof Waterbending || this.element instanceof Waterbending) {
            this.spawnSteamParticles();
        }
    }

    public void onMajorFireContact() {
        if (this.getAbility() != null && this.getAbility().getElement() instanceof Waterbending || this.element instanceof Waterbending) {
            if (this.getSpawnEntity() instanceof EntityLivingBase && this.getAbility() != null) {
                AbilityData data = AbilityData.get((EntityLivingBase)this.getSpawnEntity(), this.getAbility().getName());
                Ability ability = Abilities.get(this.getAbility().getName());
                if (data != null && ability.getCurrentTier(data) < 3) {
                    this.spawnSteamParticles();
                    this.func_187112_i();
                } else if (this.field_70546_d % 2 == 0 && this.field_187122_b.field_73012_v.nextBoolean()) {
                    this.spawnSteamParticles();
                }
            } else {
                this.spawnSteamParticles();
                this.func_187112_i();
            }
        }
    }

    public void spawnSteamParticles() {
        ParticleBuilder.create(ParticleBuilder.Type.SNOW).scale(Math.min(Math.max(this.field_70544_f, 0.125f), 1.0f)).pos(this.field_187126_f, this.field_187127_g, this.field_187128_h).vel(this.field_187122_b.field_73012_v.nextGaussian() / 30.0 + this.field_187129_i / 8.0, this.field_187122_b.field_73012_v.nextDouble() / 15.0, this.field_187122_b.field_73012_v.nextGaussian() / 30.0 + this.field_187131_k / 8.0).time(this.field_70547_e - this.field_70546_d + 5).spawn(this.field_187122_b);
    }

    public void applyElementalContact(ParticleAvatar particle) {
        AbilityData data;
        if (particle.getAbility() != null && particle.getSpawnEntity() instanceof EntityLivingBase && (data = AbilityData.get((EntityLivingBase)particle.getSpawnEntity(), particle.getAbility().getName())) != null) {
            switch (particle.getAbility().getElement().getName()) {
                case "waterbending": {
                    if (particle.getAbility().getCurrentTier(data) < 3) {
                        this.onMinorWaterContact();
                        break;
                    }
                    this.onMajorWaterContact();
                    break;
                }
                case "firebending": {
                    if (particle.getAbility().getCurrentTier(data) < 3) {
                        this.onMinorFireContact();
                        break;
                    }
                    this.onMajorFireContact();
                    break;
                }
            }
        }
    }

    public void applyElementalContact(AvatarEntity entity) {
        if (entity.getOwner() != null && entity.getElement() != null) {
            switch (entity.getElement().getName()) {
                case "waterbending": {
                    if (entity.getTier() < 3) {
                        this.onMinorWaterContact();
                        break;
                    }
                    this.onMajorWaterContact();
                    break;
                }
                case "firebending": {
                    if (entity.getTier() < 3) {
                        this.onMinorFireContact();
                        break;
                    }
                    this.onMajorFireContact();
                    break;
                }
            }
        }
    }

    public int getLifetimeRemaining() {
        return this.field_70547_e - this.field_70546_d;
    }

    public void setBehaviour(ParticleAvatarBehaviour behaviour) {
        this.behaviour = behaviour;
    }

    public RenderLayer getCustomRenderLayer() {
        return null;
    }

    public BlockPos getPosition() {
        return new BlockPos((int)this.field_187126_f, (int)this.field_187127_g, (int)this.field_187128_h);
    }

    @SideOnly(value=Side.CLIENT)
    @FunctionalInterface
    public static interface IAvatarParticleFactory {
        public ParticleAvatar createParticle(World var1, double var2, double var4, double var6);
    }
}

