/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.particles.newparticles;

import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.bending.bending.water.Waterbending;
import com.crowsofwar.avatar.client.particles.newparticles.ParticleAvatar;
import com.crowsofwar.avatar.client.particles.newparticles.behaviour.ParticleAvatarBehaviour;
import com.crowsofwar.avatar.client.particles.newparticles.renderlayers.RenderLayer;
import com.crowsofwar.avatar.client.particles.newparticles.renderlayers.RenderLayerWaterCube;
import com.crowsofwar.avatar.joml.Matrix4f;
import com.crowsofwar.avatar.joml.Vector4f;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ParticleCube
extends ParticleAvatar {
    private static final ResourceLocation WATER = new ResourceLocation("minecraft", "textures/blocks/water_still.png");

    public ParticleCube(World world, double x, double y, double z) {
        super(world, x, y, z, new ResourceLocation[0]);
        this.func_70538_b(1.0f, 1.0f, 1.0f);
        this.field_82339_as = 1.0f;
        this.field_70547_e = 12 + this.field_187136_p.nextInt(4);
        this.field_190017_n = true;
    }

    public static void drawQuad(int normal, Vector4f pos1, Vector4f pos2, Vector4f pos3, Vector4f pos4, double u1, double v1, double u2, double v2, float r, float g, float b, float a, BendingStyle element) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        if (element instanceof Waterbending) {
            if (normal == 0 || normal == 2) {
                buffer.func_181662_b((double)pos1.x, (double)pos1.y, (double)pos1.z).func_187315_a(u2, v1).func_181666_a(r, g, b, a).func_181675_d();
                buffer.func_181662_b((double)pos2.x, (double)pos2.y, (double)pos2.z).func_187315_a(u2, v2).func_181666_a(r, g, b, a).func_181675_d();
                buffer.func_181662_b((double)pos3.x, (double)pos3.y, (double)pos3.z).func_187315_a(u1, v2).func_181666_a(r, g, b, a).func_181675_d();
                buffer.func_181662_b((double)pos4.x, (double)pos4.y, (double)pos4.z).func_187315_a(u1, v1).func_181666_a(r, g, b, a).func_181675_d();
            }
            if (normal == 1 || normal == 2) {
                buffer.func_181662_b((double)pos1.x, (double)pos1.y, (double)pos1.z).func_187315_a(u2, v1).func_181666_a(r, g, b, a).func_181675_d();
                buffer.func_181662_b((double)pos4.x, (double)pos4.y, (double)pos4.z).func_187315_a(u1, v1).func_181666_a(r, g, b, a).func_181675_d();
                buffer.func_181662_b((double)pos3.x, (double)pos3.y, (double)pos3.z).func_187315_a(u1, v2).func_181666_a(r, g, b, a).func_181675_d();
                buffer.func_181662_b((double)pos2.x, (double)pos2.y, (double)pos2.z).func_187315_a(u2, v2).func_181666_a(r, g, b, a).func_181675_d();
            }
        } else if (element instanceof Firebending || element instanceof Airbending) {
            if (normal == 0 || normal == 2) {
                buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b((double)pos1.x, (double)pos1.y, (double)pos1.z).func_181666_a(r, g, b, a).func_181675_d();
                buffer.func_181662_b((double)pos2.x, (double)pos2.y, (double)pos2.z).func_181666_a(r, g, b, a).func_181675_d();
                buffer.func_181662_b((double)pos3.x, (double)pos3.y, (double)pos3.z).func_181666_a(r, g, b, a).func_181675_d();
                buffer.func_181662_b((double)pos4.x, (double)pos4.y, (double)pos4.z).func_181666_a(r, g, b, a).func_181675_d();
                tessellator.func_78381_a();
            }
            if (normal == 1 || normal == 2) {
                buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b((double)pos1.x, (double)pos1.y, (double)pos1.z).func_181666_a(r, g, b, a).func_181675_d();
                buffer.func_181662_b((double)pos4.x, (double)pos4.y, (double)pos4.z).func_181666_a(r, g, b, a).func_181675_d();
                buffer.func_181662_b((double)pos3.x, (double)pos3.y, (double)pos3.z).func_181666_a(r, g, b, a).func_181675_d();
                buffer.func_181662_b((double)pos2.x, (double)pos2.y, (double)pos2.z).func_181666_a(r, g, b, a).func_181675_d();
                tessellator.func_78381_a();
            }
        }
    }

    public boolean func_187111_c() {
        return true;
    }

    @Override
    public void func_180434_a(BufferBuilder buffer, Entity viewer, float partialTicks, float lookZ, float lookY, float lookX, float lookXY, float lookYZ) {
        float scale;
        this.updateEntityLinking(partialTicks);
        Tessellator tes = Tessellator.func_178181_a();
        buffer = tes.func_178180_c();
        Minecraft mc = Minecraft.func_71410_x();
        float x = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float y = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float z = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        if (this.element instanceof Waterbending) {
            // empty if block
        }
        if (this.element instanceof Firebending) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }
        if (this.element instanceof Airbending) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
        float ticks = (float)this.field_70546_d + partialTicks;
        float colorEnhancement = 1.5f;
        float size = 1.0f;
        size = scale = this.field_70544_f / 10.0f;
        Matrix4f mat = new Matrix4f();
        mat = mat.translate(x, y + 0.4f, z);
        mat = mat.rotate(ticks / 20.0f * 0.2f * 40.0f, 1.0f, 0.0f, 0.0f);
        mat = mat.rotate(ticks / 20.0f * 40.0f, 0.0f, 1.0f, 0.0f);
        mat = mat.rotate(ticks / 20.0f * -0.4f * 40.0f, 0.0f, 0.0f, 1.0f);
        Vector4f lbf = new Vector4f(-0.5f * size, -0.5f * size, -0.5f * size, 1.0f).mul(mat);
        Vector4f rbf = new Vector4f(0.5f * size, -0.5f * size, -0.5f * size, 1.0f).mul(mat);
        Vector4f ltf = new Vector4f(-0.5f * size, 0.5f * size, -0.5f * size, 1.0f).mul(mat);
        Vector4f rtf = new Vector4f(0.5f * size, 0.5f * size, -0.5f * size, 1.0f).mul(mat);
        Vector4f lbb = new Vector4f(-0.5f * size, -0.5f * size, 0.5f * size, 1.0f).mul(mat);
        Vector4f rbb = new Vector4f(0.5f * size, -0.5f * size, 0.5f * size, 1.0f).mul(mat);
        Vector4f ltb = new Vector4f(-0.5f * size, 0.5f * size, 0.5f * size, 1.0f).mul(mat);
        Vector4f rtb = new Vector4f(0.5f * size, 0.5f * size, 0.5f * size, 1.0f).mul(mat);
        if (this.element instanceof Waterbending) {
            float t1 = ticks * (float)Math.PI / 10.0f;
            float t2 = t1 + 1.5707964f;
            float amt = 0.05f * scale;
            lbf.add(MathHelper.func_76134_b((float)t1) * amt, MathHelper.func_76126_a((float)t2) * amt, MathHelper.func_76134_b((float)t2) * amt, 0.0f);
            rbf.add(MathHelper.func_76126_a((float)t1) * amt, MathHelper.func_76134_b((float)t2) * amt, MathHelper.func_76126_a((float)t2) * amt, 0.0f);
            lbb.add(MathHelper.func_76126_a((float)t2) * amt, MathHelper.func_76134_b((float)t2) * amt, MathHelper.func_76134_b((float)t2) * amt, 0.0f);
            rbb.add(MathHelper.func_76134_b((float)t2) * amt, MathHelper.func_76134_b((float)t1) * amt, MathHelper.func_76134_b((float)t1) * amt, 0.0f);
            ltf.add(MathHelper.func_76134_b((float)t2) * amt, MathHelper.func_76134_b((float)t1) * amt, MathHelper.func_76126_a((float)t1) * amt, 0.0f);
            rtf.add(MathHelper.func_76126_a((float)t2) * amt, MathHelper.func_76126_a((float)t1) * amt, MathHelper.func_76134_b((float)t1) * amt, 0.0f);
            ltb.add(MathHelper.func_76126_a((float)t1) * amt, MathHelper.func_76126_a((float)t2) * amt, MathHelper.func_76134_b((float)t1) * amt, 0.0f);
            rtb.add(MathHelper.func_76134_b((float)t1) * amt, MathHelper.func_76134_b((float)t2) * amt, MathHelper.func_76126_a((float)t1) * amt, 0.0f);
        }
        float existed = ticks;
        int anim = (int)existed % 16;
        float v1 = (float)anim / 16.0f;
        float v2 = v1 + 0.0625f;
        if (AvatarMod.proxy.isOptifinePresent()) {
            // empty if block
        }
        ParticleCube.drawQuad(2, ltb, lbb, lbf, ltf, 0.0, v1, 1.0, v2, this.field_70552_h * colorEnhancement, this.field_70553_i * colorEnhancement, this.field_70551_j * colorEnhancement, this.field_82339_as * 0.5f, this.element);
        ParticleCube.drawQuad(2, rtb, rbb, rbf, rtf, 0.0, v1, 1.0, v2, this.field_70552_h * colorEnhancement, this.field_70553_i * colorEnhancement, this.field_70551_j * colorEnhancement, this.field_82339_as * 0.5f, this.element);
        ParticleCube.drawQuad(2, rbb, rbf, lbf, lbb, 0.0, v1, 1.0, v2, this.field_70552_h * colorEnhancement, this.field_70553_i * colorEnhancement, this.field_70551_j * colorEnhancement, this.field_82339_as * 0.5f, this.element);
        ParticleCube.drawQuad(2, rtb, rtf, ltf, ltb, 0.0, v1, 1.0, v2, this.field_70552_h * colorEnhancement, this.field_70553_i * colorEnhancement, this.field_70551_j * colorEnhancement, this.field_82339_as * 0.5f, this.element);
        ParticleCube.drawQuad(2, rtf, rbf, lbf, ltf, 0.0, v1, 1.0, v2, this.field_70552_h * colorEnhancement, this.field_70553_i * colorEnhancement, this.field_70551_j * colorEnhancement, this.field_82339_as * 0.5f, this.element);
        ParticleCube.drawQuad(2, rtb, rbb, lbb, ltb, 0.0, v1, 1.0, v2, this.field_70552_h * colorEnhancement, this.field_70553_i * colorEnhancement, this.field_70551_j * colorEnhancement, this.field_82339_as * 0.5f, this.element);
    }

    @Override
    public RenderLayer getCustomRenderLayer() {
        return this.element instanceof Waterbending ? RenderLayerWaterCube.INSTANCE : null;
    }

    @Override
    public int func_70537_b() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public static class WaterParticleBehaviour
    extends ParticleAvatarBehaviour {
        @Nonnull
        public ParticleAvatarBehaviour onUpdate(ParticleAvatar particle) {
            particle.setGravity(true);
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

