/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.particles.newparticles.behaviour;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.client.particles.newparticles.behaviour.ParticleAvatarBehaviour;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public abstract class ParticleBehaviour<E extends Particle> {
    private static int nextId = 1;
    private static Map<Integer, Class<? extends ParticleBehaviour>> behaviourIdToClass;
    private static Map<Class<? extends ParticleBehaviour>, Integer> classToBehaviourId;

    public static void registerBehaviours() {
        ParticleAvatarBehaviour.register();
    }

    protected static int registerBehavior(Class<? extends ParticleBehaviour> behaviorClass) {
        if (behaviourIdToClass == null) {
            behaviourIdToClass = new HashMap<Integer, Class<? extends ParticleBehaviour>>();
            classToBehaviourId = new HashMap<Class<? extends ParticleBehaviour>, Integer>();
            nextId = 1;
        }
        int id = nextId++;
        behaviourIdToClass.put(id, behaviorClass);
        classToBehaviourId.put(behaviorClass, id);
        return id;
    }

    public static ParticleBehaviour lookup(int id, Entity entity) {
        try {
            ParticleBehaviour behaviour = behaviourIdToClass.get(id).newInstance();
            return behaviour;
        }
        catch (Exception e) {
            AvatarLog.error("Error constructing particle behaviour...");
            e.printStackTrace();
            return null;
        }
    }

    public int getId() {
        return classToBehaviourId.get(this.getClass());
    }

    @Nonnull
    public abstract ParticleBehaviour onUpdate(E var1);

    public abstract void fromBytes(PacketBuffer var1);

    public abstract void toBytes(PacketBuffer var1);

    public abstract void load(NBTTagCompound var1);

    public abstract void save(NBTTagCompound var1);
}

