/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.particles.newparticles.renderlayers;

import com.crowsofwar.avatar.client.particles.newparticles.ParticleAvatar;
import com.crowsofwar.avatar.client.particles.newparticles.renderlayers.RenderLayer;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="avatarmod")
public class ParticleBatchRenderer {
    private static final Queue<ParticleAvatar> queue = Queues.newArrayDeque();
    public static Set<RenderLayer> layers = new HashSet<RenderLayer>();
    public static Map<BlockPos, ParticleGroup> collidingParticlesByPositions = new HashMap<BlockPos, ParticleGroup>();

    public static void registerRenderLayer(RenderLayer r) {
        layers.add(r);
    }

    public static void addParticle(ParticleAvatar p) {
        if (p != null) {
            queue.add(p);
        }
    }

    public static void updateParticles() {
        if (Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        collidingParticlesByPositions.clear();
        for (RenderLayer layer : layers) {
            for (ParticleAvatar p : layer.particles) {
                if (!p.canCollideParticles) continue;
                BlockPos pos = p.getPosition();
                if (collidingParticlesByPositions.containsKey(pos)) {
                    collidingParticlesByPositions.get(pos).addParticle(p);
                    continue;
                }
                ParticleGroup group = new ParticleGroup();
                group.addParticle(p);
                collidingParticlesByPositions.put(pos, group);
            }
        }
        for (RenderLayer layer : layers) {
            Iterator<ParticleAvatar> itr = layer.particles.iterator();
            while (itr.hasNext()) {
                ParticleAvatar p;
                p = itr.next();
                p.func_189213_a();
                if (p.func_187113_k()) continue;
                itr.remove();
            }
        }
        if (!queue.isEmpty()) {
            ParticleAvatar particle = queue.poll();
            while (particle != null) {
                RenderLayer layer;
                layer = particle.getCustomRenderLayer();
                if (layer == null) {
                    throw new RuntimeException("Particle " + (Object)((Object)particle) + " does not use a custom render layer!");
                }
                layers.add(layer);
                if (layer.particles.size() > 8192) {
                    layer.particles.removeFirst();
                }
                layer.particles.add(particle);
                particle = queue.poll();
            }
        }
    }

    public static void renderParticles(Entity entityIn, float partialTicks) {
        float f = ActiveRenderInfo.func_178808_b();
        float f1 = ActiveRenderInfo.func_178803_d();
        float f2 = ActiveRenderInfo.func_178805_e();
        float f3 = ActiveRenderInfo.func_178807_f();
        float f4 = ActiveRenderInfo.func_178809_c();
        Particle.field_70556_an = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        Particle.field_70554_ao = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        Particle.field_70555_ap = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        Particle.field_190016_K = entityIn.func_70676_i(partialTicks);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (RenderLayer layer : layers) {
            layer.preRenderParticles();
            layer.particles.forEach(particle -> particle.func_180434_a(Tessellator.func_178181_a().func_178180_c(), entityIn, partialTicks, f, f4, f1, f2, f3));
            layer.postRenderParticles();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    public static List<List<ParticleAvatar>> getCollidingParticlesWithinBBExcluding(Entity e, AxisAlignedBB bb) {
        bb = bb.func_186662_g(0.25);
        int x1 = MathHelper.func_76128_c((double)bb.field_72340_a);
        int x2 = MathHelper.func_76143_f((double)bb.field_72336_d);
        int y1 = MathHelper.func_76128_c((double)bb.field_72338_b);
        int y2 = MathHelper.func_76143_f((double)bb.field_72337_e);
        int z1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int z2 = MathHelper.func_76143_f((double)bb.field_72334_f);
        ArrayList<List<ParticleAvatar>> list = new ArrayList<List<ParticleAvatar>>();
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    ParticleGroup group = collidingParticlesByPositions.get(new BlockPos(x, y, z));
                    if (group == null) continue;
                    group.getParticlesExcludingEntity(e, list);
                }
            }
        }
        return list;
    }

    @SubscribeEvent
    public static void renderLast(RenderWorldLastEvent event) {
        ParticleBatchRenderer.renderParticles(Minecraft.func_71410_x().func_175606_aa(), event.getPartialTicks());
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ParticleBatchRenderer.updateParticles();
        }
    }

    private static class ParticleGroup {
        List<Pair<Entity, List<ParticleAvatar>>> containedParticles = new ArrayList<Pair<Entity, List<ParticleAvatar>>>();

        private ParticleGroup() {
        }

        public void addParticle(ParticleAvatar p) {
            for (Pair<Entity, List<ParticleAvatar>> pair : this.containedParticles) {
                if (pair.getKey() != p.getEntity()) continue;
                ((List)pair.getValue()).add(p);
                return;
            }
            ArrayList<ParticleAvatar> list = new ArrayList<ParticleAvatar>();
            list.add(p);
            this.containedParticles.add((Pair<Entity, List<ParticleAvatar>>)Pair.of((Object)p.getEntity(), list));
        }

        public void getParticlesExcludingEntity(Entity e, List<List<ParticleAvatar>> list) {
            for (Pair<Entity, List<ParticleAvatar>> pair : this.containedParticles) {
                if (e != null && (!(e instanceof EntityLivingBase) || pair.getKey() == e) && (!(e instanceof AvatarEntity) || ((AvatarEntity)e).getOwner() == pair.getKey())) continue;
                list.add((List<ParticleAvatar>)pair.getValue());
            }
        }
    }
}

