/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.particles.oldsystem;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class AvatarParticle
extends Particle {
    private static final ResourceLocation VANILLA_PARTICLES = new ResourceLocation("textures/particle/particles.png");
    private static final ResourceLocation AVATAR_PARTICLES = new ResourceLocation("avatarmod", "textures/particles/flame.png");
    private boolean additiveBlending = false;

    public AvatarParticle(World world, double x, double y, double z, double velX, double velY, double velZ) {
        super(world, x, y, z, velX, velY, velZ);
    }

    public void func_180434_a(BufferBuilder vb, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        ParticleFrame frame = this.getTextureFrames()[this.getCurrentFrame()];
        Tessellator t = Tessellator.func_178181_a();
        Minecraft mc = Minecraft.func_71410_x();
        t.func_78381_a();
        mc.func_110434_K().func_110577_a(frame.texture);
        vb.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        if (this.additiveBlending) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }
        float minU = (float)frame.minU / (float)frame.textureSize;
        float maxU = (float)frame.maxU / (float)frame.textureSize;
        float minV = (float)frame.minV / (float)frame.textureSize;
        float maxV = (float)frame.maxV / (float)frame.textureSize;
        float f4 = 0.1f * this.field_70544_f;
        float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int i = this.func_189214_a(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        Vec3d[] avec3d = new Vec3d[]{new Vec3d((double)(-rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(-rotationYZ * f4 - rotationXZ * f4)), new Vec3d((double)(-rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(-rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(rotationYZ * f4 - rotationXZ * f4))};
        if (this.field_190014_F != 0.0f) {
            float f8 = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
            float f9 = MathHelper.func_76134_b((float)(f8 * 0.5f));
            float f10 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)AvatarParticle.field_190016_K.field_72450_a;
            float f11 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)AvatarParticle.field_190016_K.field_72448_b;
            float f12 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)AvatarParticle.field_190016_K.field_72449_c;
            Vec3d vec3d = new Vec3d((double)f10, (double)f11, (double)f12);
            for (int l = 0; l < 4; ++l) {
                avec3d[l] = vec3d.func_186678_a(2.0 * avec3d[l].func_72430_b(vec3d)).func_178787_e(avec3d[l].func_186678_a((double)(f9 * f9) - vec3d.func_72430_b(vec3d))).func_178787_e(vec3d.func_72431_c(avec3d[l]).func_186678_a((double)(2.0f * f9)));
            }
        }
        vb.func_181662_b((double)f5 + avec3d[0].field_72450_a, (double)f6 + avec3d[0].field_72448_b, (double)f7 + avec3d[0].field_72449_c).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        vb.func_181662_b((double)f5 + avec3d[1].field_72450_a, (double)f6 + avec3d[1].field_72448_b, (double)f7 + avec3d[1].field_72449_c).func_187315_a((double)maxU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        vb.func_181662_b((double)f5 + avec3d[2].field_72450_a, (double)f6 + avec3d[2].field_72448_b, (double)f7 + avec3d[2].field_72449_c).func_187315_a((double)minU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        vb.func_181662_b((double)f5 + avec3d[3].field_72450_a, (double)f6 + avec3d[3].field_72448_b, (double)f7 + avec3d[3].field_72449_c).func_187315_a((double)minU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        t.func_78381_a();
        if (this.additiveBlending) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
        mc.func_110434_K().func_110577_a(VANILLA_PARTICLES);
        vb.func_181668_a(7, DefaultVertexFormats.field_181704_d);
    }

    protected void enableAdditiveBlending() {
        this.additiveBlending = true;
    }

    protected abstract ParticleFrame[] getTextureFrames();

    protected int getCurrentFrame() {
        int frame = (int)((double)(this.field_70546_d * this.getTextureFrames().length) / (double)this.field_70547_e);
        if (frame == this.getTextureFrames().length) {
            frame = this.getTextureFrames().length - 1;
        }
        return frame;
    }

    public static class ParticleFrame {
        private final ResourceLocation texture;
        private final int minU;
        private final int maxU;
        private final int minV;
        private final int maxV;
        private final int textureSize;

        public ParticleFrame(ResourceLocation texture, int textureSize, int minU, int minV, int width, int height) {
            this.texture = texture;
            this.textureSize = textureSize;
            this.minU = minU;
            this.maxU = minU + width;
            this.minV = minV;
            this.maxV = minV + height;
        }

        public ParticleFrame(int minU, int minV, int width, int height) {
            this(AVATAR_PARTICLES, 256, minU, minV, width, height);
        }
    }
}

