/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.render;

import com.crowsofwar.avatar.entity.ControlPoint;
import com.crowsofwar.avatar.entity.EntityArc;
import com.crowsofwar.avatar.joml.Matrix4d;
import com.crowsofwar.avatar.joml.Vector4d;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public abstract class RenderArc
extends Render {
    private final RenderManager renderManager;
    private boolean renderBright;
    private boolean enableInterpolation;

    protected RenderArc(RenderManager renderManager) {
        this(renderManager, true);
    }

    protected RenderArc(RenderManager renderManager, boolean enableInterpolation) {
        super(renderManager);
        this.renderManager = renderManager;
        this.enableInterpolation = enableInterpolation;
    }

    public void func_76986_a(Entity entity, double xx, double yy, double zz, float p_76986_8_, float partialTicks) {
        EntityArc arc = (EntityArc)entity;
        this.renderArc(arc, partialTicks, 1.0f, 1.0f);
    }

    protected void renderArc(EntityArc<?> arc, float partialTicks, float alpha, float scale) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        for (int i = arc.getControlPoints().size() - 1; i > 0; --i) {
            this.renderSegment(arc, (ControlPoint)arc.getLeader(i), (ControlPoint)arc.getControlPoint(i), partialTicks, scale);
        }
    }

    private void renderSegment(EntityArc arc, ControlPoint leader, ControlPoint point, float partialTicks, float scale) {
        Vector leaderPos = leader.position();
        Vector pointPos = point.position();
        if (this.enableInterpolation) {
            leaderPos = leader.getInterpolatedPosition(partialTicks);
            pointPos = point.getInterpolatedPosition(partialTicks);
        }
        double x = leaderPos.x() - TileEntityRendererDispatcher.field_147554_b;
        double y = leaderPos.y() - TileEntityRendererDispatcher.field_147555_c;
        double z = leaderPos.z() - TileEntityRendererDispatcher.field_147552_d;
        Vector from = new Vector();
        Vector to = pointPos.minus(leaderPos);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getTexture());
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (this.renderBright) {
            GlStateManager.func_179140_f();
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        double sizeLeader = point.size() / 2.0f * scale;
        double sizePoint = leader.size() / 2.0f * scale;
        Vector lookingEuler = Vector.getRotationTo(from, to);
        double u1 = (double)((float)arc.field_70173_aa + partialTicks) / 20.0 % 1.0;
        double u2 = u1 + 0.5;
        Matrix4d mat = new Matrix4d();
        mat.rotate((float)(-lookingEuler.y()), 0.0, 1.0, 0.0);
        mat.rotate((float)lookingEuler.x(), 1.0, 0.0, 0.0);
        double dist = leader.getDistance(point);
        Vector4d t_v1 = new Vector4d(-sizeLeader, sizeLeader, dist, 1.0).mul(mat);
        Vector4d t_v2 = new Vector4d(sizeLeader, sizeLeader, dist, 1.0).mul(mat);
        Vector4d t_v3 = new Vector4d(sizePoint, sizePoint, 0.0, 1.0).mul(mat);
        Vector4d t_v4 = new Vector4d(-sizePoint, sizePoint, 0.0, 1.0).mul(mat);
        Vector4d b_v1 = new Vector4d(-sizeLeader, -sizeLeader, dist, 1.0).mul(mat);
        Vector4d b_v2 = new Vector4d(sizeLeader, -sizeLeader, dist, 1.0).mul(mat);
        Vector4d b_v3 = new Vector4d(sizePoint, -sizePoint, 0.0, 1.0).mul(mat);
        Vector4d b_v4 = new Vector4d(-sizePoint, -sizePoint, 0.0, 1.0).mul(mat);
        this.drawQuad(2, t_v1, t_v2, t_v3, t_v4, u1, 0.0, u2, 1.0);
        this.drawQuad(2, b_v1, b_v2, b_v3, b_v4, u1, 0.0, u2, 1.0);
        this.drawQuad(2, t_v2, b_v2, b_v3, t_v3, u1, 0.0, u2, 1.0);
        this.drawQuad(2, t_v1, b_v1, b_v4, t_v4, u1, 0.0, u2, 1.0);
        this.onDrawSegment(arc, leader, point);
        GlStateManager.func_179084_k();
        if (this.renderBright) {
            GlStateManager.func_179145_e();
        }
        GlStateManager.func_179121_F();
    }

    protected final ResourceLocation func_110775_a(Entity p_110775_1_) {
        return null;
    }

    private void drawQuad(int normal, Vector pos1, Vector pos2, Vector pos3, Vector pos4, double u1, double v1, double u2, double v2) {
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder vb = t.func_178180_c();
        t.func_178180_c();
        if (normal == 0 || normal == 2) {
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b(pos1.x(), pos1.y(), pos1.z()).func_187315_a(u2, v1).func_181675_d();
            vb.func_181662_b(pos2.x(), pos2.y(), pos2.z()).func_187315_a(u2, v2).func_181675_d();
            vb.func_181662_b(pos3.x(), pos3.y(), pos3.z()).func_187315_a(u1, v2).func_181675_d();
            vb.func_181662_b(pos4.x(), pos4.y(), pos4.z()).func_187315_a(u1, v1).func_181675_d();
            t.func_78381_a();
        }
        if (normal == 1 || normal == 2) {
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b(pos1.x(), pos1.y(), pos1.z()).func_187315_a(u2, v1).func_181675_d();
            vb.func_181662_b(pos4.x(), pos4.y(), pos4.z()).func_187315_a(u1, v1).func_181675_d();
            vb.func_181662_b(pos3.x(), pos3.y(), pos3.z()).func_187315_a(u1, v2).func_181675_d();
            vb.func_181662_b(pos2.x(), pos2.y(), pos2.z()).func_187315_a(u2, v2).func_181675_d();
            t.func_78381_a();
        }
    }

    private void drawQuad(int normal, Vector4d pos1, Vector4d pos2, Vector4d pos3, Vector4d pos4, double u1, double v1, double u2, double v2) {
        this.drawQuad(normal, new Vector(pos1.x, pos1.y, pos1.z), new Vector(pos2.x, pos2.y, pos2.z), new Vector(pos3.x, pos3.y, pos3.z), new Vector(pos4.x, pos4.y, pos4.z), u1, v1, u2, v2);
    }

    protected abstract ResourceLocation getTexture();

    protected void onDrawSegment(EntityArc arc, ControlPoint first, ControlPoint second) {
    }

    protected void enableFullBrightness() {
        this.renderBright = true;
    }
}

