/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.render;

import com.crowsofwar.avatar.config.ConfigClient;
import com.crowsofwar.avatar.entity.EntityCloudBall;
import com.crowsofwar.avatar.joml.Matrix4f;
import com.crowsofwar.avatar.joml.Vector4f;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderCloudburst
extends Render<EntityCloudBall> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("avatarmod", "textures/entity/cloudburst.png");
    private static final Random random = new Random();

    public RenderCloudburst(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityCloudBall entity, double xx, double yy, double zz, float entityYaw, float partialTicks) {
        float x = (float)xx;
        float y = (float)yy;
        float z = (float)zz;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE);
        float ticks = (float)entity.field_70173_aa + partialTicks;
        float rotation = ticks / 3.0f;
        float size = 0.8f + MathHelper.func_76134_b((float)(ticks / 5.0f)) * 0.05f;
        size = (float)((double)size * Math.sqrt((float)entity.getSize() / 30.0f));
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179131_c((float)0.875f, (float)0.875f, (float)0.875f, (float)0.5f);
        this.renderCube(x, y, z, 0.0, 0.03125, 0.0, 0.03125, size * 0.5f, ticks / 15.0f, ticks / 15.0f, ticks / 15.0f);
        int i = 0xF000F0;
        int j = i % 65536;
        int k = i / 65536;
        ConfigClient.CLIENT_CONFIG.shaderSettings.getClass();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        int light = Math.min(entity.field_70170_p.func_175657_ab(), 7);
        GlStateManager.func_179122_b((int)light);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        ConfigClient.CLIENT_CONFIG.shaderSettings.getClass();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
        GlStateManager.func_179094_E();
        this.renderCube(x, y, z, 0.03125, 0.0625, 0.0, 0.03125, size, rotation * 0.2f, rotation, rotation * -0.4f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
    }

    private void renderCube(float x, float y, float z, double u1, double u2, double v1, double v2, float size, float rotateX, float rotateY, float rotateZ) {
        Matrix4f mat = new Matrix4f();
        mat.translate(x, y + 0.4f, z);
        mat.rotate(rotateX, 1.0f, 0.0f, 0.0f);
        mat.rotate(rotateY, 0.0f, 1.0f, 0.0f);
        mat.rotate(rotateZ, 0.0f, 0.0f, 1.0f);
        Vector4f lbf = new Vector4f(-0.5f * size, -0.5f * size, -0.5f * size, 1.0f).mul(mat);
        Vector4f rbf = new Vector4f(0.5f * size, -0.5f * size, -0.5f * size, 1.0f).mul(mat);
        Vector4f ltf = new Vector4f(-0.5f * size, 0.5f * size, -0.5f * size, 1.0f).mul(mat);
        Vector4f rtf = new Vector4f(0.5f * size, 0.5f * size, -0.5f * size, 1.0f).mul(mat);
        Vector4f lbb = new Vector4f(-0.5f * size, -0.5f * size, 0.5f * size, 1.0f).mul(mat);
        Vector4f rbb = new Vector4f(0.5f * size, -0.5f * size, 0.5f * size, 1.0f).mul(mat);
        Vector4f ltb = new Vector4f(-0.5f * size, 0.5f * size, 0.5f * size, 1.0f).mul(mat);
        Vector4f rtb = new Vector4f(0.5f * size, 0.5f * size, 0.5f * size, 1.0f).mul(mat);
        this.drawQuad(2, ltb, lbb, lbf, ltf, u1, v1, u2, v2);
        this.drawQuad(2, rtb, rbb, rbf, rtf, u1, v1, u2, v2);
        this.drawQuad(2, rbb, rbf, lbf, lbb, u1, v1, u2, v2);
        this.drawQuad(2, rtb, rtf, ltf, ltb, u1, v1, u2, v2);
        this.drawQuad(2, rtf, rbf, lbf, ltf, u1, v1, u2, v2);
        this.drawQuad(2, rtb, rbb, lbb, ltb, u1, v1, u2, v2);
    }

    private void drawQuad(int normal, Vector4f pos1, Vector4f pos2, Vector4f pos3, Vector4f pos4, double u1, double v1, double u2, double v2) {
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder vb = t.func_178180_c();
        if (normal == 0 || normal == 2) {
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b((double)pos1.x, (double)pos1.y, (double)pos1.z).func_187315_a(u2, v1).func_181675_d();
            vb.func_181662_b((double)pos2.x, (double)pos2.y, (double)pos2.z).func_187315_a(u2, v2).func_181675_d();
            vb.func_181662_b((double)pos3.x, (double)pos3.y, (double)pos3.z).func_187315_a(u1, v2).func_181675_d();
            vb.func_181662_b((double)pos4.x, (double)pos4.y, (double)pos4.z).func_187315_a(u1, v1).func_181675_d();
            t.func_78381_a();
        }
        if (normal == 1 || normal == 2) {
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b((double)pos1.x, (double)pos1.y, (double)pos1.z).func_187315_a(u2, v1).func_181675_d();
            vb.func_181662_b((double)pos4.x, (double)pos4.y, (double)pos4.z).func_187315_a(u1, v1).func_181675_d();
            vb.func_181662_b((double)pos3.x, (double)pos3.y, (double)pos3.z).func_187315_a(u1, v2).func_181675_d();
            vb.func_181662_b((double)pos2.x, (double)pos2.y, (double)pos2.z).func_187315_a(u2, v2).func_181675_d();
            t.func_78381_a();
        }
    }

    protected ResourceLocation getEntityTexture(EntityCloudBall entity) {
        return TEXTURE;
    }
}

