/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.render;

import com.crowsofwar.avatar.client.render.RenderUtils;
import com.crowsofwar.avatar.entity.EntityFireball;
import com.crowsofwar.avatar.joml.Matrix4f;
import com.crowsofwar.avatar.joml.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderFireball
extends Render<EntityFireball> {
    private static ResourceLocation TEXTURE = new ResourceLocation("avatarmod", "textures/entity/fireball_together.png");

    public RenderFireball(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityFireball entity, double x, double y, double z, float entityYaw, float partialTicks) {
        float ticks = (float)entity.field_70173_aa + partialTicks;
        float rotation = ticks / 3.0f;
        float size = 0.8f + MathHelper.func_76134_b((float)(ticks / 5.0f)) * 0.05f;
        size *= (float)entity.getSize() / 10.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)2.0f, (float)2.0f, (float)2.0f, (float)1.0f);
        this.renderCube((float)x, (float)y, (float)z, 0.0, 0.5, 0.0, 1.0, 0.5f * size, ticks / 15.0f, ticks / 15.0f, ticks / 15.0f);
        int i = 0xF000F0;
        int j = i % 65536;
        int k = i / 65536;
        GlStateManager.func_179131_c((float)0.75f, (float)0.75f, (float)0.75f, (float)0.75f);
        this.renderCube((float)x, (float)y, (float)z, 0.5, 1.0, 0.0, 1.0, size, rotation * 0.2f, rotation, rotation * -0.4f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private void renderCube(float x, float y, float z, double u1, double u2, double v1, double v2, float size, float rotateX, float rotateY, float rotateZ) {
        Matrix4f mat = new Matrix4f();
        mat.translate(x, y + 0.4f, z);
        mat.rotate(rotateX, 1.0f, 0.0f, 0.0f);
        mat.rotate(rotateY, 0.0f, 1.0f, 0.0f);
        mat.rotate(rotateZ, 0.0f, 0.0f, 1.0f);
        Vector4f lbf = new Vector4f(-0.5f * size, -0.5f * size, -0.5f * size, 1.0f).mul(mat);
        Vector4f rbf = new Vector4f(0.5f * size, -0.5f * size, -0.5f * size, 1.0f).mul(mat);
        Vector4f ltf = new Vector4f(-0.5f * size, 0.5f * size, -0.5f * size, 1.0f).mul(mat);
        Vector4f rtf = new Vector4f(0.5f * size, 0.5f * size, -0.5f * size, 1.0f).mul(mat);
        Vector4f lbb = new Vector4f(-0.5f * size, -0.5f * size, 0.5f * size, 1.0f).mul(mat);
        Vector4f rbb = new Vector4f(0.5f * size, -0.5f * size, 0.5f * size, 1.0f).mul(mat);
        Vector4f ltb = new Vector4f(-0.5f * size, 0.5f * size, 0.5f * size, 1.0f).mul(mat);
        Vector4f rtb = new Vector4f(0.5f * size, 0.5f * size, 0.5f * size, 1.0f).mul(mat);
        RenderUtils.drawQuad(2, ltb, lbb, lbf, ltf, u1, v1, u2, v2);
        RenderUtils.drawQuad(2, rtb, rbb, rbf, rtf, u1, v1, u2, v2);
        RenderUtils.drawQuad(2, rbb, rbf, lbf, lbb, u1, v1, u2, v2);
        RenderUtils.drawQuad(2, rtb, rtf, ltf, ltb, u1, v1, u2, v2);
        RenderUtils.drawQuad(2, rtf, rbf, lbf, ltf, u1, v1, u2, v2);
        RenderUtils.drawQuad(2, rtb, rbb, lbb, ltb, u1, v1, u2, v2);
    }

    protected ResourceLocation getEntityTexture(EntityFireball entity) {
        return TEXTURE;
    }
}

