/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.render;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import com.crowsofwar.avatar.bending.bending.fire.AbilityFlameStrike;
import com.crowsofwar.avatar.client.render.RenderUtils;
import com.crowsofwar.avatar.entity.EntityLightOrb;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class RenderLightOrb
extends Render<EntityLightOrb> {
    private static ResourceLocation fill_default = new ResourceLocation("avatarmod", "textures/entity/sphere.png");
    private static ResourceLocation halo = new ResourceLocation("avatarmod", "textures/entity/spherehalo.png");
    private ResourceLocation fill;

    public RenderLightOrb(RenderManager manager) {
        super(manager);
    }

    public void doRender(EntityLightOrb entity, double x, double y, double z, float entityYaw, float partialTicks) {
        double angleX;
        if (entity.getType() == EntityLightOrb.EnumType.NOTHING) {
            return;
        }
        this.fill = entity.shouldUseCustomTexture() ? new ResourceLocation(entity.getTrueTexture()) : fill_default;
        boolean shouldCclRender = entity.isSphere();
        Minecraft minecraft = Minecraft.func_71410_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        if (shouldCclRender) {
            TextureUtils.changeTexture((ResourceLocation)halo);
        } else {
            this.func_110776_a(halo);
        }
        if (entity.shouldUseCustomTexture()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)entity.getColorA());
        } else {
            GlStateManager.func_179131_c((float)entity.getColorR(), (float)entity.getColorG(), (float)entity.getColorB(), (float)entity.getColorA());
        }
        double scale = entity.getOrbSize();
        double haloCoord = 0.58 * scale;
        double dx = entity.field_70165_t - this.field_76990_c.field_78730_l;
        double dy = entity.field_70163_u - this.field_76990_c.field_78731_m;
        double dz = entity.field_70161_v - this.field_76990_c.field_78728_n;
        float ticks = (float)entity.field_70173_aa + partialTicks;
        float rotation = ticks * 20.0f;
        double lenghtXZ = Math.sqrt(dx * dx + dz * dz);
        double lenght = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double angleY = entity.isColorSphere() ? Math.atan2(lenghtXZ, dy) * 57.29577951308232 : (double)entity.field_70177_z;
        double d = angleX = entity.isColorSphere() ? Math.atan2(dx, dz) * 57.29577951308232 : (double)entity.field_70125_A;
        if (lenght > 16.0 || !entity.isColorSphere()) {
            haloCoord = 0.0;
        }
        GlStateManager.func_179140_f();
        minecraft.field_71460_t.func_175072_h();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y - 0.1), (double)z);
        GlStateManager.func_179114_b((float)((float)angleX), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(angleY + 90.0)), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179132_a((boolean)false);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(-haloCoord, 0.0, -haloCoord).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(-haloCoord, 0.0, haloCoord).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(haloCoord, 0.0, haloCoord).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(haloCoord, 0.0, -haloCoord).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
        if (shouldCclRender) {
            TextureUtils.changeTexture((ResourceLocation)this.fill);
        } else {
            this.func_110776_a(this.fill);
        }
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        if (entity.isSpinning() && entity.isSphere()) {
            GlStateManager.func_179114_b((float)(rotation * 0.2f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(rotation * 0.2f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.func_179129_p();
        if (entity.getType() == EntityLightOrb.EnumType.COLOR_CUBE || entity.getType() == EntityLightOrb.EnumType.TEXTURE_CUBE) {
            if (entity.isSpinning()) {
                if (entity.getAbility() instanceof AbilityFlameStrike) {
                    RenderUtils.renderCube(0.0f, 0.0f, 0.0f, 0.0, 1.0, 0.0, 1.0, 1.0f, rotation * entity.getOrbSize() / 80.0f, rotation * entity.getOrbSize() / 40.0f, rotation * entity.getOrbSize() / 80.0f);
                } else {
                    RenderUtils.renderCube(0.0f, 0.0f, 0.0f, 0.0, 1.0, 0.0, 1.0, 1.0f, rotation * 0.1f, rotation * 0.5f, rotation * 0.1f);
                }
            } else {
                RenderUtils.renderCube(0.0f, 0.0f, 0.0f, 0.0, 1.0, 0.0, 1.0, 1.0f, 0.0f, 0.0f, 0.0f);
            }
        } else {
            CCRenderState ccrenderstate = CCRenderState.instance();
            CCModel model = (CCModel)OBJParser.parseModels((ResourceLocation)new ResourceLocation("avatarmod", "models/hemisphere.obj")).get("model");
            if (!entity.shouldUseCustomTexture()) {
                GlStateManager.func_179131_c((float)entity.getColorR(), (float)entity.getColorG(), (float)entity.getColorB(), (float)entity.getColorA());
            }
            ccrenderstate.startDrawing(4, DefaultVertexFormats.field_181710_j);
            model.render(ccrenderstate, new IVertexOperation[0]);
            ccrenderstate.draw();
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)1.0f, (float)0.0f);
            if (!entity.shouldUseCustomTexture()) {
                GlStateManager.func_179131_c((float)entity.getColorR(), (float)entity.getColorG(), (float)entity.getColorB(), (float)entity.getColorA());
            }
            ccrenderstate.startDrawing(4, DefaultVertexFormats.field_181710_j);
            model.render(ccrenderstate, new IVertexOperation[0]);
            ccrenderstate.draw();
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        minecraft.field_71460_t.func_180436_i();
        GlStateManager.func_179145_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected ResourceLocation getEntityTexture(EntityLightOrb entity) {
        return this.fill;
    }
}

