/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.render;

import com.crowsofwar.avatar.client.render.ostrich.ModelOstrichHorseChain;
import com.crowsofwar.avatar.client.render.ostrich.ModelOstrichHorsePlate;
import com.crowsofwar.avatar.client.render.ostrich.ModelOstrichHorseWild;
import com.crowsofwar.avatar.client.render.ostrich.ModelOstrichHorseWoven;
import com.crowsofwar.avatar.entity.mob.EntityOstrichHorse;
import com.crowsofwar.avatar.item.ItemOstrichEquipment;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;

public class RenderOstrichHorse
extends RenderLiving<EntityOstrichHorse> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("avatarmod", "textures/mob/ostrich.png");
    private final ModelBase[] models = new ModelBase[]{new ModelOstrichHorseWild(), new ModelOstrichHorseWoven(), new ModelOstrichHorseChain(), new ModelOstrichHorsePlate()};
    private final ResourceLocation[] textures = new ResourceLocation[this.models.length];

    public RenderOstrichHorse(RenderManager rendermanagerIn) {
        super(rendermanagerIn, (ModelBase)new ModelOstrichHorseWild(), 0.5f);
        for (int i = 0; i < this.textures.length; ++i) {
            String tier = ItemOstrichEquipment.EquipmentTier.getTierName(i - 1);
            if (tier == null) {
                tier = "wild";
            }
            this.textures[i] = new ResourceLocation("avatarmod", "textures/mob/ostrich_" + tier + ".png");
        }
    }

    private int getAssetIndex(EntityOstrichHorse entity) {
        ItemOstrichEquipment.EquipmentTier equipmentTier = entity.getEquipment();
        return equipmentTier == null ? 0 : equipmentTier.ordinal() + 1;
    }

    public void doRender(EntityOstrichHorse entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.field_77045_g = this.models[this.getAssetIndex(entity)];
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EntityOstrichHorse entity) {
        return this.textures[this.getAssetIndex(entity)];
    }
}

