/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.shader;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.client.shader.Shader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class ShaderManager {
    public static final FloatBuffer AUX_GL_BUFFER = GLAllocation.func_74529_h((int)16);
    public static final Shader.Uniform MODELVIEW_PROJECTION_MATRIX = shader -> {
        GL11.glGetFloat((int)2982, (FloatBuffer)AUX_GL_BUFFER);
        AUX_GL_BUFFER.rewind();
        Matrix4f mvMatrix = new Matrix4f();
        mvMatrix.load(AUX_GL_BUFFER);
        AUX_GL_BUFFER.rewind();
        GL11.glGetFloat((int)2983, (FloatBuffer)AUX_GL_BUFFER);
        AUX_GL_BUFFER.rewind();
        Matrix4f pMatrix = new Matrix4f();
        pMatrix.load(AUX_GL_BUFFER);
        AUX_GL_BUFFER.rewind();
        Matrix4f.mul((org.lwjgl.util.vector.Matrix4f)pMatrix, (org.lwjgl.util.vector.Matrix4f)mvMatrix, (org.lwjgl.util.vector.Matrix4f)mvMatrix).store(AUX_GL_BUFFER);
        AUX_GL_BUFFER.rewind();
        GL20.glUniformMatrix4((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"modelViewProjectionMatrix"), (boolean)false, (FloatBuffer)AUX_GL_BUFFER);
    };

    public static int loadShader(ResourceLocation file) {
        int vertexShader = 0;
        int fragmentShader = 0;
        try {
            int program = GL20.glCreateProgram();
            vertexShader = GL20.glCreateShader((int)35633);
            GL20.glShaderSource((int)vertexShader, (ByteBuffer)ShaderManager.readFileToBuf(new ResourceLocation(file.func_110624_b(), file.func_110623_a() + ".vert")));
            GL20.glCompileShader((int)vertexShader);
            if (GL20.glGetShaderi((int)vertexShader, (int)35713) == 0) {
                AvatarLog.error(GL20.glGetShaderInfoLog((int)vertexShader, (int)35716));
                throw new RuntimeException("Error creating vertex shader: " + file);
            }
            fragmentShader = GL20.glCreateShader((int)35632);
            GL20.glShaderSource((int)fragmentShader, (ByteBuffer)ShaderManager.readFileToBuf(new ResourceLocation(file.func_110624_b(), file.func_110623_a() + ".frag")));
            GL20.glCompileShader((int)fragmentShader);
            if (GL20.glGetShaderi((int)fragmentShader, (int)35713) == 0) {
                AvatarLog.error(GL20.glGetShaderInfoLog((int)fragmentShader, (int)35716));
                throw new RuntimeException("Error creating fragment shader: " + file);
            }
            GL20.glAttachShader((int)program, (int)vertexShader);
            GL20.glAttachShader((int)program, (int)fragmentShader);
            GL20.glLinkProgram((int)program);
            if (GL20.glGetProgrami((int)program, (int)35714) == 0) {
                AvatarLog.error(GL20.glGetProgramInfoLog((int)program, (int)35716));
                throw new RuntimeException("Error creating fragment shader: " + file);
            }
            GL20.glDeleteShader((int)vertexShader);
            GL20.glDeleteShader((int)fragmentShader);
            return program;
        }
        catch (Exception x) {
            GL20.glDeleteShader((int)vertexShader);
            GL20.glDeleteShader((int)fragmentShader);
            x.printStackTrace();
            return 0;
        }
    }

    private static ByteBuffer readFileToBuf(ResourceLocation file) throws IOException {
        InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(file).func_110527_b();
        byte[] bytes = IOUtils.toByteArray((InputStream)in);
        IOUtils.closeQuietly((InputStream)in);
        ByteBuffer buf = BufferUtils.createByteBuffer((int)bytes.length);
        buf.put(bytes);
        buf.rewind();
        return buf;
    }
}

