/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.uitools;

import com.crowsofwar.avatar.client.uitools.Frame;
import com.crowsofwar.avatar.client.uitools.ScreenInfo;

public class Measurement {
    private final Frame frame;
    private final float x;
    private final float y;

    private Measurement(Frame frame, float x, float y) {
        this.frame = frame;
        this.x = x;
        this.y = y;
    }

    public static Measurement fromPixels(float x, float y) {
        return Measurement.fromPixels(Frame.SCREEN, x, y);
    }

    public static Measurement fromPixels(Frame frame, float x, float y) {
        return new Measurement(frame, x, y);
    }

    public static Measurement fromPercent(float pctX, float pctY) {
        return Measurement.fromPercent(Frame.SCREEN, pctX, pctY);
    }

    public static Measurement fromPercent(Frame frame, float pctX, float pctY) {
        Measurement dim = frame.getDimensions();
        return new Measurement(frame, dim.x * pctX / 100.0f, dim.y * pctY / 100.0f);
    }

    public float xInPixels() {
        return this.x;
    }

    public float yInPixels() {
        return this.y;
    }

    public float xInPercent() {
        return this.x / (float)ScreenInfo.screenWidth() * 100.0f;
    }

    public float yInPercent() {
        return this.y / (float)ScreenInfo.screenHeight() * 100.0f;
    }

    public Measurement times(float scl) {
        return new Measurement(this.frame, this.x * scl, this.y * scl);
    }

    public Measurement plus(Measurement m) {
        return new Measurement(this.frame, this.x + m.x, this.y + m.y);
    }
}

