/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.uitools;

import com.crowsofwar.avatar.client.uitools.Frame;
import com.crowsofwar.avatar.client.uitools.Measurement;
import com.crowsofwar.avatar.client.uitools.ScreenInfo;
import com.crowsofwar.avatar.client.uitools.StartingPosition;
import com.crowsofwar.avatar.client.uitools.UiTransform;
import com.crowsofwar.avatar.client.uitools.UiTransformBasic;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;

public abstract class UiComponent
extends Gui {
    protected final Minecraft mc = Minecraft.func_71410_x();
    private UiTransform transform = new UiTransformBasic(this);
    private boolean visible = true;

    public UiTransform transform() {
        return this.transform;
    }

    public void setTransform(UiTransform transform) {
        this.transform = transform;
    }

    protected abstract float componentWidth();

    protected abstract float componentHeight();

    public float width() {
        return this.componentWidth() * this.scale() * (float)ScreenInfo.scaleFactor();
    }

    public float height() {
        return this.componentHeight() * this.scale() * (float)ScreenInfo.scaleFactor();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void draw(float partialTicks, float mouseX, float mouseY) {
        this.transform.update(partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.visible) {
            return;
        }
        GlStateManager.func_179094_E();
        float x = this.coordinates().xInPixels() / (float)ScreenInfo.scaleFactor();
        float y = this.coordinates().yInPixels() / (float)ScreenInfo.scaleFactor();
        GlStateManager.func_179109_b((float)((int)x), (float)((int)y), (float)0.0f);
        GlStateManager.func_179152_a((float)this.scale(), (float)this.scale(), (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)this.zLevel());
        this.componentDraw(partialTicks, this.isMouseHover(mouseX, mouseY));
        GlStateManager.func_179121_F();
    }

    protected abstract void componentDraw(float var1, boolean var2);

    public final void mouseClicked(float mouseX, float mouseY, int button) {
        if (this.isMouseHover(mouseX, mouseY)) {
            this.click(button);
        }
    }

    protected void click(int button) {
    }

    public void keyPressed(int keyCode) {
    }

    public List<String> getTooltip(float mouseX, float mouseY) {
        return null;
    }

    public boolean isMouseHover(float mouseX, float mouseY) {
        Measurement min = this.coordinates().times(1.0f / (float)ScreenInfo.scaleFactor());
        Measurement max = min.plus(Measurement.fromPixels(this.width() / (float)ScreenInfo.scaleFactor(), this.height() / (float)ScreenInfo.scaleFactor()));
        return mouseX >= min.xInPixels() && mouseX <= max.xInPixels() && mouseY >= min.yInPixels() && mouseY <= max.yInPixels() && this.visible;
    }

    public Measurement coordinates() {
        return this.transform.coordinates();
    }

    public StartingPosition position() {
        return this.transform.position();
    }

    public void setPosition(StartingPosition position) {
        this.transform.setPosition(position);
    }

    public Measurement offset() {
        return this.transform.offset();
    }

    public void setOffset(Measurement offset) {
        this.transform.setOffset(offset);
    }

    public void addOffset(Measurement offset) {
        this.transform.addOffset(offset);
    }

    public float offsetScale() {
        return this.transform.offsetScale();
    }

    public void setOffsetScale(float scale) {
        this.transform.setOffsetScale(scale);
    }

    public float scale() {
        return this.transform.scale();
    }

    public void setScale(float scale) {
        this.transform.setScale(scale);
    }

    public float zLevel() {
        return this.transform.zLevel();
    }

    public void setZLevel(float zLevel) {
        this.transform.setZLevel(zLevel);
    }

    public Frame getFrame() {
        return this.transform.getFrame();
    }

    public void setFrame(Frame frame) {
        this.transform.setFrame(frame);
    }
}

