/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.uitools;

import com.crowsofwar.avatar.client.uitools.Measurement;
import com.crowsofwar.avatar.client.uitools.ScreenInfo;
import com.crowsofwar.avatar.client.uitools.UiComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Mouse;

public class UiComponentHandler {
    private final List<UiComponent> components = new ArrayList<UiComponent>();

    public UiComponentHandler() {
    }

    public UiComponentHandler(UiComponent ... components) {
        this();
        this.components.addAll(Arrays.asList(components));
    }

    public void add(UiComponent component) {
        this.components.add(component);
    }

    public void draw(float partialTicks, float mouseX, float mouseY) {
        List<String> tooltip = null;
        for (UiComponent component : this.components) {
            List<String> result;
            component.draw(partialTicks, mouseX, mouseY);
            if (!component.isVisible()) continue;
            float mx2 = Mouse.getX();
            float my2 = ScreenInfo.screenHeight() - Mouse.getY();
            Measurement coords = component.coordinates();
            if (!(mx2 >= coords.xInPixels()) || !(mx2 <= coords.xInPixels() + component.width()) || !(my2 >= coords.yInPixels()) || !(my2 <= coords.yInPixels() + component.height()) || (result = component.getTooltip(mx2, my2)) == null) continue;
            tooltip = result;
        }
        if (tooltip != null) {
            int width = ScreenInfo.screenWidth() / ScreenInfo.scaleFactor();
            int height = ScreenInfo.screenHeight() / ScreenInfo.scaleFactor();
            GuiUtils.drawHoveringText(tooltip, (int)((int)mouseX), (int)((int)mouseY), (int)width, (int)height, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
            GlStateManager.func_179140_f();
        }
    }

    public void click(float x, float y, int button) {
        for (UiComponent component : this.components) {
            component.mouseClicked(x, y, button);
        }
    }

    public void type(int key) {
        for (UiComponent component : this.components) {
            component.keyPressed(key);
        }
    }
}

