/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.uitools;

import com.crowsofwar.avatar.client.uitools.Frame;
import com.crowsofwar.avatar.client.uitools.Measurement;
import com.crowsofwar.avatar.client.uitools.StartingPosition;
import com.crowsofwar.avatar.client.uitools.UiComponent;
import com.crowsofwar.avatar.client.uitools.UiTransform;

public class UiTransformBasic
implements UiTransform {
    private final UiComponent component;
    private StartingPosition pos;
    private Measurement offset;
    private float offsetScale;
    private float componentScale;
    private Frame frame;
    private float zLevel;

    public UiTransformBasic(UiComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Cannot have null component");
        }
        this.component = component;
        this.pos = StartingPosition.TOP_LEFT;
        this.offset = Measurement.fromPixels(0.0f, 0.0f);
        this.offsetScale = 1.0f;
        this.componentScale = 1.0f;
        this.frame = Frame.SCREEN;
        this.zLevel = 0.0f;
    }

    @Override
    public Measurement coordinates() {
        float w = this.frame.getDimensions().xInPixels();
        float h = this.frame.getDimensions().yInPixels();
        float x = this.frame.getCoordsMin().xInPixels() + this.pos.getX() * w;
        float y = this.frame.getCoordsMin().yInPixels() + this.pos.getY() * h;
        return Measurement.fromPixels(x += this.offset().xInPixels() * this.offsetScale - this.pos.getMinusX() * this.component.width(), y += this.offset().yInPixels() * this.offsetScale - this.pos.getMinusY() * this.component.height());
    }

    @Override
    public StartingPosition position() {
        return this.pos;
    }

    @Override
    public void setPosition(StartingPosition position) {
        this.pos = position;
    }

    @Override
    public Measurement offset() {
        return this.offset;
    }

    @Override
    public void setOffset(Measurement offset) {
        this.offset = offset;
    }

    @Override
    public float offsetScale() {
        return this.offsetScale;
    }

    @Override
    public void setOffsetScale(float scale) {
        this.offsetScale = scale;
    }

    @Override
    public float scale() {
        return this.componentScale;
    }

    @Override
    public void setScale(float scale) {
        this.componentScale = scale;
    }

    @Override
    public void update(float partialTicks) {
    }

    @Override
    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    @Override
    public float zLevel() {
        return this.zLevel;
    }

    @Override
    public void setZLevel(float zLevel) {
        this.zLevel = zLevel;
    }
}

