/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.client.uitools;

import com.crowsofwar.avatar.client.uitools.Frame;
import com.crowsofwar.avatar.client.uitools.Measurement;
import com.crowsofwar.avatar.client.uitools.StartingPosition;
import com.crowsofwar.avatar.client.uitools.UiTransform;

public class UiTransformTransition
implements UiTransform {
    private final UiTransform initial;
    private final UiTransform ending;
    private final float maxTicks;
    private float ticks;
    private float lastPartialTicks;

    public UiTransformTransition(UiTransform initial, UiTransform ending, float seconds) {
        this.initial = initial;
        this.ending = ending;
        this.maxTicks = seconds * 20.0f;
    }

    private float percentDone() {
        float value = this.ticks / this.maxTicks;
        return value > 1.0f ? 1.0f : value;
    }

    private float invPercentDone() {
        return 1.0f - this.percentDone();
    }

    @Override
    public Measurement coordinates() {
        return this.ending.coordinates().times(this.percentDone()).plus(this.initial.coordinates().times(this.invPercentDone()));
    }

    @Override
    public StartingPosition position() {
        Measurement dim1 = this.initial.getFrame().getDimensions();
        Measurement dim2 = this.ending.getFrame().getDimensions();
        float x = this.ending.position().getX() * dim2.xInPixels() * this.percentDone() + this.initial.position().getX() * dim1.xInPixels() * this.invPercentDone();
        float y = this.ending.position().getY() * dim2.yInPixels() * this.percentDone() + this.initial.position().getY() * dim1.yInPixels() * this.invPercentDone();
        return StartingPosition.custom(x, y);
    }

    @Override
    public void setPosition(StartingPosition position) {
    }

    @Override
    public Measurement offset() {
        return this.ending.offset().times(this.percentDone()).plus(this.initial.offset().times(this.invPercentDone()));
    }

    @Override
    public void setOffset(Measurement offset) {
    }

    @Override
    public float scale() {
        return this.ending.scale() * this.percentDone() + this.initial.scale() * this.invPercentDone();
    }

    @Override
    public void setScale(float scale) {
    }

    @Override
    public float offsetScale() {
        return this.ending.offsetScale() * this.percentDone() + this.initial.offsetScale() * this.invPercentDone();
    }

    @Override
    public void setOffsetScale(float scale) {
    }

    @Override
    public void update(float partialTicks) {
        float diff = partialTicks - this.lastPartialTicks;
        if (diff < 0.0f) {
            diff += 1.0f;
        }
        this.ticks += diff;
        this.lastPartialTicks = partialTicks;
    }

    @Override
    public Frame getFrame() {
        return Frame.SCREEN;
    }

    @Override
    public void setFrame(Frame frame) {
    }

    @Override
    public float zLevel() {
        return this.ending.zLevel() * this.percentDone() + this.initial.zLevel() * this.invPercentDone();
    }

    @Override
    public void setZLevel(float zLevel) {
    }
}

