/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.common.triggers;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;

public class AbilityPredicate {
    public static final AbilityPredicate ANY = new AbilityPredicate();
    private final int initialLevel;
    private final int newLevel;
    private final int level;
    private Ability ability;
    private final Ability[] abilities;

    public AbilityPredicate() {
        this.ability = null;
        this.initialLevel = 0;
        this.newLevel = 0;
        this.level = 0;
        this.abilities = (Ability[])Abilities.all().toArray(new Ability[0]).clone();
    }

    public AbilityPredicate(@Nullable Ability ability, Ability[] abilities, int initialLevel, int newLevel, int level) {
        this.ability = ability;
        this.initialLevel = initialLevel;
        this.newLevel = newLevel;
        this.level = level;
        this.abilities = abilities;
    }

    public static AbilityPredicate deserialize(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            String s;
            String s2;
            String s3;
            String s4;
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)element, (String)"ability");
            Ability ability = null;
            if (jsonobject.has("ability") && (ability = Abilities.get(s4 = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"ability"))) == null) {
                throw new JsonSyntaxException("Unknown ability name '" + s4 + "'");
            }
            int fromLevel = -1;
            if (jsonobject.has("fromLevel") && (fromLevel = Integer.parseInt(s3 = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"fromLevel"))) < 0) {
                throw new JsonSyntaxException("Unknown fromLevel value '" + s3 + "'");
            }
            int toLevel = -1;
            if (jsonobject.has("toLevel") && (toLevel = Integer.parseInt(s2 = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"toLevel"))) < 0) {
                throw new JsonSyntaxException("Unknown toLevel value '" + s2 + "'");
            }
            int level = -1;
            if (jsonobject.has("level") && (level = Integer.parseInt(s = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"level"))) < 0) {
                throw new JsonSyntaxException("Unknown toLevel value '" + s + "'");
            }
            Ability[] abilities = Abilities.all().toArray(new Ability[Abilities.all().size()]);
            if (jsonobject.has("abilities")) {
                try {
                    JsonArray array = JsonUtils.func_151214_t((JsonObject)jsonobject, (String)"abilities");
                    abilities = (Ability[])Streams.stream((Iterable)array).map(je -> Abilities.get(JsonUtils.func_151206_a((JsonElement)je, (String)"ability"))).toArray(Ability[]::new);
                }
                catch (IllegalArgumentException e) {
                    throw new JsonSyntaxException("Incorrect ability predicate value", (Throwable)e);
                }
            }
            return new AbilityPredicate(ability, abilities, fromLevel, toLevel, level);
        }
        return ANY;
    }

    public static AbilityPredicate[] deserializeArray(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonArray jsonarray = JsonUtils.func_151207_m((JsonElement)element, (String)"abilities");
            AbilityPredicate[] predicates = new AbilityPredicate[jsonarray.size()];
            for (int i = 0; i < predicates.length; ++i) {
                predicates[i] = AbilityPredicate.deserialize(jsonarray.get(i));
            }
            return predicates;
        }
        return new AbilityPredicate[0];
    }

    public boolean test(Ability ability, int initialLevel, int newLevel) {
        if (this.ability != null && ability != this.ability) {
            return false;
        }
        if (!Arrays.asList(this.abilities).contains(ability)) {
            return false;
        }
        return this.initialLevel == initialLevel && this.newLevel == newLevel;
    }

    public boolean test(Ability ability, int level) {
        if (this.ability != null && ability != this.ability) {
            return false;
        }
        if (!Arrays.asList(this.abilities).contains(ability)) {
            return false;
        }
        return this.level == level;
    }
}

