/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.common.triggers;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.common.triggers.AbilityUnlockTrigger;
import com.crowsofwar.avatar.common.triggers.ElementRankupTrigger;
import com.crowsofwar.avatar.common.triggers.LevelAbilityTrigger;
import com.crowsofwar.avatar.common.triggers.UnlockBendingTrigger;
import com.crowsofwar.avatar.common.triggers.UseAbilityTrigger;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.event.AbilityLevelEvent;
import com.crowsofwar.avatar.util.event.AbilityUnlockEvent;
import com.crowsofwar.avatar.util.event.AbilityUseEvent;
import com.crowsofwar.avatar.util.event.ElementUnlockEvent;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="avatarmod")
public class AvatarTriggers {
    public static final UnlockBendingTrigger UNLOCK_ELEMENT = new UnlockBendingTrigger("unlock_bending");
    public static final LevelAbilityTrigger ABILITY_LEVEL = new LevelAbilityTrigger("level_ability");
    public static final UseAbilityTrigger ABILITY_USE = new UseAbilityTrigger("use_ability");
    public static final ElementRankupTrigger ELEMENT_RANK = new ElementRankupTrigger("rankup_bending");
    public static final AbilityUnlockTrigger UNLOCK_ABILITY = new AbilityUnlockTrigger("unlock_ability");

    public static void init() {
        CriteriaTriggers.func_192118_a((ICriterionTrigger)UNLOCK_ELEMENT);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)ABILITY_LEVEL);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)ABILITY_USE);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)ELEMENT_RANK);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)UNLOCK_ABILITY);
    }

    @SubscribeEvent
    public static void unlockBending(ElementUnlockEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            UNLOCK_ELEMENT.trigger((EntityPlayerMP)event.getEntity(), event.getElement());
            ELEMENT_RANK.trigger((EntityPlayerMP)event.getEntity(), event.getElement(), -1, 0);
        }
    }

    @SubscribeEvent
    public static void levelAbility(AbilityLevelEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            ABILITY_LEVEL.trigger((EntityPlayerMP)event.getEntity(), event.getAbility(), event.getOldLevel(), event.getNewLevel());
            BendingData data = BendingData.getFromEntity(event.getEntityLiving());
            if (data != null) {
                Ability ability = event.getAbility();
                BendingData.Rank rank = data.getRank(ability.getElement(), 0);
                BendingData.Rank newRank = data.getRank(ability.getElement(), event.getNewLevel() - event.getOldLevel());
                ELEMENT_RANK.trigger((EntityPlayerMP)event.getEntity(), event.getAbility().getElement(), rank.ordinal(), newRank.ordinal());
            }
        }
    }

    @SubscribeEvent
    public static void useAbility(AbilityUseEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            ABILITY_USE.trigger((EntityPlayerMP)event.getEntity(), event.getAbility(), event.getLevel() - 1);
        }
    }

    @SubscribeEvent
    public static void unlockAbility(AbilityUnlockEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            UNLOCK_ABILITY.trigger((EntityPlayerMP)event.getEntity(), event.getAbility());
            BendingData data = BendingData.getFromEntity(event.getEntityLiving());
            if (data != null) {
                Ability ability = event.getAbility();
                BendingData.Rank rank = data.getRank(ability.getElement(), 0);
                BendingData.Rank newRank = data.getRank(ability.getElement(), 1);
                ELEMENT_RANK.trigger((EntityPlayerMP)event.getEntity(), event.getAbility().getElement(), rank.ordinal(), newRank.ordinal());
            }
        }
    }
}

