/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.common.triggers;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.BendingStyles;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;

public class ElementPredicate {
    public static final ElementPredicate ANY = new ElementPredicate();
    private final BendingStyle element;
    private final BendingStyle[] elements;
    private final int oldRank;
    private final int newRank;

    public ElementPredicate() {
        this.element = null;
        this.elements = BendingStyles.all().toArray(new BendingStyle[BendingStyles.all().size()]);
        this.oldRank = 0;
        this.newRank = 0;
    }

    public ElementPredicate(@Nullable BendingStyle element, BendingStyle[] elements, int oldRank, int newRank) {
        this.element = element;
        this.elements = elements;
        this.oldRank = oldRank;
        this.newRank = newRank;
    }

    public static ElementPredicate deserialize(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            String s;
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)element, (String)"element");
            BendingStyle style = null;
            if (jsonobject.has("element") && (style = BendingStyles.get(s = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"element"))) == null) {
                throw new JsonSyntaxException("Unknown element name '" + s + "'");
            }
            BendingStyle[] elements = BendingStyles.all().toArray(new BendingStyle[BendingStyles.all().size()]);
            if (jsonobject.has("elements")) {
                try {
                    JsonArray array = JsonUtils.func_151214_t((JsonObject)jsonobject, (String)"elements");
                    elements = (BendingStyle[])Streams.stream((Iterable)array).map(je -> BendingStyles.get(JsonUtils.func_151206_a((JsonElement)je, (String)"element"))).toArray(BendingStyle[]::new);
                }
                catch (IllegalArgumentException e) {
                    throw new JsonSyntaxException("Incorrect style predicate value", (Throwable)e);
                }
            }
            int oldRank = 0;
            if (jsonobject.has("oldRank")) {
                try {
                    oldRank = JsonUtils.func_151203_m((JsonObject)jsonobject, (String)"oldRank");
                }
                catch (IllegalArgumentException e) {
                    throw new JsonSyntaxException("Incorrect rank value", (Throwable)e);
                }
            }
            int newRank = 0;
            if (jsonobject.has("newRank")) {
                try {
                    newRank = JsonUtils.func_151203_m((JsonObject)jsonobject, (String)"newRank");
                }
                catch (IllegalArgumentException e) {
                    throw new JsonSyntaxException("Incorrect rank value", (Throwable)e);
                }
            }
            return new ElementPredicate(style, elements, oldRank, newRank);
        }
        return ANY;
    }

    public static ElementPredicate[] deserializeArray(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonArray jsonarray = JsonUtils.func_151207_m((JsonElement)element, (String)"spells");
            ElementPredicate[] predicates = new ElementPredicate[jsonarray.size()];
            for (int i = 0; i < predicates.length; ++i) {
                predicates[i] = ElementPredicate.deserialize(jsonarray.get(i));
            }
            return predicates;
        }
        return new ElementPredicate[0];
    }

    public boolean test(BendingStyle element) {
        if (this.element != null && element != this.element) {
            return false;
        }
        return Arrays.asList(this.elements).contains(element);
    }

    public boolean test(BendingStyle element, int oldRank, int newRank) {
        if (this.element != null && element != this.element) {
            return false;
        }
        if (this.newRank != newRank || this.oldRank != oldRank) {
            return false;
        }
        return Arrays.asList(this.elements).contains(element);
    }
}

