/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.config;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import io.netty.buffer.ByteBuf;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class AbilityProperties {
    private static final Gson gson = new Gson();
    private final Multimap<String, Number> baseValues;
    private final Multimap<String, Boolean> baseBooleans;

    private AbilityProperties(JsonObject json, Ability ability) {
        List<String> baseValueNames = Arrays.asList(ability.getPropertyKeys());
        List<String> baseBooleanNames = Arrays.asList(ability.getBooleanPropertyKeys());
        this.baseValues = ArrayListMultimap.create();
        this.baseBooleans = ArrayListMultimap.create();
        JsonObject customProperties = JsonUtils.func_152754_s((JsonObject)json, (String)"custom_properties");
        Collections.sort(baseValueNames);
        Collections.sort(baseBooleanNames);
        for (String name : baseValueNames) {
            if (!name.equalsIgnoreCase("xpOnHit") && !name.equalsIgnoreCase("xpOnUse")) continue;
            this.baseValues.put((Object)name, (Object)Float.valueOf(JsonUtils.func_151217_k((JsonObject)customProperties, (String)name)));
        }
        for (int i = 0; i < 5; ++i) {
            ArrayList vals;
            JsonObject baseValueObject;
            int redundantKeys;
            String jsonName = "level" + (i + 1);
            if (i >= 3) {
                jsonName = "level4_" + (i - 2);
            }
            if ((redundantKeys = (baseValueObject = JsonUtils.func_152754_s((JsonObject)customProperties, (String)jsonName)).size() - (baseValueNames.size() + baseBooleanNames.size())) > 0) {
                for (String key : baseValueNames) {
                    if (this.baseBooleans.containsKey((Object)key) || this.baseValues.containsKey((Object)key)) continue;
                    AvatarLog.warn("Ability " + ability.getName() + " has " + redundantKeys + " redundant ability property key(s) defined in its JSON file. Extra values will have no effect! (Av2 devs: make sure you have called addProperties(...) during ability construction)");
                    AvatarLog.info("Ability " + ability.getName() + " has redundant key " + key);
                    break;
                }
            }
            if (baseValueNames.size() > 0) {
                for (String baseValueName : baseValueNames) {
                    if (baseValueName.equalsIgnoreCase("xpOnHit") || baseValueName.equalsIgnoreCase("xpOnUse")) continue;
                    try {
                        this.baseValues.put((Object)baseValueName, (Object)Float.valueOf(JsonUtils.func_151217_k((JsonObject)baseValueObject, (String)baseValueName)));
                    }
                    catch (JsonSyntaxException e) {
                        if (!this.baseValues.containsKey((Object)baseValueName)) {
                            AvatarLog.warn(AvatarLog.WarningType.CONFIGURATION, "Either someone's been lazy and left out a value, or your properties file is screwed.");
                            AvatarLog.warn(AvatarLog.WarningType.CONFIGURATION, baseValueName + ", Ability: " + ability.getName());
                            continue;
                        }
                        vals = new ArrayList(this.baseValues.get((Object)baseValueName));
                        this.baseValues.put((Object)baseValueName, vals.get(vals.size() - 1));
                    }
                }
            }
            if (baseBooleanNames.size() <= 0) continue;
            for (String baseBooleanName : baseBooleanNames) {
                try {
                    this.baseBooleans.put((Object)baseBooleanName, (Object)JsonUtils.func_151212_i((JsonObject)baseValueObject, (String)baseBooleanName));
                }
                catch (JsonSyntaxException e) {
                    if (!this.baseBooleans.containsKey((Object)baseBooleanName)) {
                        AvatarLog.warn(AvatarLog.WarningType.CONFIGURATION, "Either someone's been lazy and left out " + baseBooleanName + ", or your properties file is screwed.");
                        continue;
                    }
                    vals = new ArrayList(this.baseBooleans.get((Object)baseBooleanName));
                    this.baseBooleans.put((Object)baseBooleanName, vals.get(vals.size() - 1));
                }
            }
        }
    }

    public AbilityProperties(Ability ability, ByteBuf buf) {
        this.baseValues = ArrayListMultimap.create();
        this.baseBooleans = ArrayListMultimap.create();
        List<String> keys = Arrays.asList(ability.getPropertyKeys());
        List<String> bKeys = Arrays.asList(ability.getBooleanPropertyKeys());
        Collections.sort(keys);
        Collections.sort(bKeys);
        if (!keys.isEmpty()) {
            for (String key : keys) {
                this.baseValues.put((Object)key, (Object)Float.valueOf(buf.readFloat()));
            }
        }
        if (!bKeys.isEmpty()) {
            for (String key : bKeys) {
                this.baseBooleans.put((Object)key, (Object)buf.readBoolean());
            }
        }
    }

    public static void init() {
        boolean flag = AbilityProperties.loadConfigAbilityProperties();
        if (!(flag &= AbilityProperties.loadBuiltInAbilityProperties())) {
            AvatarLog.warn("Some ability property files did not load correctly; this will likely cause problems later!");
        }
    }

    public static boolean addPropertiesToConfig(File targetDirectory) {
        if (targetDirectory.mkdirs() || targetDirectory.exists() || targetDirectory.isDirectory()) {
            AvatarLog.info("Starting to generate external config files.");
            ModContainer mod = Loader.instance().getModList().stream().filter(modContainer -> modContainer.getModId().equals("avatarmod")).findFirst().orElse(null);
            ArrayList<Ability> abilities = new ArrayList<Ability>(Abilities.all());
            assert (mod != null);
            CraftingHelper.findFiles((ModContainer)mod, (String)"assets/avatarmod/abilities", null, (root, file) -> {
                String relative = root.relativize((Path)file).toString();
                if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                    return true;
                }
                String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
                Ability ability = Abilities.get(name);
                if (ability == null) {
                    AvatarLog.error("Ability config file is for an ability that doesn't exist.");
                    return true;
                }
                if (!abilities.remove(ability)) {
                    AvatarLog.error("What's going on?!");
                }
                try {
                    File abilityFile = new File(targetDirectory.getPath(), ability.getName() + ".json");
                    if (!abilityFile.exists() && ConfigSkills.SKILLS_CONFIG.abilitySettings.generateAbilities) {
                        Files.copy(file, abilityFile.toPath(), new CopyOption[0]);
                    } else if (ConfigSkills.SKILLS_CONFIG.abilitySettings.overrideAbilities) {
                        Files.delete(abilityFile.toPath());
                        Files.copy(file, abilityFile.toPath(), new CopyOption[0]);
                    }
                }
                catch (IOException ioexception) {
                    ioexception.printStackTrace();
                    return false;
                }
                return true;
            }, (boolean)true, (boolean)true);
        }
        return true;
    }

    public static void loadWorldSpecificAbilityProperties(World world) {
        AvatarLog.info("Loading custom ability properties for world {" + world.func_72912_H().func_76065_j() + "}");
        File abilityJSONDir = new File(new File(world.func_72860_G().func_75765_b(), "data"), "abilities");
        if (abilityJSONDir.mkdirs()) {
            return;
        }
        if (!AbilityProperties.loadAbilityPropertiesFromDir(abilityJSONDir)) {
            AvatarLog.warn(AvatarLog.WarningType.CONFIGURATION, "Some ability property files did not load correctly; this will likely cause problems later!");
        }
    }

    private static boolean loadConfigAbilityProperties() {
        AvatarLog.info("Loading ability properties from config folder");
        File abilityJsonDir = new File(AvatarMod.configDirectory, "abilities");
        if (!abilityJsonDir.exists() && ConfigSkills.SKILLS_CONFIG.abilitySettings.generateAbilities || ConfigSkills.SKILLS_CONFIG.abilitySettings.overrideAbilities) {
            AvatarLog.info("No override config found, default values will be used unless there's world-specific properties.");
            AbilityProperties.addPropertiesToConfig(abilityJsonDir);
            return true;
        }
        return AbilityProperties.loadAbilityPropertiesFromDir(abilityJsonDir);
    }

    private static boolean loadBuiltInAbilityProperties() {
        ModContainer mod = Loader.instance().getModList().stream().filter(modContainer -> modContainer.getModId().equals("avatarmod")).findFirst().orElse(null);
        ArrayList<Ability> abilities = new ArrayList<Ability>(Abilities.all());
        AvatarLog.info("Loading built-in ability properties for " + abilities.size() + " abilities in " + "avatarmod");
        assert (mod != null);
        boolean success = CraftingHelper.findFiles((ModContainer)mod, (String)"assets/avatarmod/abilities", null, (root, file) -> {
            String relative = root.relativize((Path)file).toString();
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                return true;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            ResourceLocation key = new ResourceLocation("avatarmod", name);
            Ability ability = Abilities.get(name);
            if (ability == null) {
                AvatarLog.error("Ability config file is for an ability that doesn't exist.");
                return true;
            }
            if (!abilities.remove(ability)) {
                AvatarLog.error("What's going on?!");
            }
            if (ability.arePropertiesInitialised()) {
                return true;
            }
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file);
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)gson, (Reader)reader, JsonObject.class);
                AbilityProperties properties = new AbilityProperties(json, ability);
                ability.setProperties(properties);
                AvatarLog.info("Property load successful for " + key + " !");
            }
            catch (JsonParseException jsonparseexception) {
                AvatarLog.error("Parsing error loading ability property file for " + key, jsonparseexception);
                Boolean bl = false;
                return bl;
            }
            catch (IOException ioexception) {
                AvatarLog.error("Couldn't read ability property file for " + key, ioexception);
                Boolean bl = false;
                return bl;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            return true;
        }, (boolean)true, (boolean)true);
        if (!abilities.isEmpty()) {
            if (abilities.size() <= 15) {
                abilities.forEach(a -> AvatarLog.error("Ability " + a.getName() + " is missing a properties file!"));
            } else {
                AvatarLog.error("Mod avatarmod has " + abilities.size() + " abilities that are missing properties files!");
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadAbilityPropertiesFromDir(File dir) {
        boolean success = true;
        for (File file : FileUtils.listFiles((File)dir, (String[])new String[]{"json"}, (boolean)true)) {
            String relative = dir.toPath().relativize(file.toPath()).toString();
            String nameAndModID = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            String modID = nameAndModID.split("/")[0];
            String name = nameAndModID.substring(nameAndModID.indexOf(47) + 1);
            ResourceLocation key = new ResourceLocation(modID, name);
            Ability ability = Abilities.get(name);
            if (ability == null) {
                AvatarLog.error("Attempted to get an ability that doesn't exist from file location " + key);
                continue;
            }
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file.toPath());
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)gson, (Reader)reader, JsonObject.class);
                AbilityProperties properties = new AbilityProperties(json, ability);
                ability.setProperties(properties);
            }
            catch (JsonParseException jsonparseexception) {
                AvatarLog.error("Parsing error loading ability property file for " + key, jsonparseexception);
                success = false;
            }
            catch (IOException ioexception) {
                AvatarLog.error("Couldn't read ability property file for " + key, ioexception);
                success = false;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        return success;
    }

    public void write(ByteBuf buf) {
        ArrayList keys = new ArrayList(this.baseValues.keys());
        Collections.sort(keys);
        if (!keys.isEmpty()) {
            for (String key : keys) {
                for (Number num : this.baseValues.get((Object)key)) {
                    buf.writeFloat(num.floatValue());
                }
            }
        }
        ArrayList bKeys = new ArrayList(this.baseBooleans.keys());
        Collections.sort(bKeys);
        if (!bKeys.isEmpty()) {
            for (String key : bKeys) {
                Iterator iterator = this.baseBooleans.get((Object)key).iterator();
                while (iterator.hasNext()) {
                    boolean b = (Boolean)iterator.next();
                    buf.writeBoolean(b);
                }
            }
        }
    }

    public Number getBaseValue(String identifier, int abilityLevel, AbilityData.AbilityTreePath path) {
        if (!this.baseValues.containsKey((Object)identifier)) {
            throw new IllegalArgumentException("Base value with identifier '" + identifier + "' is not defined.");
        }
        ArrayList list = new ArrayList(this.baseValues.get((Object)identifier));
        return (Number)list.get(Math.min(list.size() - 1, Math.max(path == AbilityData.AbilityTreePath.SECOND ? abilityLevel + 1 : abilityLevel, 0)));
    }

    public boolean getBaseBooleanValue(String identifier, int abilityLevel, AbilityData.AbilityTreePath path) {
        if (!this.baseBooleans.containsKey((Object)identifier)) {
            throw new IllegalArgumentException("Base value with identifier '" + identifier + "' is not defined.");
        }
        ArrayList list = new ArrayList(this.baseBooleans.get((Object)identifier));
        return (Boolean)list.get(Math.min(list.size() - 1, Math.max(path == AbilityData.AbilityTreePath.SECOND ? abilityLevel + 1 : abilityLevel, 0)));
    }

    public List<String> getValues() {
        return new ArrayList<String>(this.baseValues.keySet());
    }
}

