/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.config;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.gorecore.config.ConfigLoader;
import com.crowsofwar.gorecore.config.Load;
import java.util.UUID;

public class ConfigAnalytics {
    public static final ConfigAnalytics ANALYTICS_CONFIG = new ConfigAnalytics();
    public UUID analyticsId;
    @Load
    private boolean analyticsEnabled = true;
    @Load
    public boolean displayAnalyticsWarning = true;
    @Load
    private String analyticsIdStr = UUID.randomUUID().toString();
    private boolean inAnalyticsGroup = false;

    private ConfigAnalytics() {
    }

    public static void load() {
        ConfigLoader.load(ANALYTICS_CONFIG, "avatar/analytics.yml", true);
        ANALYTICS_CONFIG.setupAnalyticsId();
    }

    private void setupAnalyticsId() {
        try {
            this.analyticsId = UUID.fromString(this.analyticsIdStr);
            this.inAnalyticsGroup = this.analyticsId.toString().startsWith("00");
        }
        catch (IllegalArgumentException e) {
            this.analyticsId = UUID.randomUUID();
            this.analyticsEnabled = false;
            AvatarLog.warn(AvatarLog.WarningType.CONFIGURATION, "Invalid analytics id string, analytics temporarily disabled. Suggested to edit analytics.yml and set analyticsIdStr to '" + UUID.randomUUID().toString() + "'");
        }
    }

    public void optOutAnalytics() {
        this.analyticsEnabled = false;
        ConfigLoader.save(this, "avatar/analytics.yml", true);
    }

    public void dontShowAnalyticsWarning() {
        this.displayAnalyticsWarning = false;
        ConfigLoader.save(this, "avatar/analytics.yml", true);
    }

    public boolean isAnalyticsEnabled() {
        return this.analyticsEnabled && this.inAnalyticsGroup;
    }
}

