/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.config;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.gorecore.config.ConfigLoader;
import com.crowsofwar.gorecore.config.Load;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ConfigClient {
    public static ConfigClient CLIENT_CONFIG = new ConfigClient();
    @Load
    public final float bendingCycleAlpha = 0.75f;
    @Load
    public final boolean displayGetBendingMessage = true;
    @Load
    public final float radialMenuAlpha = 0.75f;
    @Load
    public final float chiBarAlpha = 0.625f;
    @Load
    public final boolean useCustomParticles = true;
    @Load
    private final Map<String, Integer> nameKeymappings = new HashMap<String, Integer>();
    @Load
    private final Map<String, Boolean> nameConflicts = new HashMap<String, Boolean>();
    public Map<Ability, Integer> keymappings = new HashMap<Ability, Integer>();
    public Map<Ability, Boolean> conflicts = new HashMap<Ability, Boolean>();
    @Load
    public ShaderSettings shaderSettings = new ShaderSettings();
    @Load
    public ActiveBendingSettings activeBendingSettings = new ActiveBendingSettings();
    @Load
    public ChiBarSettings chiBarSettings = new ChiBarSettings();
    @Load
    public FireRenderSettings fireRenderSettings = new FireRenderSettings();
    @Load
    public AirRenderSettings airRenderSettings = new AirRenderSettings();
    @Load
    public ParticleRenderSettings particleSettings = new ParticleRenderSettings();

    public static void load() {
        ConfigLoader.load(CLIENT_CONFIG, "avatar/cosmetic.yml");
        Set<Map.Entry<String, Integer>> entries = ConfigClient.CLIENT_CONFIG.nameKeymappings.entrySet();
        for (Map.Entry<String, Integer> entry : entries) {
            Ability ability = null;
            for (Ability a : Abilities.all()) {
                if (!a.getName().equals(entry.getKey())) continue;
                ability = a;
                break;
            }
            if (ability == null) continue;
            ConfigClient.CLIENT_CONFIG.keymappings.put(ability, entry.getValue());
        }
        Set<Map.Entry<String, Boolean>> entries2 = ConfigClient.CLIENT_CONFIG.nameConflicts.entrySet();
        for (Map.Entry<String, Boolean> entry : entries2) {
            Ability ability = null;
            for (Ability a : Abilities.all()) {
                if (!a.getName().equals(entry.getKey())) continue;
                ability = a;
                break;
            }
            if (ability == null) continue;
            ConfigClient.CLIENT_CONFIG.conflicts.put(ability, entry.getValue());
        }
    }

    public static void save() {
        Set<Map.Entry<Ability, Integer>> entries = ConfigClient.CLIENT_CONFIG.keymappings.entrySet();
        for (Map.Entry<Ability, Integer> entry : entries) {
            ConfigClient.CLIENT_CONFIG.nameKeymappings.put(entry.getKey().getName(), entry.getValue());
        }
        Set<Map.Entry<Ability, Boolean>> entries2 = ConfigClient.CLIENT_CONFIG.conflicts.entrySet();
        for (Map.Entry<Ability, Boolean> entry : entries2) {
            ConfigClient.CLIENT_CONFIG.nameConflicts.put(entry.getKey().getName(), entry.getValue());
        }
        ConfigLoader.save(CLIENT_CONFIG, "avatar/cosmetic.yml");
    }

    public static final class ParticleRenderSettings {
        @Load
        public final boolean realisticFlashParticles = true;
        @Load
        public final boolean realisticLightningParticles = true;
        @Load
        public final boolean collideWithBlocks = true;
        @Load
        public final boolean collideWithParticles = true;
        @Load
        public final boolean releaseShaderOnFlashParticleRender = true;
    }

    public static final class AirRenderSettings {
        @Load
        public final boolean airBurstSphere = true;
    }

    public static final class FireRenderSettings {
        @Load
        public final boolean flameStrikeSphere = false;
        @Load
        public final boolean showFlameStrikeOrb = false;
        @Load
        public final boolean solidFlamethrowerParticles = false;
        @Load
        public final boolean solidFlameStrikeParticles = true;
        @Load
        public final int fireR = 255;
        @Load
        public final int fireG = 50;
        @Load
        public final int fireB = 10;
        @Load
        public final int lightningR = 135;
        @Load
        public final int lightningG = 255;
        @Load
        public final int lightningB = 252;
    }

    public static final class ChiBarSettings {
        @Load
        public final boolean shouldChibarRender = true;
        @Load
        public final boolean shouldChiNumbersRender = true;
        @Load
        public final boolean shouldChiMenuDisappear = false;
        @Load
        public final int chibarDuration = 200;
        @Load
        public final double widthScale = 1.1f;
        @Load
        public final double heightScale = 1.1f;
        @Load
        public final int xPos = 115;
        @Load
        public final int yPos = 3;
    }

    public static final class ActiveBendingSettings {
        @Load
        public final boolean shouldBendingMenuRender = true;
        @Load
        public final boolean shouldBendingMenuDisappear = false;
        @Load
        public final int bendingMenuDuration = 200;
        @Load
        public final int middleXPosition = 0;
        @Load
        public final int rightXPosition = 50;
        @Load
        public final int leftXPosition = -35;
        @Load
        public final int middleYPosition = -30;
        @Load
        public final int rightYPosition = 5;
        @Load
        public final int leftYPosition = 5;
        @Load
        public final float middleBendingWidth = 50.0f;
        @Load
        public final float leftBendingWidth = 35.0f;
        @Load
        public final float rightBendingWidth = 35.0f;
        @Load
        public final float middleBendingHeight = 50.0f;
        @Load
        public final float leftBendingHeight = 35.0f;
        @Load
        public final float rightBendingHeight = 35.0f;
    }

    public static final class ShaderSettings {
        @Load
        public final boolean useSlipstreamShaders = false;
        @Load
        public final boolean useCleanseShaders = false;
        @Load
        public final boolean useRestoreShaders = false;
        @Load
        public final boolean useImmolateShaders = false;
        @Load
        public final boolean bslActive = false;
        @Load
        public final boolean sildursActive = false;
    }
}

