/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.config;

import akka.japi.Pair;
import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.config.DropInfo;
import com.crowsofwar.avatar.config.MobDrops;
import com.crowsofwar.avatar.item.scroll.Scrolls;
import com.crowsofwar.gorecore.config.ConfigLoader;
import com.crowsofwar.gorecore.config.Load;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;

public class ConfigMobs {
    private static final Map<String, Integer> DEFAULT_FOODS = new HashMap<String, Integer>();
    private static final Map<String, String> TRADE_ITEMS = new HashMap<String, String>();
    private static final Map<String, String> GLIDER_TRADES = new HashMap<String, String>();
    private static final Map<String, Integer> AIRBENDING_TRADE_ITEMS = new HashMap<String, Integer>();
    private static final Map<String, Integer> FIREBENDING_TRADE_ITEMS = new HashMap<String, Integer>();
    private static final Map<String, MobDrops> DEFAULT_SCROLL_DROPS = new HashMap<String, MobDrops>();
    public static ConfigMobs MOBS_CONFIG = new ConfigMobs();
    @Load
    public BenderSettings benderSettings = new BenderSettings();
    @Load
    public ScrollSettings scrollSettings = new ScrollSettings();
    @Load
    public BisonSettings bisonSettings = new BisonSettings();
    @Load
    private Map<String, Integer> bisonFoods;
    private Map<Item, Integer> bisonFoodList;
    @Load
    private Map<String, Collection<Double>> scrollDropChances;
    @Load
    private Map<String, Collection<Integer>> scrollDropAmounts;
    @Load
    private Map<String, Collection<Integer>> scrollDropTiers;
    @Load
    private Map<String, Collection<String>> scrollTypes;
    private Map<Class<? extends Entity>, MobDrops> scrollDrops;
    @Load
    private Map<String, String> scrollTradeItems;
    private Map<Item, Pair<Integer, String>> tradeItems;

    public static void load() {
        ConfigMobs.MOBS_CONFIG.scrollTradeItems = TRADE_ITEMS;
        ConfigMobs.MOBS_CONFIG.bisonFoods = DEFAULT_FOODS;
        ConfigMobs.loadPreLists();
        ConfigLoader.load(MOBS_CONFIG, "avatar/mobs.yml");
        MOBS_CONFIG.loadLists();
    }

    public static void loadPreLists() {
        ArrayList<MobDrops> info = new ArrayList<MobDrops>(DEFAULT_SCROLL_DROPS.values());
        ConfigMobs.MOBS_CONFIG.scrollTypes = new HashMap<String, Collection<String>>();
        ConfigMobs.MOBS_CONFIG.scrollDropAmounts = new HashMap<String, Collection<Integer>>();
        ConfigMobs.MOBS_CONFIG.scrollDropTiers = new HashMap<String, Collection<Integer>>();
        ConfigMobs.MOBS_CONFIG.scrollDropChances = new HashMap<String, Collection<Double>>();
        for (MobDrops drop : info) {
            ConfigMobs.MOBS_CONFIG.scrollTypes.put(drop.getMobName(), drop.getDropTypes());
            ConfigMobs.MOBS_CONFIG.scrollDropAmounts.put(drop.getMobName(), drop.getDropAmounts());
            ConfigMobs.MOBS_CONFIG.scrollDropTiers.put(drop.getMobName(), drop.getDropTiers());
            ConfigMobs.MOBS_CONFIG.scrollDropChances.put(drop.getMobName(), drop.getDropChances());
        }
    }

    public void loadLists() {
        String name;
        ConfigMobs.MOBS_CONFIG.scrollDrops = new HashMap<Class<? extends Entity>, MobDrops>();
        int i = 0;
        for (String string : this.scrollTypes.keySet()) {
            this.scrollDrops.put(MobDrops.getClassFromName(string), MobDrops.fromCollections(string, new ArrayList<Collection<String>>(this.scrollTypes.values()).get(i), new ArrayList<Collection<Integer>>(this.scrollDropAmounts.values()).get(i), new ArrayList<Collection<Integer>>(this.scrollDropTiers.values()).get(i), new ArrayList<Collection<Double>>(this.scrollDropChances.values()).get(i)));
            ++i;
        }
        this.bisonFoodList = new HashMap<Item, Integer>();
        for (Map.Entry entry : this.bisonFoods.entrySet()) {
            name = (String)entry.getKey();
            Item item = Item.func_111206_d((String)name);
            if (item != null) {
                this.bisonFoodList.put(item, (Integer)entry.getValue());
                continue;
            }
            AvatarLog.warn(AvatarLog.WarningType.CONFIGURATION, "Invalid bison food; item " + name + " not found");
        }
        this.tradeItems = new HashMap<Item, Pair<Integer, String>>();
        for (Map.Entry entry : this.scrollTradeItems.entrySet()) {
            name = (String)entry.getKey();
            String tierS = name.split(" ")[1];
            name = name.split(" ")[0];
            int tier = 1;
            try {
                tier = Integer.parseInt(tierS);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                AvatarLog.warn(AvatarLog.WarningType.CONFIGURATION, "Please enter a number for the tier next to the item name.");
            }
            Item item = Item.func_111206_d((String)name);
            if (item != null) {
                this.tradeItems.put(item, (Pair<Integer, String>)new Pair((Object)tier, entry.getValue()));
                continue;
            }
            AvatarLog.warn(AvatarLog.WarningType.CONFIGURATION, "Invalid trade item; item " + name + " not found");
        }
    }

    public int getDomesticationValue(Item item) {
        return this.bisonFoodList.getOrDefault(item, 0);
    }

    public List<Item> getTradeItems() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Map.Entry<Item, Pair<Integer, String>> entry : this.tradeItems.entrySet()) {
            items.add(entry.getKey());
        }
        return items;
    }

    public boolean isTradeItem(Item item) {
        return this.tradeItems.containsKey(item);
    }

    public String getTradeItemElement(Item item) {
        return (String)this.tradeItems.get(item).second();
    }

    public int getTradeItemTier(Item item) {
        return (Integer)this.tradeItems.get(item).first();
    }

    public boolean isAirTradeItem(Item item) {
        return ((String)this.tradeItems.get(item).second()).equals("air");
    }

    public boolean isFireTradeItem(Item item) {
        return ((String)this.tradeItems.get(item).second()).equals("fire");
    }

    public boolean isBisonFood(Item item) {
        return this.bisonFoodList.containsKey(item);
    }

    public MobDrops getMobDropInfo(Entity entity) {
        return ConfigMobs.MOBS_CONFIG.scrollDrops.get(entity.getClass());
    }

    static {
        TRADE_ITEMS.put("minecraft:diamond 2", "all");
        TRADE_ITEMS.put("minecraft:gold_ingot 1", "all");
        TRADE_ITEMS.put("minecraft:emerald 3", "all");
        TRADE_ITEMS.put("minecraft:elytra 5", "air");
        TRADE_ITEMS.put("minecraft:dragon_breath 6", "air");
        TRADE_ITEMS.put("minecraft:totem_of_undying 4", "air");
        TRADE_ITEMS.put("minecraft:magma_cream 2", "fire");
        TRADE_ITEMS.put("minecraft:blaze_rod 1", "fire");
        DEFAULT_FOODS.put("minecraft:bread", 5);
        DEFAULT_FOODS.put("minecraft:hay_block", 75);
        DEFAULT_FOODS.put("minecraft:wheat", 8);
        DEFAULT_FOODS.put("minecraft:grass", 9);
        DEFAULT_FOODS.put("minecraft:leaves", 3);
        DEFAULT_FOODS.put("minecraft:leaves2", 3);
        DEFAULT_FOODS.put("minecraft:carrot", 6);
        DEFAULT_FOODS.put("minecraft:golden_carrot", 30);
        DEFAULT_FOODS.put("minecraft:potato", 6);
        DEFAULT_FOODS.put("minecraft:baked_potato", 5);
        DEFAULT_FOODS.put("minecraft:apple", 10);
        DEFAULT_FOODS.put("minecraft:beetroot", 8);
        DEFAULT_FOODS.put("minecraft:cake", 45);
        DEFAULT_FOODS.put("minecraft:sugar", 2);
        DEFAULT_SCROLL_DROPS.put("zombie_pigman", new MobDrops("zombie_pigman", new DropInfo(Scrolls.ScrollType.FIRE, 1, 20.0, 2), new DropInfo(Scrolls.ScrollType.FIRE, 2, 10.0), new DropInfo(Scrolls.ScrollType.FIRE, 3, 5.0), new DropInfo(Scrolls.ScrollType.FIRE, 4, 2.5)));
        DEFAULT_SCROLL_DROPS.put("magma_cube", new MobDrops("magma_cube", new DropInfo(Scrolls.ScrollType.FIRE, 1, 25.0, 3), new DropInfo(Scrolls.ScrollType.FIRE, 2, 15.0, 2), new DropInfo(Scrolls.ScrollType.FIRE, 3, 2.5)));
        DEFAULT_SCROLL_DROPS.put("wither_skeleton", new MobDrops("wither_skeleton", new DropInfo(Scrolls.ScrollType.FIRE, 1, 30.0, 3), new DropInfo(Scrolls.ScrollType.FIRE, 2, 15.0), new DropInfo(Scrolls.ScrollType.FIRE, 3, 10.0), new DropInfo(Scrolls.ScrollType.FIRE, 4, 5.0), new DropInfo(Scrolls.ScrollType.FIRE, 5, 1.0)));
        DEFAULT_SCROLL_DROPS.put("ghast", new MobDrops("ghast", new DropInfo(Scrolls.ScrollType.FIRE, 1, 40.0), new DropInfo(Scrolls.ScrollType.FIRE, 2, 20.0)));
        DEFAULT_SCROLL_DROPS.put("blaze", new MobDrops("blaze", new DropInfo(Scrolls.ScrollType.FIRE, 1, 20.0, 3), new DropInfo(Scrolls.ScrollType.FIRE, 2, 10.0, 2), new DropInfo(Scrolls.ScrollType.FIRE, 3, 5.0, 2), new DropInfo(Scrolls.ScrollType.FIRE, 4, 2.5, 2), new DropInfo(Scrolls.ScrollType.FIRE, 5, 0.5)));
        DEFAULT_SCROLL_DROPS.put("bat", new MobDrops("bat", new DropInfo(Scrolls.ScrollType.AIR, 1, 5.0), new DropInfo(Scrolls.ScrollType.AIR, 2, 1.0)));
        DEFAULT_SCROLL_DROPS.put("parrot", new MobDrops("parrot", new DropInfo(Scrolls.ScrollType.AIR, 1, 5.0)));
        DEFAULT_SCROLL_DROPS.put("chicken", new MobDrops("chicken", new DropInfo(Scrolls.ScrollType.AIR, 1, 7.5)));
        DEFAULT_SCROLL_DROPS.put("sheep", new MobDrops("sheep", new DropInfo(Scrolls.ScrollType.AIR, 1, 5.0)));
        DEFAULT_SCROLL_DROPS.put("shulker", new MobDrops("shulker", new DropInfo(Scrolls.ScrollType.AIR, 1, 40.0, 4), new DropInfo(Scrolls.ScrollType.AIR, 2, 20.0, 3), new DropInfo(Scrolls.ScrollType.AIR, 3, 10.0, 2), new DropInfo(Scrolls.ScrollType.AIR, 4, 5.0), new DropInfo(Scrolls.ScrollType.AIR, 5, 2.5), new DropInfo(Scrolls.ScrollType.AIR, 6, 1.0)));
        DEFAULT_SCROLL_DROPS.put("mooshroom", new MobDrops("mooshroom", new DropInfo(Scrolls.ScrollType.EARTH, 1, 5.0), new DropInfo(Scrolls.ScrollType.EARTH, 2, 2.5)));
        DEFAULT_SCROLL_DROPS.put("cave_spider", new MobDrops("cave_spider", new DropInfo(Scrolls.ScrollType.EARTH, 1, 10.0, 2), new DropInfo(Scrolls.ScrollType.EARTH, 1, 5.0, 1)));
        DEFAULT_SCROLL_DROPS.put("silverfish", new MobDrops("silverfish", new DropInfo(Scrolls.ScrollType.EARTH, 1, 12.5, 2), new DropInfo(Scrolls.ScrollType.EARTH, 2, 5.0), new DropInfo(Scrolls.ScrollType.EARTH, 3, 2.5)));
        DEFAULT_SCROLL_DROPS.put("spider", new MobDrops("spider", new DropInfo(Scrolls.ScrollType.EARTH, 1, 5.0), new DropInfo(Scrolls.ScrollType.EARTH, 2, 1.0)));
        DEFAULT_SCROLL_DROPS.put("skeleton", new MobDrops("skeleton", new DropInfo(Scrolls.ScrollType.EARTH, 1, 7.5), new DropInfo(Scrolls.ScrollType.EARTH, 2, 5.0), new DropInfo(Scrolls.ScrollType.EARTH, 3, 1.0)));
        DEFAULT_SCROLL_DROPS.put("zombie", new MobDrops("zombie", new DropInfo(Scrolls.ScrollType.EARTH, 1, 5.0), new DropInfo(Scrolls.ScrollType.EARTH, 2, 2.5), new DropInfo(Scrolls.ScrollType.EARTH, 3, 1.0)));
        DEFAULT_SCROLL_DROPS.put("husk", new MobDrops("husk", new DropInfo(Scrolls.ScrollType.EARTH, 1, 10.0, 2), new DropInfo(Scrolls.ScrollType.EARTH, 2, 7.5, 2), new DropInfo(Scrolls.ScrollType.EARTH, 3, 5.0)));
        DEFAULT_SCROLL_DROPS.put("creeper", new MobDrops("creeper", new DropInfo(Scrolls.ScrollType.LIGHTNING, 1, 1.0)));
        DEFAULT_SCROLL_DROPS.get("creeper").addDropInfo(new DropInfo(Scrolls.ScrollType.COMBUSTION, 1, 2.5), new DropInfo(Scrolls.ScrollType.COMBUSTION, 2, 0.5));
        DEFAULT_SCROLL_DROPS.get("blaze").addDropInfo(new DropInfo(Scrolls.ScrollType.COMBUSTION, 1, 10.0, 2), new DropInfo(Scrolls.ScrollType.COMBUSTION, 2, 5.0), new DropInfo(Scrolls.ScrollType.COMBUSTION, 3, 1.0));
        DEFAULT_SCROLL_DROPS.get("ghast").addDropInfo(new DropInfo(Scrolls.ScrollType.COMBUSTION, 1, 25.0, 3), new DropInfo(Scrolls.ScrollType.COMBUSTION, 2, 15.0, 2), new DropInfo(Scrolls.ScrollType.COMBUSTION, 3, 5.0));
        DEFAULT_SCROLL_DROPS.put("husk", new MobDrops("husk", new DropInfo(Scrolls.ScrollType.SAND, 1, 15.0), new DropInfo(Scrolls.ScrollType.SAND, 2, 5.0)));
        DEFAULT_SCROLL_DROPS.put("witch", new MobDrops("witch", new DropInfo(Scrolls.ScrollType.ALL, 1, 10.0, 2), new DropInfo(Scrolls.ScrollType.ALL, 2, 5.0, 2), new DropInfo(Scrolls.ScrollType.ALL, 3, 2.5)));
        DEFAULT_SCROLL_DROPS.put("enderman", new MobDrops("enderman", new DropInfo(Scrolls.ScrollType.ALL, 1, 25.0, 3), new DropInfo(Scrolls.ScrollType.ALL, 2, 15.0, 2), new DropInfo(Scrolls.ScrollType.ALL, 3, 10.0), new DropInfo(Scrolls.ScrollType.ALL, 4, 2.5)));
        DEFAULT_SCROLL_DROPS.get("creeper").addDropInfo(new DropInfo(Scrolls.ScrollType.ALL, 1, 15.0), new DropInfo(Scrolls.ScrollType.ALL, 2, 7.5));
        DEFAULT_SCROLL_DROPS.get("zombie").addDropInfo(new DropInfo(Scrolls.ScrollType.ALL, 1, 10.0), new DropInfo(Scrolls.ScrollType.ALL, 2, 5.0));
        DEFAULT_SCROLL_DROPS.get("skeleton").addDropInfo(new DropInfo(Scrolls.ScrollType.ALL, 1, 10.0), new DropInfo(Scrolls.ScrollType.ALL, 2, 5.0));
        DEFAULT_SCROLL_DROPS.put("ender_dragon", new MobDrops("ender_dragon", new DropInfo(Scrolls.ScrollType.ALL, 1, 75.0, 7), new DropInfo(Scrolls.ScrollType.ALL, 2, 65.0, 6), new DropInfo(Scrolls.ScrollType.ALL, 3, 55.0, 5), new DropInfo(Scrolls.ScrollType.ALL, 4, 45.0, 4), new DropInfo(Scrolls.ScrollType.ALL, 5, 35.0, 3), new DropInfo(Scrolls.ScrollType.ALL, 6, 25.0, 2), new DropInfo(Scrolls.ScrollType.ALL, 7, 15.0, 1)));
    }

    public static class BisonSettings {
        @Load
        public int bisonMinDomestication = 500;
        @Load
        public int bisonMaxDomestication = 800;
        @Load
        public int bisonRiderTameness = 800;
        @Load
        public int bisonOwnableTameness = 900;
        @Load
        public int bisonLeashTameness = 1000;
        @Load
        public int bisonChestTameness = 1000;
        @Load
        public int bisonGrassFoodBonus = 5;
        @Load
        public int bisonRideOneSecondTameness = 3;
        @Load
        public float bisonBreedMinMinutes = 60.0f;
        @Load
        public float bisonBreedMaxMinutes = 120.0f;
        @Load
        public boolean airBisonCanBeSterile = false;
        @Load
        public boolean airBisonSpawnNaturally = true;
    }

    public static class ScrollSettings {
        @Load
        public final boolean chaos = false;
        @Load
        public final boolean absoluteChaos = false;
    }

    public static class BenderSettings {
        @Load
        public final int maxNumberOfBenders = 3;
        @Load
        public final int maxLevel = 7;
    }
}

