/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.config;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.gorecore.config.ConfigLoader;
import com.crowsofwar.gorecore.config.Load;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;

public class ConfigStats {
    public static final ConfigStats STATS_CONFIG = new ConfigStats();
    @Load
    public AttackSettings floatingBlockSettings = new AttackSettings(2.0f, 1.0);
    @Load
    public AttackSettings ravineSettings = new AttackSettings(3.5f, 0.25);
    @Load
    public AttackSettings waveSettings = new AttackSettings(0.25f, 2.0);
    @Load
    public AttackSettings airbladeSettings = new AttackSettings(3.5f, 0.5);
    @Load
    public AttackSettings fireBlastSettings = new AttackSettings(2.5f, 1.0);
    @Load
    public AttackSettings flamethrowerSettings = new AttackSettings(0.75f, 0.5);
    @Load
    public AttackSettings waterArcSettings = new AttackSettings(3.0f, 1.0);
    @Load
    public AttackSettings boulderSettings = new AttackSettings(0.1f, 0.1);
    @Load
    public AttackSettings fireShotSetttings = new AttackSettings(1.0f, 0.5);
    @Load
    public AttackSettings lightningSpearSettings = new AttackSettings(4.0f, 2.0);
    @Load
    public double wallWaitTime = 10.0;
    @Load
    public double wallMomentum = 10.0;
    @Load
    public int wallJumpDelay = 10;
    @Load
    public float waterArcTicks = 120.0f;
    @Load
    public AirBurstSettings airBurstSettings = new AirBurstSettings();
    @Load
    public CloudburstSettings cloudburstSettings = new CloudburstSettings();
    @Load
    public ExplosionSettings explosionSettings = new ExplosionSettings();
    @Load
    public EarthspikeSettings earthspikeSettings = new EarthspikeSettings();
    @Load
    public FlameStrikeSettings flameStrikeSettings = new FlameStrikeSettings();
    @Load
    public FireballSettings fireballSettings = new FireballSettings();
    @Load
    public LightningRazeSettings lightningRazeSettings = new LightningRazeSettings();
    @Load
    public PassiveSettings passiveSettings = new PassiveSettings();
    @Load
    public WaterCannonSettings waterCannonSettings = new WaterCannonSettings();
    @Load
    public float chiAirblade = 1.0f;
    @Load
    public float chiAirGust = 0.5f;
    @Load
    public float chiAirJump = 0.4f;
    @Load
    public float chiAirBubble = 1.5f;
    @Load
    public float chiAirBurst = 4.0f;
    @Load
    public float chiAirBubbleTakeDamage = 0.25f;
    @Load
    public float chiAirBubbleOneSecond = 0.125f;
    @Load
    public float chiBuff = 2.0f;
    @Load
    public float chiBuffLvl2 = 3.0f;
    @Load
    public float chiBuffLvl3 = 3.5f;
    @Load
    public float chiBuffLvl4 = 4.0f;
    @Load
    public float chiBoulderRing = 3.0f;
    @Load
    public float chiCloudburst = 2.5f;
    @Load
    public float chiEarthspike = 3.5f;
    @Load
    public float chiExplosion = 3.0f;
    @Load
    public float chiExplosionUpgraded = 4.5f;
    @Load
    public float chiExplosivePillar = 4.0f;
    @Load
    public float chiRavine = 1.5f;
    @Load
    public float chiRavineLvl4_1 = 2.25f;
    @Load
    public float chiWall = 2.5f;
    @Load
    public float chiPushWall = 4.0f;
    @Load
    public float chiPickUpBlock = 1.25f;
    @Load
    public float chiMining = 2.0f;
    @Load
    public float chiMiningMaster = 0.5f;
    @Load
    public float chiFlameStrike = 2.0f;
    @Load
    public float chiFireball = 2.0f;
    @Load
    public float chiFlamethrowerSecond = 2.5f;
    @Load
    public float chiFlamethrowerSecondLvl4_1 = 3.75f;
    @Load
    public float chiFlamethrowerSecondLvl4_2 = 4.25f;
    @Load
    public float chiFireShot = 2.5f;
    @Load
    public float chiWave = 2.0f;
    @Load
    public float chiWaterArc = 1.0f;
    @Load
    public float chiWaterBubble = 1.25f;
    @Load
    public float chiWaterSkateSecond = 1.5f;
    @Load
    public float chiWallOneSecond = 0.125f;
    @Load
    public float chiPrison = 5.0f;
    @Load
    public float chiSandPrison = 3.0f;
    @Load
    public float chiLightning = 6.0f;
    @Load
    public float chiLightningSpear = 4.0f;
    @Load
    public float chiLightningRaze = 5.0f;
    @Load
    public float chiIceShieldCreate = 4.0f;
    @Load
    public float chiIceShieldProtect = 0.15f;
    @Load
    public float chiInfernoPunch = 3.0f;
    @Load
    public float chiSmallInfernoPunch = 2.0f;
    @Load
    public float chiLargeInfernoPunch = 6.0f;
    @Load
    public float chiSandstorm = 3.0f;
    @Load
    public float chiShockwave = 6.0f;
    @Load
    public float chiWaterCannon = 5.0f;
    @Load
    public float chiFireJump = 2.0f;
    @Load
    public float icePrisonDamage = 2.0f;
    @Load
    public float sleepChiRegen = 99999.0f;
    @Load
    public boolean allowAirBubbleElytra = false;
    @Load
    public double waterArcSearchRadius = 4.0;
    @Load
    public double waterArcAngles = 8.0;
    @Load
    public double waterBubbleSearchRadius = 5.0;
    @Load
    public double waterBubbleAngles = 8.0;
    @Load
    public double cleanseSearchRadius = 5.0;
    @Load
    public double cleanseAngles = 10.0;
    @Load
    public double fireSearchRadius = 4.0;
    @Load
    public double fireAngles = 8.0;
    @Load
    public boolean shiftActivateFireDevour = true;
    @Load
    public boolean addDungeonLoot = true;
    @Load
    public boolean preventEarthGriefing = false;
    @Load
    public float cleanseChiGroupBonus = 2.0f;
    @Load
    public boolean allowMultiAirbendingWalljump = false;
    @Load
    public boolean enableAutoModCompat = true;
    @Load
    public List<String> sandBlocksNames = Arrays.asList("minecraft:sand", "minecraft:gravel");
    @Load
    public List<String> bendableBlocksNames = Arrays.asList("minecraft:stone", "minecraft:sand", "minecraft:sandstone", "minecraft:cobblestone", "minecraft:dirt", "minecraft:gravel", "minecraft:brick_block", "minecraft:mossy_cobblestone", "minecraft:stonebrick", "minecraft:stone_slab", "minecraft:clay", "minecraft:hardened_clay", "minecraft:stained_hardened_clay", "minecraft:coal_ore", "minecraft:iron_ore", "minecraft:emerald_ore", "minecraft:diamond_ore", "minecraft:gold_ore", "minecraft:lapis_ore", "minecraft:redstone_ore", "minecraft:red_sandstone", "minecraft:grass", "minecraft:grass_path");
    @Load
    public List<String> waterBendableBlockNames = Arrays.asList("minecraft:snow", "minecraft:snow_layer", "minecraft:ice", "minecraft:packed_ice", "minecraft:frosted_ice", "minecraft:water", "minecraft:flowing_water");
    @Load
    public List<String> iceBendableBlockNames = Arrays.asList("minecraft:snow", "minecraft:snow_layer", "minecraft:ice", "minecraft:packed_ice", "minecraft:frosted_ice");
    @Load
    public List<String> plantBendableBlockNames = Arrays.asList("minecraft:tallgrass", "minecraft:wheat", "minecraft:double_grass", "minecraft:waterlily", "minecraft:red_flower", "minecraft:double_plant", "minecraft:leaves", "minecraft:yellow_flower", "minecraft:red_mushroom", "minecraft:brown_mushroom", "minecraft:vine");
    @Load
    public List<String> airBladeBreakableBlockNames = Arrays.asList("minecraft:stone", "minecraft:sand", "minecraft:sandstone", "minecraft:cobblestone", "minecraft:dirt", "minecraft:gravel", "minecraft:brick_block", "minecraft:mossy_cobblestone", "minecraft:stonebrick", "minecraft:clay", "minecraft:hardened_clay", "minecraft:stained_hardened_clay", "minecraft:coal_ore", "minecraft:iron_ore", "minecraft:red_sandstone", "minecraft:grass", "minecraft:grass_path");
    @Load
    public List<String> waterArcBreakableBlockNames = Arrays.asList("minecraft:stone", "minecraft:sand", "minecraft:sandstone", "minecraft:cobblestone", "minecraft:dirt", "minecraft:gravel", "minecraft:brick_block", "minecraft:mossy_cobblestone", "minecraft:stonebrick", "minecraft:clay", "minecraft:hardened_clay", "minecraft:stained_hardened_clay", "minecraft:coal_ore", "minecraft:iron_ore", "minecraft:red_sandstone", "minecraft:grass", "minecraft:grass_path");
    public List<Block> plantBendableBlocks;
    public List<Block> waterBendableBlocks;
    public List<Block> bendableBlocks;
    public List<Block> sandBlocks;
    public List<Block> airBladeBreakableBlocks;
    public List<Block> iceBendableBlocks;
    public List<Block> waterArcBreakableBlocks;

    private ConfigStats() {
    }

    public static void load() {
        ConfigLoader.load(STATS_CONFIG, "avatar/stats.yml");
    }

    public void loadBlocks() {
        this.bendableBlocks = STATS_CONFIG.loadBlocksList(this.bendableBlocksNames);
        this.airBladeBreakableBlocks = STATS_CONFIG.loadBlocksList(this.airBladeBreakableBlockNames);
        this.sandBlocks = STATS_CONFIG.loadBlocksList(this.sandBlocksNames);
        this.waterBendableBlocks = STATS_CONFIG.loadBlocksList(this.waterBendableBlockNames);
        this.plantBendableBlocks = STATS_CONFIG.loadBlocksList(this.plantBendableBlockNames);
        this.iceBendableBlocks = STATS_CONFIG.loadBlocksList(this.iceBendableBlockNames);
        this.waterArcBreakableBlocks = STATS_CONFIG.loadBlocksList(this.waterArcBreakableBlockNames);
    }

    private List<Block> loadBlocksList(List<String> blocksNames) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (String blockName : blocksNames) {
            Block b = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockName));
            if (b == null) {
                AvatarLog.warn(AvatarLog.WarningType.CONFIGURATION, "Invalid blocks entry: " + blockName + "; this block does not exist");
                continue;
            }
            blocks.add(b);
        }
        return blocks;
    }

    public static class PassiveSettings {
        @Load
        public boolean waterBreathing = true;
        @Load
        public boolean hasteInWater = true;
        @Load
        public boolean fireResistance = true;
        @Load
        public boolean noFallDamageAir = true;
        @Load
        public boolean knockbackResistanceEarth = true;
    }

    public static class ExplosionSettings {
        @Load
        public float damage = 6.0f;
        @Load
        public int fireTime = 2;
        @Load
        public float explosionSize = 1.0f;
        @Load
        public boolean damageBlocks = false;
        @Load
        public double push = 1.0;
    }

    public static class LightningRazeSettings {
        @Load
        public float accuracy = 1.0f;
        @Load
        public float frequency = 5.0f;
        @Load
        public int bolts = 1;
        @Load
        public int ticks = 20;
        @Load
        public float damage = 2.0f;
        @Load
        public double speed = 5.0;
    }

    public static class WaterCannonSettings {
        @Load
        public boolean useWaterCannonParticles = true;
        @Load
        public double waterCannonSearchRadius = 3.0;
        @Load
        public double waterCannonAngles = 8.0;
        @Load
        public double waterCannonDamage = 1.0;
        @Load
        public double waterCannonKnockbackMult = 1.0;
    }

    public static class EarthspikeSettings {
        @Load
        public double damage = 3.0;
        @Load
        public float frequency = 4.0f;
        @Load
        public float size = 1.0f;
        @Load
        public double push = 0.5;
    }

    public static class CloudburstSettings {
        @Load
        public double damage = 3.0;
        @Load
        public double push = 1.5;
    }

    public static class AirBurstSettings {
        @Load
        public float damage = 4.0f;
        @Load
        public float push = 2.0f;
        @Load
        public float radius = 4.0f;
        @Load
        public float durationToFire = 40.0f;
        @Load
        public int performanceAmount = 12;
        @Load
        public float beamDamage = 6.0f;
        @Load
        public float beamPush = 20.0f;
        @Load
        public float beamSize = 1.0f;
        @Load
        public int beamRange = 10;
    }

    public static class FireballSettings {
        @Load
        public float damage = 3.5f;
        @Load
        public int fireTime = 6;
        @Load
        public float explosionSize = 1.0f;
        @Load
        public boolean damageBlocks = false;
        @Load
        public double push = 1.25;
    }

    public static class FlameStrikeSettings {
        @Load
        public int strikeNumber = 2;
        @Load
        public float size = 1.75f;
        @Load
        public int chargeDuration = 40;
        @Load
        public float damage = 2.0f;
        @Load
        public float knockback = 2.0f;
        @Load
        public int performanceAmount = 6;
        @Load
        public int fireTime = 3;
        @Load
        public float maxDistance = 3.0f;
    }

    public static class AttackSettings {
        @Load
        public float damage;
        @Load
        public double push;

        public AttackSettings() {
        }

        private AttackSettings(float damage, double push) {
            this.damage = damage;
            this.push = push;
        }
    }
}

