/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.config;

import com.crowsofwar.avatar.config.DropInfo;
import com.crowsofwar.avatar.item.scroll.Scrolls;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class MobDrops {
    private final String mobName;
    private DropInfo[] dropInformation;
    private Class<? extends Entity> mob;

    public MobDrops(Class<? extends Entity> clazz, DropInfo ... info) {
        this.mob = clazz;
        this.mobName = this.mob.getName();
        this.dropInformation = info;
    }

    public MobDrops(String mobName, DropInfo ... info) {
        this.mobName = mobName;
        this.mob = MobDrops.getClassFromName(mobName);
        this.dropInformation = info;
    }

    public static Class<? extends Entity> getClassFromName(String name) {
        EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(name));
        return entry == null ? null : entry.getEntityClass();
    }

    public static MobDrops fromCollections(Class<? extends Entity> clazz, Collection<String> scrollTypes, Collection<Integer> dropAmounts, Collection<Integer> dropTiers, Collection<Double> dropChances) {
        DropInfo[] info = new DropInfo[scrollTypes.size()];
        int i = 0;
        for (DropInfo dropInfo : info) {
            info[i] = new DropInfo(Scrolls.ScrollType.ALL, 1, 1.0, 1);
            ++i;
        }
        i = 0;
        for (String s : scrollTypes) {
            info[i].setType(Scrolls.ScrollType.getTypeFromString(s));
            ++i;
        }
        i = 0;
        for (Integer num : dropAmounts) {
            info[i].setAmount(num);
            ++i;
        }
        i = 0;
        for (Integer num : dropTiers) {
            info[i].setTier(num);
            ++i;
        }
        i = 0;
        for (Double num : dropChances) {
            info[i].setDropChance(num);
            ++i;
        }
        return new MobDrops(clazz, info);
    }

    public static MobDrops fromCollections(String mobName, Collection<String> scrollTypes, Collection<Integer> dropAmounts, Collection<Integer> dropTiers, Collection<Double> dropChances) {
        DropInfo[] info = new DropInfo[scrollTypes.size()];
        int i = 0;
        for (DropInfo dropInfo : info) {
            info[i] = new DropInfo(Scrolls.ScrollType.ALL, 1, 1.0, 1);
            ++i;
        }
        i = 0;
        for (String s : scrollTypes) {
            info[i].setType(Scrolls.ScrollType.getTypeFromString(s));
            ++i;
        }
        i = 0;
        for (Integer num : dropAmounts) {
            info[i].setAmount(num);
            ++i;
        }
        i = 0;
        for (Integer num : dropTiers) {
            info[i].setTier(num);
            ++i;
        }
        i = 0;
        for (Double num : dropChances) {
            info[i].setDropChance(num);
            ++i;
        }
        return new MobDrops(mobName, info);
    }

    public void addDropInfo(DropInfo ... info) {
        LinkedList<DropInfo> dropInfo = new LinkedList<DropInfo>(Arrays.asList(this.getDropInformation()));
        LinkedList<DropInfo> newInfo = new LinkedList<DropInfo>(Arrays.asList(info));
        dropInfo.addAll(newInfo);
        this.dropInformation = dropInfo.toArray(new DropInfo[0]);
    }

    public Class<? extends Entity> getMob() {
        return this.mob;
    }

    public void setMob(Class<? extends Entity> mob) {
        this.mob = mob;
    }

    public DropInfo[] getDropInformation() {
        return this.dropInformation;
    }

    public Collection<String> getReducedDropTypes() {
        Scrolls.ScrollType currentType = Scrolls.ScrollType.ALL;
        String[] allTypes = new String[this.dropInformation.length];
        int diffTypes = 0;
        for (int i = 0; i < this.dropInformation.length; ++i) {
            if (this.dropInformation[i].getType().equals(currentType)) continue;
            currentType = this.dropInformation[i].getType();
            allTypes[i] = currentType.getBendingName();
            ++diffTypes;
        }
        String[] types = new String[diffTypes];
        int i = 0;
        for (String type : allTypes) {
            if (type == null) continue;
            types[i] = type;
            ++i;
        }
        return Arrays.stream(types).collect(Collectors.toList());
    }

    public Collection<String> getDropTypes() {
        String[] allTypes = new String[this.dropInformation.length];
        for (int i = 0; i < this.dropInformation.length; ++i) {
            allTypes[i] = this.dropInformation[i].getType().getBendingName();
        }
        return Arrays.stream(allTypes).collect(Collectors.toList());
    }

    public Collection<Integer> getDropAmounts() {
        Integer[] chances = new Integer[this.dropInformation.length];
        for (int i = 0; i < this.dropInformation.length; ++i) {
            chances[i] = this.dropInformation[i].getAmount();
        }
        return Arrays.stream(chances).collect(Collectors.toList());
    }

    public Collection<Integer> getDropTiers() {
        Integer[] chances = new Integer[this.dropInformation.length];
        for (int i = 0; i < this.dropInformation.length; ++i) {
            chances[i] = this.dropInformation[i].getTier();
        }
        return Arrays.stream(chances).collect(Collectors.toList());
    }

    public Collection<Double> getDropChances() {
        Double[] chances = new Double[this.dropInformation.length];
        for (int i = 0; i < this.dropInformation.length; ++i) {
            chances[i] = this.dropInformation[i].getDropChance();
        }
        return Arrays.stream(chances).collect(Collectors.toList());
    }

    public Map.Entry<String, Collection<String>> getScrollTypeEntry() {
        return new AbstractMap.SimpleEntry<String, Collection<String>>(this.mob.getName(), this.getDropTypes());
    }

    public Map.Entry<String, Collection<Integer>> getDropAmountEntry() {
        return new AbstractMap.SimpleEntry<String, Collection<Integer>>(this.mob.getName(), this.getDropAmounts());
    }

    public Map.Entry<String, Collection<Integer>> getDropTierEntry() {
        return new AbstractMap.SimpleEntry<String, Collection<Integer>>(this.mob.getName(), this.getDropTiers());
    }

    public Map.Entry<String, Collection<Double>> getDropChanceEntry() {
        return new AbstractMap.SimpleEntry<String, Collection<Double>>(this.mob.getName(), this.getDropChances());
    }

    public String getMobName() {
        return this.mobName;
    }
}

