/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.data.SyncedEntity;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AvatarWorldData;
import com.crowsofwar.gorecore.util.Vector;
import com.google.common.base.Optional;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class AvatarEntity
extends Entity {
    private static final DataParameter<Integer> SYNC_ID = EntityDataManager.func_187226_a(AvatarEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> SYNC_OWNER = EntityDataManager.func_187226_a(AvatarEntity.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<String> SYNC_ABILITY = EntityDataManager.func_187226_a(AvatarEntity.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> SYNC_TIER = EntityDataManager.func_187226_a(AvatarEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    private final SyncedEntity<EntityLivingBase> ownerRef = new SyncedEntity(this, SYNC_OWNER);
    private final IBlockState prevDoorState = null;
    protected boolean putsOutFires = false;
    protected boolean flammable = false;
    protected boolean pushStoneButton;
    protected boolean pushTrapDoor;
    protected boolean pushDoor;
    protected boolean pushRedstone = false;
    protected boolean setsFires = false;
    protected boolean lightTnt = false;
    private double powerRating;
    private BendingStyle element = null;
    private BlockPos prevLeverPos = null;
    private BlockPos prevDoorPos = null;
    private BlockPos prevTrapdoorPos = null;
    private BlockPos prevButtonPos = null;
    private BlockPos prevGatePos = null;
    private IBlockState prevLeverState = null;
    private IBlockState prevTrapdoorState = null;
    private IBlockState prevButtonState = null;
    private IBlockState prevGateState = null;

    public AvatarEntity(World world) {
        super(world);
    }

    public static <T extends AvatarEntity> T lookupEntity(World world, int id) {
        List entities = world.func_175644_a(AvatarEntity.class, ent -> ent.getAvId() == id);
        return (T)((Object)(entities.isEmpty() ? null : (AvatarEntity)((Object)entities.get(0))));
    }

    public static <T extends AvatarEntity> T lookupEntity(World world, Class<T> cls, Predicate<T> predicate) {
        List entities = world.field_72996_f;
        for (Entity ent : entities) {
            if (!ent.getClass().isAssignableFrom(cls) || !predicate.test((AvatarEntity)ent)) continue;
            return (T)((Object)((AvatarEntity)ent));
        }
        return null;
    }

    public static <T extends AvatarEntity> T lookupControlledEntity(World world, Class<T> cls, EntityLivingBase controller) {
        List list = world.func_175644_a(cls, ent -> ent.getController() == controller);
        return (T)((Object)(list.isEmpty() ? null : (AvatarEntity)((Object)list.get(0))));
    }

    public static <T extends AvatarEntity> T lookupOwnedEntity(World world, Class<T> cls, EntityLivingBase owner) {
        List list = world.func_175644_a(cls, ent -> ent.getOwner() == owner);
        return (T)((Object)(list.isEmpty() ? null : (AvatarEntity)((Object)list.get(0))));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SYNC_ID, (Object)(this.field_70170_p.field_72995_K ? -1 : AvatarWorldData.getDataFromWorld(this.field_70170_p).nextEntityId()));
        this.field_70180_af.func_187214_a(SYNC_OWNER, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SYNC_ABILITY, (Object)"earth_control");
        this.field_70180_af.func_187214_a(SYNC_TIER, (Object)1);
    }

    @Nullable
    public EntityLivingBase getOwner() {
        return this.ownerRef.getEntity();
    }

    public void setOwner(@Nullable EntityLivingBase owner) {
        this.ownerRef.setEntity(owner);
    }

    public boolean hasOwner() {
        return this.ownerRef.getEntityId() != null;
    }

    public EntityLivingBase getController() {
        return null;
    }

    public Vector velocity() {
        return Vector.getVelocity(this);
    }

    public void addVelocity(Vector velocity) {
        this.field_70159_w += velocity.x() / 20.0;
        this.field_70181_x += velocity.y() / 20.0;
        this.field_70179_y += velocity.z() / 20.0;
    }

    public void addVelocity(Vec3d velocity) {
        this.field_70159_w += velocity.field_72450_a;
        this.field_70181_x += velocity.field_72448_b;
        this.field_70179_y += velocity.field_72449_c;
    }

    public Vec3d getVelocity() {
        return new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public void setVelocity(Vector velocity) {
        this.field_70159_w = velocity.x() / 20.0;
        this.field_70181_x = velocity.y() / 20.0;
        this.field_70179_y = velocity.z() / 20.0;
    }

    public void setVelocity(Vec3d velocity) {
        this.field_70159_w = velocity.field_72450_a;
        this.field_70181_x = velocity.field_72448_b;
        this.field_70179_y = velocity.field_72449_c;
    }

    public Vector position() {
        return Vector.getEntityPos(this);
    }

    public void setPosition(Vector position) {
        this.func_70107_b(position.x(), position.y(), position.z());
    }

    public void setPosition(Vec3d position) {
        this.func_70107_b(position.field_72450_a, position.field_72448_b, position.field_72449_c);
    }

    public void setPosition(BlockPos position) {
        this.func_70107_b(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
    }

    public int getAvId() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_ID);
    }

    private void setAvId(int id) {
        this.field_70180_af.func_187227_b(SYNC_ID, (Object)id);
    }

    public double getPowerRating() {
        return this.powerRating;
    }

    public void setPowerRating(double powerRating) {
        this.powerRating = powerRating;
    }

    public Ability getAbility() {
        return Abilities.get((String)this.field_70180_af.func_187225_a(SYNC_ABILITY));
    }

    public void setAbility(Ability ability) {
        this.field_70180_af.func_187227_b(SYNC_ABILITY, (Object)ability.getName());
    }

    public void setPushRedstone(boolean push) {
        this.pushRedstone = push;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setAvId(nbt.func_74762_e("AvId"));
        this.pushStoneButton = nbt.func_74767_n("PushStoneButton");
        this.pushTrapDoor = nbt.func_74767_n("PushIronTrapDoor");
        this.pushDoor = nbt.func_74767_n("PushIronDoor");
        this.setTier(nbt.func_74762_e("Tier"));
        this.ownerRef.readFromNbt(nbt);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("AvId", this.getAvId());
        nbt.func_74757_a("PushIronDor", this.pushDoor);
        nbt.func_74757_a("PushIronTrapDoor", this.pushTrapDoor);
        nbt.func_74757_a("PushStoneButton", this.pushStoneButton);
        nbt.func_74768_a("Tier", this.getTier());
        this.ownerRef.writeToNbt(nbt);
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        return super.func_189511_e(compound);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70075_an() {
        return false;
    }

    public void Extinguish() {
        Block lava;
        BlockPos pos;
        double zPos;
        double yPos;
        double xPos;
        int y;
        int z;
        int x;
        this.func_70015_d(0);
        for (x = 0; x <= 1; ++x) {
            for (z = 0; z <= 1; ++z) {
                for (y = 0; y <= 1; ++y) {
                    xPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72450_a;
                    yPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72448_b;
                    zPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72449_c;
                    pos = new BlockPos(xPos + (double)((float)x * this.field_70130_N / 2.0f), yPos + (double)((float)y * this.field_70131_O / 2.0f), zPos + (double)((float)z * this.field_70130_N / 2.0f));
                    if (this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150480_ab) {
                        this.field_70170_p.func_175698_g(pos);
                        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
                        continue;
                    }
                    if (!(this.field_70170_p.func_180495_p(pos).func_177230_c() instanceof BlockLiquid)) continue;
                    lava = this.field_70170_p.func_180495_p(pos).func_177230_c();
                    if (lava == Blocks.field_150353_l) {
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
                        continue;
                    }
                    if (lava != Blocks.field_150356_k) continue;
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150348_b.func_176223_P());
                }
            }
        }
        for (x = 0; x >= -1; --x) {
            for (z = 0; z >= -1; --z) {
                for (y = 0; y >= -1; --y) {
                    xPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72450_a;
                    yPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72448_b;
                    zPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72449_c;
                    pos = new BlockPos(xPos + (double)((float)x * this.field_70130_N / 2.0f), yPos + (double)((float)y * this.field_70131_O / 2.0f), zPos + (double)((float)z * this.field_70130_N / 2.0f));
                    if (this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150480_ab) {
                        this.field_70170_p.func_175698_g(pos);
                        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
                        continue;
                    }
                    if (!(this.field_70170_p.func_180495_p(pos).func_177230_c() instanceof BlockLiquid)) continue;
                    lava = this.field_70170_p.func_180495_p(pos).func_177230_c();
                    if (lava == Blocks.field_150353_l) {
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
                        continue;
                    }
                    if (lava != Blocks.field_150356_k) continue;
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150348_b.func_176223_P());
                }
            }
        }
    }

    public void setFires() {
        if (!this.field_70170_p.field_72995_K) {
            BlockPos pos;
            int y;
            int z;
            int x;
            for (x = 0; x <= 1; ++x) {
                for (z = 0; z <= 1; ++z) {
                    for (y = 0; y <= 1; ++y) {
                        pos = new BlockPos(this.field_70165_t + (double)((float)x * this.field_70130_N), this.field_70163_u + (double)((float)y * this.field_70131_O), this.field_70161_v + (double)((float)z * this.field_70130_N));
                        if (!Blocks.field_150480_ab.func_176196_c(this.field_70170_p, pos) || this.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a || this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150355_j || this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150358_i) continue;
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                    }
                }
            }
            for (x = 0; x >= -1; --x) {
                for (z = 0; z >= -1; --z) {
                    for (y = 0; y >= -1; --y) {
                        pos = new BlockPos(this.field_70165_t + (double)((float)x * this.field_70130_N), this.field_70163_u + (double)((float)y * this.field_70131_O), this.field_70161_v + (double)((float)z * this.field_70130_N));
                        if (!Blocks.field_150480_ab.func_176196_c(this.field_70170_p, pos) || this.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a || this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150355_j || this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150358_i) continue;
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                    }
                }
            }
            if (this.lightTnt) {
                for (x = 0; x <= 1; ++x) {
                    for (z = 0; z <= 1; ++z) {
                        for (y = 0; y <= 1; ++y) {
                            pos = new BlockPos(this.field_70165_t + (double)((float)x * this.field_70130_N), this.field_70163_u + (double)((float)y * this.field_70131_O), this.field_70161_v + (double)((float)z * this.field_70130_N));
                            if (this.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150335_W) continue;
                            ((BlockTNT)this.field_70170_p.func_180495_p(pos).func_177230_c()).func_180692_a(this.field_70170_p, pos, this.field_70170_p.func_180495_p(pos).func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)), this.getOwner());
                        }
                    }
                }
                for (x = 0; x >= -1; --x) {
                    for (z = 0; z >= -1; --z) {
                        for (y = 0; y >= -1; --y) {
                            pos = new BlockPos(this.field_70165_t + (double)((float)x * this.field_70130_N), this.field_70163_u + (double)((float)y * this.field_70131_O), this.field_70161_v + (double)((float)z * this.field_70130_N));
                            if (this.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150335_W) continue;
                            ((BlockTNT)this.field_70170_p.func_180495_p(pos).func_177230_c()).func_180692_a(this.field_70170_p, pos, this.field_70170_p.func_180495_p(pos).func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)), this.getOwner());
                        }
                    }
                }
            }
        }
    }

    public boolean pushLevers(BlockPos pos) {
        if (this.pushLever() && (pos != this.prevLeverPos && this.prevLeverState != this.field_70170_p.func_180495_p(pos) || this.prevLeverPos == null) && AvatarUtils.pushLever(this.field_70170_p, pos)) {
            this.prevLeverPos = pos;
            this.prevLeverState = this.field_70170_p.func_180495_p(pos);
            return true;
        }
        return false;
    }

    public boolean pushButtons(BlockPos pos) {
        if (this.pushButton(this.pushStoneButton) && (pos != this.prevButtonPos && this.prevButtonState != this.field_70170_p.func_180495_p(pos) || this.prevButtonState == null) && AvatarUtils.pushButton(this.field_70170_p, this.pushStoneButton, pos)) {
            this.prevButtonPos = pos;
            this.prevButtonState = this.field_70170_p.func_180495_p(pos);
            return true;
        }
        return false;
    }

    public boolean pushTrapDoors(BlockPos pos) {
        if (this.pushTrapdoor(this.pushTrapDoor) && (pos != this.prevTrapdoorPos && this.prevTrapdoorState != this.field_70170_p.func_180495_p(pos) || this.prevTrapdoorState == null) && AvatarUtils.pushTrapDoor(this.field_70170_p, this.pushTrapDoor, pos)) {
            this.prevTrapdoorPos = pos;
            this.prevTrapdoorState = this.field_70170_p.func_180495_p(pos);
            return true;
        }
        return false;
    }

    public boolean pushDoors(BlockPos pos) {
        if (this.pushDoor(this.pushDoor) && (pos != this.prevDoorPos && this.prevDoorState != this.field_70170_p.func_180495_p(pos) || this.prevDoorState == null) && AvatarUtils.pushDoor(this, this.pushDoor, pos)) {
            this.prevDoorPos = pos;
            this.prevLeverState = this.field_70170_p.func_180495_p(pos);
            return true;
        }
        return false;
    }

    public boolean pushGates(BlockPos pos) {
        if (this.pushGate() && (pos != this.prevGatePos && this.prevGateState != this.field_70170_p.func_180495_p(pos) || this.prevGateState == null) && AvatarUtils.pushGate(this, pos)) {
            this.prevGatePos = pos;
            this.prevGateState = this.field_70170_p.func_180495_p(pos);
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        IBlockState inBlock;
        BlockPos pos;
        double zPos;
        double yPos;
        double xPos;
        double y;
        double z;
        double x;
        super.func_70071_h_();
        this.collideWithNearbyEntities();
        if (this.putsOutFires && this.field_70173_aa % 2 == 0) {
            this.Extinguish();
        }
        for (x = 0.0; x <= 1.0; x += 1.0) {
            for (z = 0.0; z <= 1.0; z += 1.0) {
                for (y = 0.0; y <= 1.0; y += 1.0) {
                    xPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72450_a;
                    yPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72448_b;
                    zPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72449_c;
                    pos = new BlockPos(xPos + x * (double)this.field_70130_N / 2.0, yPos + y * (double)this.field_70131_O / 2.0, zPos + z * (double)this.field_70130_N / 2.0);
                    this.pushLevers(pos);
                    this.pushTrapDoors(pos);
                    this.pushButtons(pos);
                    this.pushDoors(pos);
                    this.pushGates(pos);
                }
            }
        }
        for (x = 0.0; x >= -1.0; x -= 1.0) {
            for (z = 0.0; z >= -1.0; z -= 1.0) {
                for (y = 0.0; y >= -1.0; y -= 1.0) {
                    xPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72450_a;
                    yPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72448_b;
                    zPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72449_c;
                    pos = new BlockPos(xPos + x * (double)this.field_70130_N / 2.0, yPos + y * (double)this.field_70131_O / 2.0, zPos + z * (double)this.field_70130_N / 2.0);
                    this.pushLevers(pos);
                    this.pushTrapDoors(pos);
                    this.pushButtons(pos);
                    this.pushDoors(pos);
                    this.pushGates(pos);
                }
            }
        }
        if (this.getOwner() == null) {
            this.func_70106_y();
        }
        if (this.field_70132_H) {
            if (this.setsFires) {
                this.setFires();
            }
            this.onCollideWithSolid();
        }
        if (this.field_70171_ac) {
            this.onMajorWaterContact();
        }
        if (this.field_70170_p.func_175727_C(this.func_180425_c())) {
            this.onMinorWaterContact();
        }
        if (this.field_70170_p.func_147470_e(this.func_174813_aQ().func_186664_h(0.001))) {
            this.onFireContact();
        }
        if ((inBlock = this.field_70170_p.func_180495_p(this.func_180425_c())).func_177230_c() == Blocks.field_150321_G && !inBlock.func_185913_b()) {
            this.breakBlock(this.func_180425_c());
        }
        Vector v = this.velocity().dividedBy(20.0);
        this.func_70091_d(MoverType.SELF, v.x(), v.y(), v.z());
    }

    protected void collideWithNearbyEntities() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
        if (!list.isEmpty()) {
            int i = this.field_70170_p.func_82736_K().func_180263_c("maxEntityCramming");
            if (i > 0 && list.size() > i - 1 && this.field_70146_Z.nextInt(4) == 0) {
                int j = 0;
                for (Entity aList : list) {
                    if (aList.func_184218_aH() || !this.canDamageEntity(aList)) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.func_70097_a(DamageSource.field_191291_g, 6.0f);
                }
            }
            for (Entity entity : list) {
                if (!this.canCollideWith(entity) || entity == this.getOwner()) continue;
                entity.func_70108_f((Entity)this);
                this.onCollideWithEntity(entity);
            }
        }
    }

    public boolean canCollideWith(Entity entity) {
        if (entity == this.getOwner()) {
            return false;
        }
        if (entity instanceof AvatarEntity && ((AvatarEntity)entity).getOwner() == this.getOwner()) {
            return false;
        }
        if (entity instanceof EntityLivingBase && entity.func_184179_bs() == this.getOwner()) {
            return false;
        }
        if (this.getOwner() != null && this.getOwner().func_96124_cp() != null && entity.func_96124_cp() == this.getOwner().func_96124_cp()) {
            return false;
        }
        if (entity instanceof EntityEnderCrystal) {
            return true;
        }
        if (entity == this) {
            return false;
        }
        return entity.func_70104_M() && entity.func_70067_L() || entity instanceof EntityLivingBase || entity instanceof AvatarEntity;
    }

    public void func_70108_f(Entity entity) {
        if (this.canCollideWith(entity)) {
            super.func_70108_f(entity);
            this.onCollideWithEntity(entity);
        }
    }

    public void onCollideWithEntity(Entity entity) {
        if (this.putsOutFires) {
            entity.func_70066_B();
        }
    }

    public boolean onCollideWithSolid() {
        return false;
    }

    public boolean onMinorWaterContact() {
        return false;
    }

    public boolean onMajorWaterContact() {
        return false;
    }

    public boolean onFireContact() {
        return false;
    }

    public boolean onLightningContact() {
        return false;
    }

    public boolean onAirContact() {
        return false;
    }

    public boolean canPush() {
        return true;
    }

    public boolean canDamageEntity(Entity entity) {
        return this.canCollideWith(entity) && entity.func_70075_an() || entity instanceof EntityEnderCrystal;
    }

    public boolean isProjectile() {
        return false;
    }

    public boolean isShield() {
        return false;
    }

    public boolean pushButton(boolean pushStone) {
        return this.pushRedstone;
    }

    public boolean pushLever() {
        return this.pushRedstone;
    }

    public boolean pushTrapdoor(boolean pushIron) {
        return this.pushRedstone;
    }

    public boolean pushDoor(boolean pushIron) {
        return this.pushRedstone;
    }

    public boolean pushGate() {
        return this.pushRedstone;
    }

    protected void breakBlock(BlockPos position) {
        IBlockState blockState = this.field_70170_p.func_180495_p(position);
        Block destroyed = blockState.func_177230_c();
        if (!ConfigStats.STATS_CONFIG.preventEarthGriefing && !(destroyed instanceof BlockAir)) {
            SoundEvent sound = destroyed == Blocks.field_150480_ab ? SoundEvents.field_187541_bC : destroyed.func_185467_w().func_185845_c();
            this.field_70170_p.func_184133_a(null, position, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < 7; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.0 * (this.field_70146_Z.nextGaussian() - 0.5), this.field_70146_Z.nextGaussian() * 2.0 + 1.0, 3.0 * (this.field_70146_Z.nextGaussian() - 0.5), new int[]{Block.func_176210_f((IBlockState)blockState)});
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175698_g(position);
            }
            this.field_70170_p.func_180497_b(position, blockState.func_177230_c(), 0, 1);
            if (!this.field_70170_p.field_72995_K) {
                List drops = blockState.func_177230_c().getDrops((IBlockAccess)this.field_70170_p, position, blockState, 0);
                for (ItemStack stack : drops) {
                    EntityItem item = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
                    item.func_174869_p();
                    item.field_70159_w *= 2.0;
                    item.field_70181_x *= 1.2;
                    item.field_70179_y *= 2.0;
                    this.field_70170_p.func_72838_d((Entity)item);
                }
            }
        }
    }

    protected void breakBlock(BlockPos position, int hardness) {
        IBlockState blockState = this.field_70170_p.func_180495_p(position);
        Block destroyed = blockState.func_177230_c();
        if (!ConfigStats.STATS_CONFIG.preventEarthGriefing && blockState.func_185887_b(this.field_70170_p, position) <= (float)hardness && !(destroyed instanceof BlockAir)) {
            SoundEvent sound = destroyed == Blocks.field_150480_ab ? SoundEvents.field_187541_bC : destroyed.func_185467_w().func_185845_c();
            this.field_70170_p.func_184133_a(null, position, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < 7; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.0 * (this.field_70146_Z.nextGaussian() - 0.5), this.field_70146_Z.nextGaussian() * 2.0 + 1.0, 3.0 * (this.field_70146_Z.nextGaussian() - 0.5), new int[]{Block.func_176210_f((IBlockState)blockState)});
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175698_g(position);
            }
            this.field_70170_p.func_180497_b(position, blockState.func_177230_c(), 0, 1);
            if (!this.field_70170_p.field_72995_K) {
                List drops = blockState.func_177230_c().getDrops((IBlockAccess)this.field_70170_p, position, blockState, 0);
                for (ItemStack stack : drops) {
                    EntityItem item = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
                    item.func_174869_p();
                    item.field_70159_w *= 2.0;
                    item.field_70181_x *= 1.2;
                    item.field_70179_y *= 2.0;
                    this.field_70170_p.func_72838_d((Entity)item);
                }
            }
        }
    }

    protected void spawnExtinguishIndicators() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 4; ++i) {
                ParticleBuilder.create(ParticleBuilder.Type.SNOW).pos(AvatarEntityUtils.getMiddleOfEntity(this)).scale(this.field_70130_N).vel(this.field_70170_p.field_73012_v.nextGaussian() / 30.0, this.field_70170_p.field_73012_v.nextDouble(), this.field_70170_p.field_73012_v.nextGaussian() / 30.0).time(AvatarUtils.getRandomNumberInRange(8, 16)).spawn(this.field_70170_p);
            }
        }
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return this.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_90999_ad() {
        return !this.putsOutFires && this.flammable && super.func_90999_ad();
    }

    public void func_70015_d(int seconds) {
        if (!this.putsOutFires && this.flammable) {
            super.func_70015_d(seconds);
        }
    }

    public boolean shouldRenderInPass(int pass) {
        switch (this.getElement().getName()) {
            default: {
                return pass == 0;
            }
            case "firebending": 
            case "airbending": 
        }
        return pass == 1;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    public BendingStyle getElement() {
        return this.element == null ? new Airbending() : this.element;
    }

    public void setElement(BendingStyle element) {
        this.element = element;
    }

    public int getTier() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_TIER);
    }

    public void setTier(int tier) {
        this.field_70180_af.func_187227_b(SYNC_TIER, (Object)tier);
    }
}

